package com.artfess.reform.fill.manager;

import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.fill.model.BizReformSatisfactionManagement;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 满意度区县结果表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
public interface BizReformSatisfactionDistrictsManager extends BaseManager<BizReformSatisfactionDistricts> {

    boolean importExcel(List<BizReformSatisfactionDistricts> list, String satisfactionId);

    boolean batchUpdate(BizReformSatisfactionManagement t);

    /**
    * @Description: 根据满意度主表查询子表数据
    * @param satisfactionId
    * @Return: java.util.List<com.artfess.reform.fill.model.BizReformSatisfactionDistricts>
    * @Author: chens
    * @Date: 2023/3/21 13:25
    */
    List<BizReformSatisfactionDistricts> queryBySatisfactionId(String satisfactionId);


    /**
     * @Description: 根据区县编码查询该区县的5个领域的满意度
     * @param unitCode       调查区县
     * @param scoringYear    调查年度
     * @param scoringQuarter 调查季度
     * @Return: java.util.List<com.artfess.reform.fill.model.BizReformSatisfactionDistricts>
     * @Author: chens
     * @Date: 2023/5/31 14:25
     */
    List<BizReformSatisfactionDistricts> qureyFieldByUnitCode( String unitCode, Integer scoringYear,  Integer scoringQuarter);
}
