package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizReformRiskManagement;
import com.artfess.reform.fill.vo.StateVO;


public interface BizReformRiskManagementManager extends BaseManager<BizReformRiskManagement> {
    /**
     * 根据id删除
     * @param id
     */
    void removeById(String id);

    /**
     * 修改审核状态
     * @param stateVO
     */
    void updateById(StateVO stateVO);

    /**
     * 添加或者修改实体类
     * @param bizReformRiskManagement
     */
    void insertOrUpdateInfo(BizReformRiskManagement bizReformRiskManagement);

    /**
     * 风险录入分页查询
     * @param queryFilter
     * @return
     */
    PageList<BizReformRiskManagement> pageList(QueryFilter<BizReformRiskManagement> queryFilter,boolean isAffirm);

    /**
     * 查询风险详情信息
     * @param id
     * @return
     */
    BizReformRiskManagement findById(String id);
}
