package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.dto.MentDTO;
import com.artfess.reform.fill.model.BizEffectDryingCompetition;
import com.artfess.reform.fill.model.BizPilotAdvanceRecord;
import com.artfess.reform.fill.model.BizReformIteratePilotManagement;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.artfess.reform.fill.vo.EffectDryingCompetitionExportVo;
import com.artfess.reform.fill.vo.InvVO;
import com.artfess.reform.fill.vo.OperateUserVo;
import com.artfess.reform.fill.vo.StateVO;
import com.artfess.reform.statistics.vo.CountyChartVo;

import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;


public interface BizReformPilotManagementManager extends BaseManager<BizReformPilotManagement> {
  /**
   * 保存实体类
   * @param bizReformPilotManagement
   * @return
   */
  boolean insertInfo(BizReformPilotManagement bizReformPilotManagement);

  /**
   * 更新实体类
   * @param bizReformPilotManagement
   */
  void updateInfo(BizReformPilotManagement bizReformPilotManagement);

  /**
   * 修改审核状态
   * @param stateVO
   */
  void updateByStatus(StateVO stateVO);


  /**
   * 删除实体
   * @param ids
   */
  void removeInfo(String ids);

  /**
   * 根据id查询推进记录表
   * @param id
   * @return
   */
  BizPilotAdvanceRecord findModel(String id);

  /**
   *查询历史记录和驳回审批意见
   * @param id
   * @return
   */
  List<BizPilotAdvanceRecord> findByHis(String id,String unitId);
  /**
   * 判断试点文号是否已存在
   * @param docNo
   * @return
   */
  boolean ifExists(String docNo);

  /**
   *
   * @param dto
   * @return
   */
  PageList<BizReformPilotManagement> queryInput(MentDTO dto);

    /**
     * 查询区县审核录入
     * @param filter
     * @return
     */
  PageList<BizReformPilotManagement> disQueryList(QueryFilter<BizReformPilotManagement> filter);

    /**
     * 查询试点主管部门审核
     * @param filter
     * @return
     */
  PageList<BizReformPilotManagement> pilQueryList(QueryFilter<BizReformPilotManagement> filter);


  /**
   * 根据id查询具体信息
   * @param id
   * @return
   */
  BizReformPilotManagement findById(String id);


  /**
   * 区县推进查询试点项目
   * @param dto
   * @return
   */
  PageList<InvVO> invPush(MentDTO dto,boolean isAffirm);

  /**
   * 区县审核推进试点项目
   * @param dto
   * @return
   */
  PageList<InvVO> invAudit(MentDTO dto);

  /**
   * 主管部门审核推进试点项目
   * @param dto
   * @return
   */
  PageList<InvVO> pilAudit(MentDTO dto);

  /**
   * 市委审核推进试点项目
   * @param dto
   * @return
   */
  PageList<InvVO> munAudit(MentDTO dto);

  /**
   * 专项小组查询试点推进信息
   * @param queryFilter
   * @param code
   * @return
   */
  PageList<BizReformPilotManagement> queryGroup(QueryFilter<BizReformPilotManagement> queryFilter,String code);

  /**
   * 改革办查询权限
   */
  PageList<BizReformPilotManagement> munInfo(QueryFilter<BizReformPilotManagement> queryFilter);

  /**
  * @Description: 大屏查询改革试点详情
  * @param queryFilter
  * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizReformPilotManagement>
  * @Author: chens
  * @Date: 2023/4/18 11:27
  */
  PageList<BizReformPilotManagement> queryDetail(QueryFilter<BizReformPilotManagement> queryFilter);

  PageList<BizReformPilotManagement> queryDetailSpc(QueryFilter<BizReformPilotManagement> queryFilter);

  /**
   * @Description: 大屏查询改革试点最新详情
   * @param queryFilter
   * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizReformPilotManagement>
   * @Author: chens
   * @Date: 2023/4/18 11:27
   */
  List<BizReformPilotManagement>  queryLatestDetail(QueryFilter<BizReformPilotManagement> queryFilter);

  /**
   * 大屏试点台账区县合并数据导出
   * @param queryFilter
   * @return
   */
  List<BizReformPilotManagement>  queryLatest(QueryFilter<BizReformPilotManagement> queryFilter);

  /**
   * @Description: 二级大屏查询改革试点详情
   * @param queryFilter
   * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizReformPilotManagement>
   * @Author: chens
   * @Date: 2023/4/18 11:27
   */
  PageList<BizReformPilotManagement> queryDetailForUnit(QueryFilter<BizReformPilotManagement> queryFilter);

  /**
   * 市委推进审核excel导出功能
   * @param response
   * @param mentDTO
   * @throws Exception
   */
  void pilotExport(HttpServletResponse response,MentDTO mentDTO) throws Exception;

  /**
   * 根据部门级别赋予删除权限
   * @param ids
   */
  void auditRemoveInfo(String ids,boolean isAffirm);


  List<CountyChartVo> lineChartDataForLargeScreen(Integer year,Integer quarter);

  /**
   * 确认分发后是否能够撤回
   * @param pid
   * @return
   */
  boolean inputRevInfo(String pid);

  /**
   * 修改操作日志重复记录bug
   */
  void distinct();

  /**
   * 试点台账查询
   */
  List<BizReformPilotManagement> pilotLedger(Integer year,Integer quarter);

  /**
   * 确认分发后,市级部门修改流程
   * @param bizReformPilotManagement
   * @return
   */
  boolean updateIterateInfo(BizReformPilotManagement bizReformPilotManagement);

//  PageList<BizReformPilotManagement> queryDelete(MentDTO dto);

  BizReformPilotManagement queryDeleteById(String id);

  OperateUserVo operateDeleteById(String id);

}
