package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.dto.AssignmentDTO;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.model.BizReformDemandAssignmentRecord;
import com.artfess.reform.fill.vo.DemandAssignmentVo;

import java.util.List;

/**
 * 改革需求分析-需求交办表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
public interface BizReformDemandAssignmentManager extends BaseManager<BizReformDemandAssignment> {

    String insertAssignment(BizReformDemandAssignment bizReformDemandAssignment);

    /**
    * @Description: 录入页面分页查询
    * @param queryFilter
    * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizReformDemandAssignment>
    * @Author: chens
    * @Date: 2023/3/31 10:13
    */
    PageList<BizReformDemandAssignment> queryPageList(QueryFilter<BizReformDemandAssignment> queryFilter);

    /**
    * @Description: 审核列表分页查询
    * @param queryFilter
    * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizReformDemandAssignment>
    * @Author: chens
    * @Date: 2023/3/31 10:13
    */
    PageList<BizReformDemandAssignment> queryAudit(QueryFilter<BizReformDemandAssignment> queryFilter);

    /**
     * @Description: 分页查询最新需求推进详情
     * @param queryFilter
     * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizReformDemandAssignment>
     * @Author: chens
     * @Date: 2023/3/31 10:13
     */
    PageList<DemandAssignmentVo> queryDemandAssignment(QueryFilter<BizReformDemandAssignment> queryFilter);


    BizReformDemandAssignment queryById(String id);

    boolean updateDemandStatus(String id,Integer demandStatus);

    List<BizReformDemandAssignmentRecord> records(String projectId);
}
