package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizMeetingEvent;
import com.artfess.reform.fill.model.BizMeetingEventDetailsUnit;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;

/**
 * @Description:会议议定事项表 服务类
 * @Author: Rong Tao
 * @Date: 2023/4/3 16:50
 */
public interface BizMeetingEventManager extends BaseManager<BizMeetingEvent> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<BizMeetingEvent> queryByPage(QueryFilter<BizMeetingEvent> queryFilter);

    /**
     * 添加或修改数据
     * @param bizMeetingEvent
     */
    void saveOrUpdateEntity(BizMeetingEvent bizMeetingEvent);

    /**
     * 根据id修改分发状态
     * @param ids
     * @param status
     * @return
     */
    boolean modifySendStatus(String ids,String status);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    BizMeetingEvent detailedById(String id,String unitId);

    /**
     * 判断是否存在会议名称
     */
    boolean isExists(String id,String meetingName);
}
