package com.artfess.reform.fill.dto;


import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

@Data
public class AssignmentDTO {

    @ApiModelProperty(value = "需求题目")
    private String demandTopic;

    @ApiModelProperty(value = "来源渠道使用字典，1：习近平总书记重要指示精神，2：群众企业基层所盼")
    private Integer demandSourceChannel;

    @ApiModelProperty(value = "所属领域使用字典，1：政治，2：经济，3：文化，4：社会，5：生态")
    private Integer demandField;

    @ApiModelProperty(value = "所属跑道使用字典，1：党的建设，2：xx")
    private Integer demandRunway;

    @ApiModelProperty(value = "反馈时限")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate feedbackTimeLimit;

    @ApiModelProperty(value = "分页pageNum")
    private Integer page;

    @ApiModelProperty(value = "分页pageSize")
    private Integer pageSize;

    private String orgId;

    @ApiModelProperty(value = "审核状态")
    private List<Integer> status;
}
