package com.artfess.reform.fill.dao;



import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.artfess.reform.fill.vo.InvVO;
import com.artfess.reform.fill.vo.OperateUserVo;
import com.artfess.reform.statistics.vo.CountyChartVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.util.List;

public interface BizReformPilotManagementDao extends BaseMapper<BizReformPilotManagement> {

    IPage<BizReformPilotManagement> pushQuery(IPage<BizReformPilotManagement> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizReformPilotManagement> convert2Wrapper);

    IPage<BizReformPilotManagement> queryInput(IPage<BizReformPilotManagement> iPage,
                                               @Param("projectName")String projectName,
                                               @Param("docNo")String docNo,
                                               @Param("pilotLevel")Integer pilotLevel,
                                               @Param("pilotField") Integer pilotField,
                                               @Param("pilotRunway") Integer pilotRunway,
                                               @Param("isDele") String isDele,
                                               @Param("status") Integer status,
                                               @Param("statusList") List<Integer> statusList,
                                               @Param("createOrgId") String createOrgId,
                                               @Param("unitId") String unitId);

    IPage<BizReformPilotManagement> munInfo(IPage<BizReformPilotManagement> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizReformPilotManagement> convert2Wrapper);

    IPage<InvVO> invPush(IPage<BizReformPilotManagement> page,
                          @Param("unitId") String unitId,
                          @Param("unitName") String unitName,
                          @Param("mainUnitName") String mainUnitName,
                          @Param("docNo")String docNo,
                          @Param("projectName")String projectName,
                          @Param("pilotLevel")Integer pilotLevel,
                          @Param("status") Integer status,
                          @Param("pilotField") Integer pilotField,
                          @Param("pilotRunway") Integer pilotRunway,
                          @Param("pilotSupervisor")  Integer pilotSupervisor,
                          @Param("propulsiveStatus") Integer propulsiveStatus,
                          @Param("isDele") String isDele);

    /**
     *区县领导审核页面
     */

    IPage<InvVO> invAudit(IPage<BizReformPilotManagement> page,
                                       @Param("unitId")String unitId,
                                       @Param("unitName") String unitName,
                                       @Param("mainUnitName") String mainUnitName,
                                       @Param("docNo")String docNo,
                                       @Param("projectName")String projectName,
                                       @Param("pilotLevel")Integer pilotLevel,
                                       @Param("pilotSupervisor")Integer pilotSupervisor,
                                       @Param("statusList") List<Integer> statusList,
                                       @Param("status") Integer status,
                                       @Param("pilotField") Integer pilotField,
                                       @Param("pilotRunway") Integer pilotRunway,
                                       @Param("propulsiveStatus") Integer propulsiveStatus,
                                       @Param("isDele") String isDele);


    IPage<InvVO> pilAudit(IPage<BizReformPilotManagement> page,
                                       @Param("unitId") String unitId,
                                       @Param("unitName") String unitName,
                                       @Param("mainUnitName") String mainUnitName,
                                       @Param("docNo")String docNo,
                                       @Param("projectName")String projectName,
                                       @Param("pilotLevel")Integer pilotLevel,
                                       @Param("pilotSupervisor")Integer pilotSupervisor,
                                       @Param("statusList")List<Integer> statusList,
                                       @Param("status") Integer status,
                                       @Param("pilotField") Integer pilotField,
                                       @Param("pilotRunway") Integer pilotRunway,
                                       @Param("propulsiveStatus") Integer propulsiveStatus,
                                       @Param("isDele") String isDele);



    /**
     * 市改革办审核
     */
    IPage<InvVO> munAudit(IPage<BizReformPilotManagement> page,
                             @Param("unitId") String unitId,
                             @Param("unitName")String unitName,
                             @Param("mainUnitName") String mainUnitName,
                             @Param("docNo")String docNo,
                             @Param("projectName")String projectName,
                             @Param("pilotLevel")Integer pilotLevel,
                             @Param("pilotSupervisor")Integer pilotSupervisor,
                             @Param("statusList")List<Integer> statusList,
                             @Param("status") Integer status,
                             @Param("pilotField") Integer pilotField,
                             @Param("pilotRunway") Integer pilotRunway,
                             @Param("propulsiveStatus") Integer propulsiveStatus,
                             @Param("isDele") String isDele);

    /**
     * 附件导出查询
     */
    IPage<InvVO> excelInfo(IPage<BizReformPilotManagement> page,
                          @Param("unitId") String unitId,
                          @Param("unitName")String unitName,
                          @Param("mainUnitName") String mainUnitName,
                          @Param("docNo")String docNo,
                          @Param("projectName")String projectName,
                          @Param("pilotLevel")Integer pilotLevel,
                          @Param("pilotSupervisor")Integer pilotSupervisor,
                          @Param("statusList")List<Integer> statusList,
                          @Param("status") Integer status,
                          @Param("pilotField") Integer pilotField,
                          @Param("pilotRunway") Integer pilotRunway,
                          @Param("propulsiveStatus") Integer propulsiveStatus);

    List<CountyChartVo> lineChartDataForLargeScreen(@Param("year")Integer year,@Param("quarter")Integer quarter);

    IPage<BizReformPilotManagement> queryDetail(IPage<BizReformPilotManagement> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizReformPilotManagement> convert2Wrapper);

    IPage<BizReformPilotManagement> queryDetailSpc(IPage<BizReformPilotManagement> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizReformPilotManagement> convert2Wrapper);

    IPage<BizReformPilotManagement> queryDetailForUnit(IPage<BizReformPilotManagement> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizReformPilotManagement> convert2Wrapper);
    /**
     * @Description: 根据试点项目的涉及区县查询各区县最新的填报数据
     * @Return: java.util.List<com.artfess.reform.fill.model.BizPilotAdvanceRecord>
     * @Author: chens
     * @Date: 2023/4/8 21:04
     */
    List<BizReformPilotManagement> queryLatestRecordsForInvolved( @Param(Constants.WRAPPER) Wrapper<BizReformPilotManagement> convert2Wrapper);

    List<BizReformPilotManagement> queryLatestRecords( @Param(Constants.WRAPPER) Wrapper<BizReformPilotManagement> convert2Wrapper);

    /**
     * 区县大屏试点台账
     * @param year
     * @param quarter
     * @return
     */
    List<BizReformPilotManagement> pilotLedger(@Param("year")Integer year,@Param("quarter")Integer quarter);

    /**
     * 专项小组所属领域查询各区县试点情况
     * @param convert2iPage
     * @param convert2Wrapper
     * @param code
     * @return
     */
    IPage<BizReformPilotManagement> queryGroup(IPage<BizReformPilotManagement> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizReformPilotManagement> convert2Wrapper, @Param("code")String code);


    /**
     * @Description: 统计区县落实力数据
     * @param countDate 计算的时间
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyWorkable>
     * @Author: chens
     * @Date: 2023/4/5 21:43
     */
    List<BizReformPilotManagement> shouldAcceptance(@Param("countDate") LocalDate countDate,@Param("unitId")String unitId);

    /**
     * 计算验收率时，提前验收项目
     * @return
     */
    List<BizReformPilotManagement> advanceAcceptance(@Param("countDate") LocalDate countDate,@Param("unitId")String unitId);

    /**
     * 计算验收率时，实际验收项目
     * @return
     */
    List<BizReformPilotManagement> actualAcceptance(@Param("countDate") LocalDate countDate,@Param("unitId")String unitId);

    /**
     * 计算验收率时，未验收项目
     * @return
     */
    List<BizReformPilotManagement> notAcceptance(@Param("countDate") LocalDate countDate,@Param("unitId")String unitId);

    BizReformPilotManagement findDeleteId(@Param("id")String id);

    OperateUserVo operateUserById(@Param("id")String id);
}
