package com.artfess.reform.fill.dao;

import com.artfess.reform.fill.model.BizReformPilotCityManagement;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 改革试点市级部门管理表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
public interface BizReformPilotCityManagementDao extends BaseMapper<BizReformPilotCityManagement> {
    /**
     * 分页查询
     * @param convert2iPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizReformPilotCityManagement> queryPageInfo(IPage<BizReformPilotCityManagement> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizReformPilotCityManagement> convert2Wrapper);

    /**
     * 导出excel分页查询
     * @param convert2iPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizReformPilotCityManagement> queryPageExcel(IPage<BizReformPilotCityManagement> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizReformPilotCityManagement> convert2Wrapper);
}
