package com.artfess.reform.fill.dao;

import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.vo.DemandAnalysisLibraryNumVo;
import com.artfess.reform.statistics.vo.CountyChartVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 改革需求分析-需求库表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
public interface BizReformDemandAnalysisLibraryDao extends BaseMapper<BizReformDemandAnalysisLibrary> {

    List<CountyChartVo> chartDataForLargeScreen(@Param("year") int currentYear,@Param("month") Integer month);

    /**
    * @Description:  统计需求库的数据
    * @param year 需求提出年
    * @param month 需求提出月度
    * @param unitCode  需求提出区县
    * @Return: java.util.List<com.artfess.reform.fill.vo.DemandAnalysisLibraryNumVo>
    * @Author: chens
    * @Date: 2023/4/10 11:47
    */
    List<DemandAnalysisLibraryNumVo>  countNum(@Param("year") int year, @Param("month") Integer month, @Param("unitCode") String unitCode);

    IPage<BizReformDemandAnalysisLibrary> queryByPage(IPage<BizReformDemandAnalysisLibrary> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizReformDemandAnalysisLibrary> convert2Wrapper);
}
