package com.artfess.reform.fill.dao;

import com.artfess.reform.fill.model.BizPilotAdvanceResult;
import com.artfess.reform.fill.vo.PilotAdvanceResultNumVo;
import com.artfess.reform.statistics.vo.CountyPilotReformVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface BizPilotAdvanceResultDao extends BaseMapper<BizPilotAdvanceResult> {

    List<CountyPilotReformVo> count(@Param("type") Integer type,@Param("year") Integer year, @Param("quarter") Integer quarter,@Param("unitCode") String unitCode);

    /**
     * @Description: 分页查询试点成果
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<BizPilotAdvanceResult> queryResult(IPage<BizPilotAdvanceResult> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizPilotAdvanceResult> convert2Wrapper);

    /**
     * 查询试点项目的成果数量
     * @param pilotId 试点项目ID
     * @param year 年份
     * @param quarter 季度
     * @param unitCode  区县编码
     * @return
     */
    List<PilotAdvanceResultNumVo> countByPilot(@Param("pilotId")String pilotId, @Param("year") Integer year, @Param("quarter") Integer quarter, @Param("unitCode") String unitCode);

    List<BizPilotAdvanceResult> findDeleteId(@Param("recId")String recId);
}
