package com.artfess.reform.fill.dao;

import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.artfess.reform.fill.vo.BlockageCardTransferVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 堵点卡点转交办表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
public interface BizBlockageCardTransferDao extends BaseMapper<BizBlockageCardTransfer> {


    /**
     * @Description: 分页查询录入列表
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<BizBlockageCardTransfer> queryPageList(IPage<BizBlockageCardTransfer> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizBlockageCardTransfer> convert2Wrapper);

    /**
     * @Description: 分页查询审核列表
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<BizBlockageCardTransfer> queryAudit(IPage<BizBlockageCardTransfer> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizBlockageCardTransfer> convert2Wrapper);

    /**
     * @Description: 大屏分页查询堵点推进详情
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<BlockageCardTransferVo> queryBlockageCardDetailList(IPage<BizBlockageCardTransfer> convert2iPage, @Param(Constants.WRAPPER) Wrapper<BizBlockageCardTransfer> convert2Wrapper);



    List<BizBlockageCardTransfer> problemSolvingDetail(@Param("unitCode") String unitCode,@Param("year") Integer year,@Param("quarter") Integer  quarter);
}
