package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizWorkNews;
import com.artfess.reform.fill.manager.BizWorkNewsManager;

import javax.annotation.Resource;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;


/**
 * 工作动态 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-04-07
 */
@RestController
@RequestMapping("/fill/bizWorkNews/v1/")
@Api(tags = "工作动态")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizWorkNewsController extends BaseController<BizWorkNewsManager,BizWorkNews> {

    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @PostMapping("/queryInfo")
    @ApiOperation(value = "工作台分页查询")
    public CommonResult<PageList<BizWorkNews>> queryInfo(@RequestBody QueryFilter<BizWorkNews> queryFilter,@RequestParam(name = "isAffirm",required = true) Boolean isAffirm) {
        PageList<BizWorkNews> queryInfo = baseService.queryInfo(queryFilter,isAffirm);
        return new CommonResult<>(true,"查询成功",queryInfo);
    }

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation(value = "添加或者修改实体类")
    public CommonResult<String> saveOrUpdateEntity(@RequestBody BizWorkNews bizWorkNews) {
         baseService.saveOrUpdateEntity(bizWorkNews);
        return new CommonResult<>(bizWorkNews.getId()==null?"添加成功":"修改成功");
    }

    @PostMapping("/updateInfo")
    @ApiOperation(value = "修改审核状态")
    public CommonResult<String> updateInfo(@RequestBody BizWorkNews bizWorkNews) {
        boolean update = baseService.updateInfo(bizWorkNews);
        return new CommonResult<>(update?"修改成功":"修改失败");
    }

    @PostMapping("/deleteInfo")
    @ApiOperation(value = "根据id删除数据")
    public CommonResult<String> deleteInfo(@RequestParam("ids")String ids) {
           baseService.deleteInfo(ids);
        return new CommonResult<>("删除成功");
    }


    @PostMapping("/findById")
    @ApiOperation(value = "根据id查询详细信息")
    public BizWorkNews findById (@RequestParam("id") String id) {
        Assert.notNull(id,"需查看的项目id不能为空");
        //查询主表信息
        BizWorkNews entity = baseService.getById(id);
        //查询驳回记录
        if (entity.getStatus()==2||entity.getStatus()==4){
            AchieveStatusLog log = achieveStatusLogManager.getOne(new QueryWrapper<AchieveStatusLog>()
                    .eq("BIZ_ID_", entity.getId())
                    .eq("STATUS_",entity.getStatus())
                    .orderByDesc("LAST_TIME_"), false);
            if (log!=null)entity.setApprovalComments(log.getApprovalComments());
        }
        return  entity;
    }

    @PostMapping("/queryCode")
    @ApiOperation(value = "区县大屏信息工作动态查询")
    public PageList<BizWorkNews> invQuery (@RequestBody QueryFilter<BizWorkNews> queryFilter) {
        return baseService.screenInfo(queryFilter);
    }


    @GetMapping("/userAffiliatedUnit")
    @ApiOperation(value = "S-查询当前登录用户所属类型(管理员,区县,市级单位)")
    public CommonResult<String> userAffiliatedUnit(){
        if (ContextUtil.getCurrentUser().isAdmin()) return new CommonResult<>("管理员");
        List<String> grade = Arrays.asList("2", "3", "4");
        if (grade.contains(ContextUtil.getCurrentOrgGrade())){
            return new CommonResult<>("区县");
        }else {
            return new CommonResult<>("市级部门");
        }
    }
}
