package com.artfess.reform.fill.controller;


import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizReformSatisfactionManagement;
import com.artfess.reform.fill.model.BizReformSatisfactionProject;
import com.artfess.reform.fill.vo.WorkReportNumVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizReformWorkReport;
import com.artfess.reform.fill.manager.BizReformWorkReportManager;

import javax.annotation.Resource;
import java.time.Month;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工作报告管理 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@RestController
@RequestMapping("/fill/bizReformWorkReport/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "工作报告管理")
public class  BizReformWorkReportController extends BaseController<BizReformWorkReportManager, BizReformWorkReport> {

    @PostMapping("/save")
    @ApiOperation(value = "S-保存数据或者修改数据")
    public CommonResult saveAll(@ApiParam(name = "BizReformSatisfactionProject对象") @RequestBody BizReformWorkReport bizReformWorkReport) {
        boolean save = baseService.insertOrUpdateInfo(bizReformWorkReport);
        return new CommonResult(save?"添加成功":"修改成功");
    }

    @PostMapping("/update")
    @ApiOperation(value = "S-修改数据")
    public CommonResult update(@RequestBody BizReformWorkReport bizReformWorkReport) {
        baseService.update(bizReformWorkReport);
        return new CommonResult("修改成功");
    }

    @PostMapping("/delete")
    @ApiOperation(value = "S-根据id删除数据")
    public CommonResult deleteById(@ApiParam(name = "id") @RequestParam("id") String id) {
        baseService.removeInfo(id);
        return new CommonResult("删除成功");
    }

    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("S-分页查询主表和子表数据")
    public PageList<BizReformWorkReport> query(@RequestBody QueryFilter<BizReformWorkReport> queryFilter) {
        return baseService.pageList(queryFilter);
    }

    @GetMapping(value="/countNum")
    @ApiOperation("S-统计各板块需要处理的数量")
    public List<WorkReportNumVO> countNum() {
        return baseService.countNum();
    }
}
