package com.artfess.reform.fill.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.DataPermission;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.manager.BizReformRiskManagementManager;
import com.artfess.reform.fill.model.BizReformRiskManagement;
import com.artfess.reform.fill.vo.StateVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping("biz/bizReformRiskManagement/v1")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "改革风险管理")
public class BizReformRiskManagementController extends BaseController<BizReformRiskManagementManager, BizReformRiskManagement> {

    @PostMapping("/delete")
    @ApiOperation(value = "S-根据id删除数据")
    public CommonResult<String> deleteById(@ApiParam(name = "id") @RequestParam("id") String id) {
       baseService.removeById(id);
        return new CommonResult<>("删除成功");
    }

    @PostMapping("/update")
    @ApiOperation(value = "S-修改数据")
    public CommonResult<String> update(@RequestBody BizReformRiskManagement bizReformRiskManagement) {
        baseService.update(bizReformRiskManagement);
        return new CommonResult<>("修改成功");
    }

    @PostMapping("/updateById")
    @ApiOperation(value = "S-根据id修改状态")
    public CommonResult<String> updateById(@RequestBody StateVO stateVO) {
        baseService.updateById(stateVO);
        return new CommonResult<>("修改状态成功");
    }

    @PostMapping("/saveAll")
    @ApiOperation(value = "S-保存数据或者更新主表加子表数据")
    public CommonResult<String> saveAll(@ApiParam(name = "BizReformRiskManagement对象") @RequestBody BizReformRiskManagement bizReformRiskManagement) {
        String mes = bizReformRiskManagement.getId();
         baseService.insertOrUpdateInfo(bizReformRiskManagement);
        return new CommonResult<>(mes==null?"添加成功":"修改成功");
    }

    @PostMapping(value="/pageList", produces={"application/json; charset=utf-8" })
    @ApiOperation("S-改革风险分页查询")
    public PageList<BizReformRiskManagement> pageList(@RequestBody QueryFilter<BizReformRiskManagement> queryFilter,@RequestParam(name = "isAffirm",required = true) Boolean isAffirm) {
        return baseService.pageList(queryFilter,isAffirm);
    }


    @PostMapping(value="/findById/{id}")
    @ApiOperation("S-改革风险查询具体数据")
    public BizReformRiskManagement findById(@PathVariable("id")String id) {
        return baseService.findById(id);
    }
}