package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.reform.fill.dto.AssignmentDTO;
import com.artfess.reform.fill.manager.BizProjectCooperativeUnitManager;
import com.artfess.reform.fill.manager.BizReformDemandAnalysisLibraryManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.model.BizProjectCooperativeUnit;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 改革需求分析-需求交办表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
@RestController
@RequestMapping("/bizReformDemandAssignment/v1/")
@Api(tags = "改革需求交办模块")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizReformDemandAssignmentController extends BaseController<BizReformDemandAssignmentManager, BizReformDemandAssignment> {

    @Resource
    private BizReformDemandAnalysisLibraryManager bizReformDemandAnalysisLibraryManager;

    @Resource
    private BizProjectCooperativeUnitManager bizProjectCooperativeUnitManager;

    @Override
    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("录入分页查询")
    public PageList<BizReformDemandAssignment> query(@RequestBody QueryFilter<BizReformDemandAssignment> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("CREATE_ORG_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        return baseService.queryPageList(queryFilter);
    }

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@RequestBody BizReformDemandAssignment bizReformDemandAssignment) {
        String id = baseService.insertAssignment(bizReformDemandAssignment);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<String>(true,"保存成功！",id);
    }

    @PostMapping("/updateInfo")
    @ApiOperation("更新实体")
    public CommonResult<String> updateInfo(@RequestBody BizReformDemandAssignment bizReformDemandAssignment) {
        if (baseService.records(bizReformDemandAssignment.getId()).size()>0){
            return new CommonResult<>(false,"已提交推进记录的交办无法修改");
        }
        return super.updateById(bizReformDemandAssignment);
    }

    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        if (baseService.records(id).size()>0){
            return new CommonResult<>(false,"已提交推进记录的交办无法删除！");
        }
        boolean result = baseService.removeById(id);
        Map<String, Object> map = new HashMap<>();
        map.put("PROJECT_ID_", id);
        bizProjectCooperativeUnitManager.removeByMap(map);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }


    @PostMapping("/getAssignmentList")
    @ApiOperation("交办入库分页查询")
    public CommonResult<PageList<BizReformDemandAnalysisLibrary>> getAssignmentList(@RequestBody QueryFilter<BizReformDemandAnalysisLibrary> queryFilter) {
        queryFilter.addFilter("STATUS_",5,QueryOP.EQUAL);
        queryFilter.addFilter("DEMAND_ADOPTION_STATUS_",2,QueryOP.EQUAL);
        return new CommonResult<PageList<BizReformDemandAnalysisLibrary>>(true, "查询成功", bizReformDemandAnalysisLibraryManager.query(queryFilter));
    }

    @PostMapping(value="/queryAudit", produces={"application/json; charset=utf-8" })
    @ApiOperation("审核分页查询")
    public PageList<BizReformDemandAssignment> queryAudit(@RequestBody QueryFilter<BizReformDemandAssignment> queryFilter,@RequestParam(name = "isAffirm",required = true) Boolean isAffirm) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()&&!isAffirm) {
            queryFilter.addFilter("a.RESPONSIBLE_UNIT_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("r.last_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return baseService.queryAudit(queryFilter);
    }


    @PostMapping("/queryById")
    @ApiOperation(value = "根据id查询交办详情与推进审批记录")
    public BizReformDemandAssignment queryById(@RequestParam(name = "id",required = true) String id) {
        BizReformDemandAssignment assignment =baseService.queryById(id);
        return assignment;
    }

    @PostMapping("/updateDemandStatus")
    @ApiOperation("修改需求交办推进更新状态")
    public CommonResult<String> updateDemandStatus(@RequestParam(name = "id",required = true) String id,@RequestParam(name = "demandStatus",required = true) Integer demandStatus) {
        boolean flag = baseService.updateDemandStatus(id,demandStatus);
        if(flag) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>(true,"修改成功！",id);
    }





   /* @PostMapping("/getDutyList")
    @ApiOperation("责任单位列表查询")
    public CommonResult<PageList<BizReformDemandAssignment>> getDutyList(@RequestBody AssignmentDTO dto) {

        return new CommonResult<PageList<BizReformDemandAssignment>>(true, "查询成功", baseService.select4Unit(dto,ContextUtil.getCurrentOrgId()).getValue());
    }


    @PostMapping("/getLeaderList")
    @ApiOperation("责任单位审核列表查询")
    public CommonResult<PageList<BizReformDemandAssignment>> getLeaderList(@RequestBody AssignmentDTO dto) {

        return new CommonResult<PageList<BizReformDemandAssignment>>(true, "查询成功", baseService.select4UnitLeader(dto,ContextUtil.getCurrentOrgId()).getValue());
    }*/


}
