package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.fill.manager.BizReformDemandAnalysisLibraryManager;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

import java.util.ArrayList;
import java.util.Arrays;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 改革需求分析-需求库表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
@RestController
@RequestMapping("/bizReformDemandAnalysisLibrary/v1/")
@Api(tags = "改革需求基础信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizReformDemandAnalysisLibraryController extends BaseController<BizReformDemandAnalysisLibraryManager, BizReformDemandAnalysisLibrary> {

    @Autowired
    SysDictionaryDetailManager sysDictionaryDetailManager;

    @PostMapping("/getList")
    @ApiOperation("需求录入分页查询")
    public PageList<BizReformDemandAnalysisLibrary> getList(@RequestBody QueryFilter<BizReformDemandAnalysisLibrary> queryFilter,@RequestParam(name = "isAffirm",required = true) Boolean isAffirm) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()&&!isAffirm) {
            queryFilter.addFilter("d.CREATE_ORG_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
//        List<FieldSort> sorter = queryFilter.getSorter();
//        sorter.add(new FieldSort("d.last_time_", Direction.DESC));
//        queryFilter.setSorter(sorter);
        return baseService.queryByPage(queryFilter);
    }

    @RequestMapping(value = "demandExport", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出改革需求列表", httpMethod = "POST", notes = "导出改革需求列表")
    public void demandExport(HttpServletResponse response, @ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter queryFilter) throws Exception {
        try {
            PageList<BizReformDemandAnalysisLibrary>pageList = super.query(queryFilter);
            List<Map<String, Object> > list = new ArrayList<>();
            if(BeanUtils.isNotEmpty(pageList.getRows())){
                for (BizReformDemandAnalysisLibrary demand : pageList.getRows()) {
                    String jsonStr = JsonUtil.toJson(demand);
                    Map<String, Object> map = JsonUtil.toMap(jsonStr);
                 //来源渠道
                    if(map.get("demandSourceChannel")!=null){
                        String demandSourceChannel = map.get("demandSourceChannel").toString();
                        String demandSourceChannelText = sysDictionaryDetailManager.getTextByValue("ggbb_lyqd",demandSourceChannel);
                        map.put("demandSourceChannelText",demandSourceChannelText);
                    }else{
                        map.put("demandSourceChannelText","");
                    }

                    //所属领域
                    if(map.get("demandField")!=null){
                        String demandField = map.get("demandField").toString();
                        String demandFieldText = sysDictionaryDetailManager.getTextByValue("ggbb_ssly",demandField);
                        map.put("demandFieldText",demandFieldText);
                    }else{
                        map.put("demandFieldText","");
                    }

                    //所属跑道
                    if(map.get("demandRunway")!=null){
                        String demandRunway = map.get("demandRunway").toString();
                        String demandRunwayText = sysDictionaryDetailManager.getTextByValue("ggbb_sspd",demandRunway);
                        map.put("demandRunwayText",demandRunwayText);
                    }else{
                        map.put("demandRunwayText","");
                    }

                    //采纳状态
                    if(map.get("demandAdoptionStatus")!=null){
                        String demandAdoptionStatus = map.get("demandAdoptionStatus").toString();
                        String demandAdoptionStatusText = sysDictionaryDetailManager.getTextByValue("ggbb_cyzt",demandAdoptionStatus);
                        map.put("demandAdoptionStatusText",demandAdoptionStatusText);
                    }else{
                        map.put("demandAdoptionStatusText","");
                    }
                    //审核状态
                    if(map.get("status")!=null){
                        String status = map.get("status").toString();
                        String statusText = sysDictionaryDetailManager.getTextByValue("shzt",status);
                        map.put("statusText",statusText);
                    }else{
                        map.put("statusText","");
                    }
                    list.add(map);
                }
            }
            String tempName = "改革需求数据";
            Map<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("demandTopic", "需求题目");
            exportMaps.put("reportUnitName", "需求上报区县");
            exportMaps.put("demandDate", "需求上报日期");
            exportMaps.put("demandSourceChannelText", "来源渠道");
            exportMaps.put("demandFieldText", "所属领域");
            exportMaps.put("demandRunwayText", "所属跑道");
            exportMaps.put("demandAdoptionStatusText", "采用状态");
            exportMaps.put("statusText", "审核状态");
            HSSFWorkbook book = ExcelUtil.exportExcel(tempName, 24, exportMaps, list);
            ExcelUtil.downloadExcel(book, tempName, response);
        } catch (Exception e) {
            throw new RuntimeException("导出失败：" + e.getMessage());
        }
    }

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@RequestBody BizReformDemandAnalysisLibrary bizReformDemandAnalysisLibrary) {
        String id = baseService.insertDemand(bizReformDemandAnalysisLibrary);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>(true,"保存成功！",id);
    }

    @PostMapping("/updateInfo")
    @ApiOperation("更新实体")
    public CommonResult<String> updateInfo(@RequestBody BizReformDemandAnalysisLibrary bizReformDemandAnalysisLibrary) {
        String id = baseService.updateDemand(bizReformDemandAnalysisLibrary);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>(true,"修改成功！",id);
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name="ids", value="实体集合") @RequestParam String...ids) {
        boolean result = baseService.deleteBatchByIds(Arrays.asList(ids));
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/updateAuditStatus")
    @ApiOperation("审核状态修改")
    public CommonResult<String> updateAuditStatus(@RequestBody BizReformDemandAnalysisLibrary bizReformDemandAnalysisLibrary) {
        String id = this.baseService.updateAuditStatus(bizReformDemandAnalysisLibrary);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>(true,"成功！",id);
    }

    @PostMapping("/updateAdoptStatus")
    @ApiOperation("采纳状态修改")
    public CommonResult<String> updateAdoptStatus(@RequestBody BizReformDemandAnalysisLibrary bizReformDemandAnalysisLibrary) {
        String id = this.baseService.updateAdoptStatus(bizReformDemandAnalysisLibrary);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>(true,"成功！",id);
    }



}
