package com.artfess.reform.fill.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.reform.fill.manager.BizPilotAdvanceRecordManager;
import com.artfess.reform.fill.model.BizPilotAdvanceRecord;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.artfess.reform.fill.vo.StateVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("biz/bizPilotAdvanceRecord/v1")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "改革试点推进记录表")
@Slf4j
public class BizPilotAdvanceRecordController extends BaseController<BizPilotAdvanceRecordManager,BizPilotAdvanceRecord> {

    @PostMapping("/saveQuery")
    @ApiOperation(value = "S-保存数据")
    public CommonResult<String> saveQuery(@ApiParam(name = "BizPilotAdvanceRecord对象") @RequestBody BizPilotAdvanceRecord bizPilotAdvanceRecord) {
        String res = baseService.saveQuery(bizPilotAdvanceRecord);
        return new CommonResult<>(StringUtil.isNotEmpty(res)?"添加成功":"添加失败");
    }

    @PostMapping("/updateQuery")
    @ApiOperation(value = "S-修改数据")
    public CommonResult<String> updateQuery(@ApiParam(name = "BizPilotAdvanceRecord对象") @RequestBody BizPilotAdvanceRecord bizPilotAdvanceRecord) {
        baseService.updateQuery(bizPilotAdvanceRecord);
        return new CommonResult<>(true,"修改成功");
    }

    @PostMapping("/updateById")
    @ApiOperation(value = "S-根据id修改状态")
    public CommonResult<String> updateById(@RequestBody StateVO stateVO) {
        baseService.updateById(stateVO);
        return new CommonResult<>(true,"审核状态修改成功");
    }

    @PostMapping("/batchUpdateById")
    @ApiOperation(value = "S-根据id批量驳回")
    public CommonResult<String> batchUpdateById(@RequestBody StateVO stateVO) {
        baseService.batchUpdateById(stateVO);
        return new CommonResult<>(true,"驳回成功");
    }

    @PostMapping("/passById/{id}")
    @ApiOperation(value = "S-根据项目id判断区县是否存在还未审核完成的推进记录")
    public Boolean passById(@PathVariable("id") String id) {
        int num = baseService.countNum(id);
        return num <= 0;
    }

    @PostMapping("/updatePushStatus")
    @ApiOperation(value = "S-修改推进状态bug")
    public CommonResult<String> updatePushStatus() {
         baseService.updatePushStatus();
    return new CommonResult<>("修改成功");
    }

    @PostMapping(value = "/queryDeleteById", produces = {"application/json; charset=utf-8"})
    @ApiOperation("查询被删除的基本信息")
    public CommonResult<List<BizPilotAdvanceRecord>> queryDeleteById(@RequestParam("pilotId") String pilotId,@RequestParam("unitId") String unitId) {
        List<BizPilotAdvanceRecord> list = baseService.queryDeleteById(pilotId, unitId);
        return new CommonResult<>(true, "查询成功",list);
    }

    @PostMapping("/editable")
    @ApiOperation(value = "同时操作的处理查询")
    public CommonResult<String> editable(@RequestParam("pilotId")String pilotId,@RequestParam("unitId")String unitId,@RequestParam("status")Integer status) {
        baseService.editable(pilotId,unitId,status);
        return new CommonResult<>("操作成功");
    }
}
