package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizReformPilotCityManagement;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizPilotAdvanceCityRecord;
import com.artfess.reform.fill.manager.BizPilotAdvanceCityRecordManager;

import java.util.List;

/**
 * 改革试点市级部门推进记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@RestController
@RequestMapping("/fill/bizPilotAdvanceCityRecord/v1/")
@Api(tags = "市级试点推进记录")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizPilotAdvanceCityRecordController extends BaseController<BizPilotAdvanceCityRecordManager, BizPilotAdvanceCityRecord> {
    @PostMapping("/findByHistory/{id}")
    @ApiOperation(value = "S-查询详情")
    public List<BizPilotAdvanceCityRecord> findByHistory(@ApiParam("试点项目id")@PathVariable("id")String id) {
        return baseService.findByHistory(id);
    }
}
