package com.artfess.reform.fill.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.dto.MentDTO;
import com.artfess.reform.fill.manager.BizMeetingEventDetailsManager;
import com.artfess.reform.fill.model.BizMeetingEventDetails;
import com.artfess.reform.fill.model.BizMeetingEventPush;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.ibatis.annotations.Delete;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Description:会议议定事项详情表 前端控制器
 * @Author: Rong Tao
 * @Date: 2023/4/3 17:17
 */
@RestController
@RequestMapping("/bizMeetingEventDetails/v1/")
@Api(tags = "会议议定事项详情")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMeetingEventDetailsController extends BaseController<BizMeetingEventDetailsManager, BizMeetingEventDetails> {

    @PostMapping("/saveOrUpdateList")
    @ApiOperation("批量添加或修改")
    public CommonResult saveOrUpdateList(@RequestBody List<BizMeetingEventDetails> bizMeetingEventDetailsList) {
        baseService.saveOrUpdateList(bizMeetingEventDetailsList);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation("添加或修改")
    public CommonResult saveOrUpdateEntity(@RequestBody BizMeetingEventDetails bizMeetingEventDetails) {
        baseService.saveOrUpdateEntity(bizMeetingEventDetails);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/queryByPage")
    @ApiOperation("分页查询所有数据")
    public CommonResult<PageList<BizMeetingEventDetails>> queryByPage(@RequestBody QueryFilter<BizMeetingEventDetails> queryFilter,@RequestParam("isAffirm")Boolean isAffirm) {
        PageList<BizMeetingEventDetails> result = baseService.queryByPage(queryFilter,isAffirm);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/detailedById")
    @ApiOperation("根据ID查询详情")
    public CommonResult<BizMeetingEventDetails> detailedById(@RequestParam("id") String id) {
        BizMeetingEventDetails result = baseService.detailedById(id);
        return new CommonResult(true,"操作成功",result);
    }

    @PostMapping("/modifyStatus")
    @ApiOperation("根据ID修改推进状态")
    public CommonResult modifyStatus(@RequestParam String ids,@RequestParam String status) {
        boolean result = baseService.modifyStatus(ids, status);
        return new CommonResult(result,result?"操作成功":"操作失败");
    }

    @RequestMapping(value = "export", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出交办事项列表", httpMethod = "POST", notes = "导出交办事项列表")
    public void pilotExport(HttpServletResponse response, @ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter<BizMeetingEventDetails> queryFilter,@RequestParam(required = false)Boolean isAffirm) throws Exception {
        baseService.exportExcel(response,queryFilter,isAffirm);
    }

    @PostMapping("/{id}")
    @ApiOperation("根据ID删除数据")
    public CommonResult<String> deleteInfo(@PathVariable("id") String id) {
        boolean res = baseService.deleteInfo(id);
        return new CommonResult(res?"删除成功":"删除失败");
    }


}
