package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.manager.BizMeetingDocumentsConsideredManager;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 会议审议通过文件管理表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@RestController
@RequestMapping("/bizMeetingDocumentsConsidered/v1/")
@Api(tags = "审议通过文件管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMeetingDocumentsConsideredController extends BaseController<BizMeetingDocumentsConsideredManager, BizMeetingDocumentsConsidered> {

    @PostMapping(value="/queryPush")
    @ApiOperation("录入分页查询")
    public PageList<BizMeetingDocumentsConsidered> queryPush(@RequestBody QueryFilter<BizMeetingDocumentsConsidered> queryFilter) {
        return  baseService.queryPush(queryFilter);
    }

    @PostMapping("/queryAudit")
    @ApiOperation("审核分页查询")
    public PageList<BizMeetingDocumentsConsidered> queryAudit(@RequestBody QueryFilter<BizMeetingDocumentsConsidered> queryFilter,Boolean isAffirm) {
            return  baseService.queryAudit(queryFilter,isAffirm);
    }

    @PostMapping("/removeById")
    @ApiOperation("根据id删除")
    public CommonResult<String> removeById(@RequestParam("ids") String ids) {
        Boolean remove = baseService.removeById(ids);
        return new CommonResult<>(remove?"删除成功":"删除失败") ;
    }

    @PostMapping(value="/insertInfo")
    @ApiOperation("添加实体类")
    public CommonResult<String> insertInfo(@RequestBody BizMeetingDocumentsConsidered entity) {
        Boolean save = baseService.insertInfo(entity);
        return new CommonResult<>(save?"添加成功":"添加失败");
    }

    @PostMapping(value="/updateInfo")
    @ApiOperation("修改实体类")
    public CommonResult<String> updateInfo(@RequestBody BizMeetingDocumentsConsidered entity) {
        baseService.updateInfo(entity);
        return new CommonResult<>("修改成功");
    }

    @PostMapping(value="/updateByStatus")
    @ApiOperation("修改分发状态")
    public CommonResult<String> updateByStatus(@RequestBody BizMeetingDocumentsConsidered entity) {
        baseService.updateByStatus(entity);
        return new CommonResult<>("修改成功");
    }

    @PostMapping(value="/findByModel")
    @ApiOperation("查询录入详情信息")
    public CommonResult<BizMeetingDocumentsConsidered> findByModel(@RequestParam("id")String id) {
        BizMeetingDocumentsConsidered entity = baseService.findByModel(id);
        return new CommonResult<>(true,"查询成功",entity);
    }

    @PostMapping(value="/findByHis")
    @ApiOperation("查询当前和历史记录")
    public CommonResult<List<BizMeetingDocumentsPush>> findByHis(@RequestParam("id")String id, @RequestParam("unitId")String unitId) {
        List<BizMeetingDocumentsPush> entity = baseService.findByHis(id, unitId);
        return new CommonResult<>(true,"查询成功",entity);
    }

    @RequestMapping(value = "export", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出列表", httpMethod = "POST", notes = "导出需对接文件")
    public void pilotExport(HttpServletResponse response, @ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter<BizMeetingDocumentsConsidered> queryFilter) throws Exception {
        baseService.exportExcel(response,queryFilter);
    }
}
