package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.fill.dto.OneThingsDTO;
import com.artfess.reform.fill.manager.BizDigitalAdvanceConstructionManager;
import com.artfess.reform.fill.manager.BizDigitalOneThingManager;
import com.artfess.reform.fill.model.*;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 围绕重点领域策划推出“一件事”情况 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */
@RestController
@RequestMapping("/fill/bizDigitalOneThing/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "围绕重点领域策划推出“一件事”情况")
public class BizDigitalOneThingController extends BaseController<BizDigitalOneThingManager, BizDigitalOneThing> {
    @Resource
    BizDigitalAdvanceConstructionManager bizDigitalAdvanceConstructionManager;
    @Resource
    SysDictionaryDetailManager sysDictionaryDetailManager;
    @Resource
    FileManager fileManager;

    @Override
    @DeleteMapping("/{originalId}")
    @ApiOperation("根据id删除数据")
    public CommonResult<String> deleteById(@ApiParam(name="originalId", value="originalId") @PathVariable("originalId") String originalId) {
        //删除列表数据
        QueryWrapper<BizDigitalOneThing> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("ORIGINAL_ID_",originalId);
        List<BizDigitalOneThing> list = baseService.list(queryWrapper);
        if (list!=null&&list.size()>0){
            List<String> ids = list.stream().map(BizDigitalOneThing::getId).collect(Collectors.toList());
            //删除推进表信息
            bizDigitalAdvanceConstructionManager.remove(new QueryWrapper<BizDigitalAdvanceConstruction>().in("PUSH_ID_",ids));
            baseService.removeByIds(ids);
        }
        return CommonResult.success(originalId, "数据删除成功！");
    }

    @PostMapping(value="/queryByPage")
    @ApiOperation("分页查询")
    public PageList<BizDigitalOneThing> queryByPage(@RequestBody QueryFilter<BizDigitalOneThing> queryFilter) {
        return  baseService.queryByPage(queryFilter);
    }

    @PostMapping(value="/queryByPageNew")
    @ApiOperation("分页查询最新数据")
    public PageList<BizDigitalOneThing> queryByPageNew(@RequestBody QueryFilter<BizDigitalOneThing> queryFilter) {
        return  baseService.queryByPageNew(queryFilter);
    }

    @PostMapping(value="/queryByPageAll")
    @ApiOperation("一件事全量查询")
    public PageList<BizDigitalOneThing> queryByPageAll(@RequestBody QueryFilter<BizDigitalOneThing> queryFilter) {
        PageList<BizDigitalOneThing> pageList = baseService.queryByPageAll(queryFilter);
        pageList.getRows().stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return pageList;
    }

    @RequestMapping(value = "exportList", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出全量一件事", httpMethod = "POST", notes = "导出全量一件事")
    public void exportList(HttpServletResponse response, @ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter<BizDigitalOneThing> queryFilter) throws Exception {
        try {
            PageList<BizDigitalOneThing>pageList = baseService.queryByPageAll(queryFilter);
            List<Map<String, Object>> list = new ArrayList<>();
            if(BeanUtils.isNotEmpty(pageList.getRows())){
                int i=1;
                for (BizDigitalOneThing entity : pageList.getRows()) {

                    String jsonStr = JsonUtil.toJson(entity);
                    Map<String, Object> map = JsonUtil.toMap(jsonStr);
                    //序号
                    map.put("sn",i);
                    i++;
                    //事项类型
                    if(map.get("type")!=null){
                        String type = map.get("type").toString();
                        String typeText = sysDictionaryDetailManager.getTextByValue("yjs_sxlb",type);
                        map.put("typeText",typeText);
                    }else{
                        map.put("typeText","");
                    }
                    //事项来源
                    if(map.get("source")!=null){
                        String source = map.get("source").toString();
                        String sourceText = sysDictionaryDetailManager.getTextByValue("yjs_sxly",source);
                        map.put("sourceText",sourceText);
                    }else{
                        map.put("sourceText","");
                    }
                    //所属体系
                    if(map.get("appertainSystem")!=null){
                        String appertainSystem = map.get("appertainSystem").toString();
                        String appertainSystemText = sysDictionaryDetailManager.getTextByValue("szcq_sstx",appertainSystem);
                        map.put("appertainSystemText",appertainSystemText);
                    }else{
                        map.put("appertainSystemText","");
                    }
                    //所属跑道
                    if(map.get("appertainSunway")!=null){
                        String appertainSunway = map.get("appertainSunway").toString();
                        String appertainSunwayText = sysDictionaryDetailManager.getTextByValue("szcq_sspd",appertainSunway);
                        map.put("appertainSunwayText",appertainSunwayText);
                    }else{
                        map.put("appertainSunwayText","");
                    }
                    //当前状态
                    if(map.get("currentState")!=null){
                        String currentState = map.get("currentState").toString();
                        String currentStateText = sysDictionaryDetailManager.getTextByValue("yjs_dqzt",currentState);
                        map.put("currentStateText",currentStateText);
                    }else{
                        map.put("currentStateText","");
                    }
                    //核准情况
                    if(map.get("auditStatus")!=null){
                        String auditStatus = map.get("auditStatus").toString();
                        String auditStatusText = sysDictionaryDetailManager.getTextByValue("yjs_shqk",auditStatus);
                        map.put("auditStatusText",auditStatusText);
                    }else{
                        map.put("auditStatusText","");
                    }
                    list.add(map);
                }
            }
            String tempName = "区县\"一件事\"全量库";
            Map<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("sn", "序号");
            exportMaps.put("name", "事项名称");
            exportMaps.put("typeText", "事项类别");
            exportMaps.put("sourceText", "事项来源");
            exportMaps.put("briefIntroduction", "事项简介");
            exportMaps.put("appertainSystemText", "所属系统(体系)");
            exportMaps.put("appertainSunwayText", "所属跑道");
            exportMaps.put("auditTime", "入库时间");
            exportMaps.put("currentStateText", "当前状态");
            exportMaps.put("auditStatusText", "核准情况");
            exportMaps.put("removeCase", "核准原因");
            exportMaps.put("createOrgName", "提报区县");
            HSSFWorkbook book = ExcelUtil.exportExcel(tempName, 24, exportMaps, list);
            ExcelUtil.downloadExcel(book, tempName, response);
        } catch (Exception e) {
            throw new RuntimeException("导出失败：" + e.getMessage());
        }
    }

    @PostMapping(value="/queryByPageHis")
    @ApiOperation("查询区县一件事，包含被删除数据")
    public PageList<BizDigitalOneThing> queryByPageHis(@RequestBody OneThingsDTO dto) {
        PageList<BizDigitalOneThing> pageList = baseService.queryByPageHis(dto);
//        pageList.getRows().stream().forEach(p->{
//            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
//            p.setFiles(files);
//        });
        return pageList;
    }
}
