package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.manager.BizDigitalAdvanceConstructionManager;
import com.artfess.reform.fill.manager.BizDigitalOnLineApplicationManager;
import com.artfess.reform.fill.model.BizDigitalAdvanceConstruction;
import com.artfess.reform.fill.model.BizDigitalOneThing;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizDigitalOnLineApplication;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 开发上线特色应用情况 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */
@RestController
@RequestMapping("/fill/bizDigitalOnLineApplication/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "开发上线特色应用情况")
public class BizDigitalOnLineApplicationController extends BaseController<BizDigitalOnLineApplicationManager, BizDigitalOnLineApplication> {
    @Resource
    BizDigitalAdvanceConstructionManager bizDigitalAdvanceConstructionManager;
    @Override
    @DeleteMapping("/{originalId}")
    @ApiOperation("根据id删除数据")
    public CommonResult<String> deleteById(@ApiParam(name="originalId", value="originalId")@PathVariable("originalId") String originalId) {

        //删除列表数据
        QueryWrapper<BizDigitalOnLineApplication> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("ORIGINAL_ID_",originalId);
        List<BizDigitalOnLineApplication> list = baseService.list(queryWrapper);
        if (list!=null&&list.size()>0){
            List<String> ids = list.stream().map(BizDigitalOnLineApplication::getId).collect(Collectors.toList());
            //删除推进表信息
            bizDigitalAdvanceConstructionManager.remove(new QueryWrapper<BizDigitalAdvanceConstruction>().in("PUSH_ID_",ids));
            baseService.removeByIds(ids);
        }
        return CommonResult.success(originalId, "数据删除成功！");
    }

    @PostMapping(value="/queryByPage")
    @ApiOperation("分页查询")
    public PageList<BizDigitalOnLineApplication> queryPush(@RequestBody QueryFilter<BizDigitalOnLineApplication> queryFilter) {
        return  baseService.queryByPage(queryFilter);
    }

    @PostMapping(value="/queryByPageNew")
    @ApiOperation("分页查询最新数据")
    public PageList<BizDigitalOnLineApplication> queryByPageNew(@RequestBody QueryFilter<BizDigitalOnLineApplication> queryFilter) {
        return  baseService.queryByPageNew(queryFilter);
    }
}
