package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.manager.BizBlockageCardTransferManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.model.BizReformDemandAssignmentRecord;
import com.artfess.uc.api.impl.model.Org;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizBlockageCardTransferRecord;
import com.artfess.reform.fill.manager.BizBlockageCardTransferRecordManager;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 堵点卡点交办推进记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
@RestController
@RequestMapping("/bizBlockageCardTransferRecord/v1/")
@Api(tags = "堵点卡点推进记录")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizBlockageCardTransferRecordController extends BaseController<BizBlockageCardTransferRecordManager, BizBlockageCardTransferRecord> {


    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@RequestBody BizBlockageCardTransferRecord record) {
        String id = baseService.insertInfo(record);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>(true,"保存成功！",id);
    }

    @PostMapping("/updateById")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> updateById(@RequestBody BizBlockageCardTransferRecord bizBlockageCardTransferRecord) {
        baseService.updateInfo(bizBlockageCardTransferRecord);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/updateAuditStatus")
    @ApiOperation("修改审核状态")
    public CommonResult<String> updateAuditStatus(@RequestBody BizBlockageCardTransferRecord record) {
        baseService.updateAuditStatus(record);
        return new CommonResult<>();
    }

}
