package com.artfess.reform.approvalLog.manager;

import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;

import java.util.List;

/**
 *  服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-11
 */
public interface AchieveStatusLogManager extends BaseManager<AchieveStatusLog> {

    /**
     * 同时创建功能审批操作日志及审批记录
     * @param achieveStatusLogAndAuditResultVo
     * @return
     */
    boolean createAchieveStatusLogAndAuditResult(AchieveStatusLogAndAuditResultVo achieveStatusLogAndAuditResultVo);

    /**
     * 批量同时创建功能审批操作日志及审批记录
     * @param achieveStatusLogAndAuditResultVoList
     * @return
     */
    boolean createAchieveStatusLogAndAuditResultBatch(List<AchieveStatusLogAndAuditResultVo> achieveStatusLogAndAuditResultVoList);

    /**
    * @Description: 根据业务ID查询最新的一条审核日志
    * @param bizId  业务ID
    * @param status  审批状态
    * @Return: com.artfess.reform.approvalLog.model.AchieveStatusLog
    * @Author: chens
    * @Date: 2023/3/28 14:29
    */
    AchieveStatusLog queryAchieveStatusLogByBizIdAndStatus(String bizId,Integer status);

    /**
     * 根据bizId查询操作日志
     * @param bizId
     * @return
     */
    List<AchieveStatusLog> process(String bizId);
}
