package com.artfess.reform.approvalLog.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;

import javax.annotation.Resource;
import java.util.List;

/**
 *  前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-11
 */
@RestController
@RequestMapping("/approvalLog/bizAchieveStatusLog/v1/")
@Api(tags = "功能审批-操作状态日志跟踪记录")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class AchieveStatusLogController extends BaseController<AchieveStatusLogManager, AchieveStatusLog> {

    @PutMapping("/createAchieveStatusLogAndAuditResult")
    @ApiOperation("创建功能审批操作日志及审批记录")
    public CommonResult<String> createAchieveStatusLogAndAuditResult(AchieveStatusLogAndAuditResultVo achieveStatusLogAndAuditResultVo) {
        boolean save = this.baseService.createAchieveStatusLogAndAuditResult(achieveStatusLogAndAuditResultVo);
        return CommonResult.success(null, "数据保存成功！");
    }

    @PutMapping("/createAchieveStatusLogAndAuditResultBatch")
    @ApiOperation("创建功能审批操作日志及审批记录")
    public CommonResult<String> createAchieveStatusLogAndAuditResultBatch(List<AchieveStatusLogAndAuditResultVo> achieveStatusLogAndAuditResultVoList) {
        boolean save = this.baseService.createAchieveStatusLogAndAuditResultBatch(achieveStatusLogAndAuditResultVoList);
        return CommonResult.success(null, "数据保存成功！");
    }

    @PutMapping("/queryAchieveStatusLogByBizIdAndStatus")
    @ApiOperation("根据业务id获取最新的审批记录日志")
    public AchieveStatusLog queryAchieveStatusLogByBizIdAndStatus(@RequestParam(name = "bizId",required = true) String bizId,@RequestParam(name = "status",required = true) Integer status) {
        AchieveStatusLog log = this.baseService.queryAchieveStatusLogByBizIdAndStatus(bizId,status);
        return log;
    }

    @PostMapping("/process/{bizId}")
    @ApiOperation("创建功能审批操作日志及审批记录")
    public List<AchieveStatusLog> process(@PathVariable(value = "bizId") String bizId) {
        return baseService.process(bizId);
    }
}
