package com.artfess.file.persistence.dao;

import com.artfess.file.model.FileConfig;
import com.artfess.file.params.FileStorageConfigDTO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 附件配置信息 Mapper 接口
 *
 * @company rzx
 * @author wh
 * @since 2021-03-04
 */
public interface FileConfigDao extends BaseMapper<FileConfig> {

    /**
    * @Description: 根据编码获取附件存储配置信息
    * @param code
    * @Return: com.artfess.file.params.FileStorageConfigDTO
    * @Author: chens
    * @Date: 2021/6/8 11:39
    */
    List<FileStorageConfigDTO> getFileConfigByCode(@Param("code") String code);

    /**
     * @Description: 分页查询
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    IPage<FileConfig> queryPage(IPage<FileConfig> convert2iPage, @Param(Constants.WRAPPER) Wrapper<FileConfig> convert2Wrapper);

    /**
     * @Description: 通过ＩＤ查询
     * @Author: chens
     * @Date: 2021/6/8 11:39
     */
    FileConfig getOneById(String id);

}
