/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.utils;

import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.IsoFields;

public class FieldFillUtil {
    public static void fillDateFields(LocalDate currentDate, Object obj) {
        try {
            Integer currentYear = currentDate.getYear();
            Integer currentMonth = currentDate.getMonthValue();
            Integer currentQuarter = currentDate.get(IsoFields.QUARTER_OF_YEAR);
            Field fillDateField = FieldFillUtil.getField(obj, "fillDate");
            fillDateField.set(obj, LocalDate.now());
            Field fillYearField = FieldFillUtil.getField(obj, "fillYear");
            fillYearField.set(obj, currentYear);
            Field fillMonthField = FieldFillUtil.getField(obj, "fillMonth");
            fillMonthField.set(obj, currentMonth);
            Field fillQuarterField = FieldFillUtil.getField(obj, "fillQuarter");
            fillQuarterField.set(obj, currentQuarter);
            int lastDayOfMonth = currentDate.lengthOfMonth();
            Field fillTypeField = FieldFillUtil.getField(obj, "fillType");
            if (currentDate.getDayOfMonth() == lastDayOfMonth) {
                if (currentMonth.intValue() == Month.DECEMBER.getValue() && currentDate.getDayOfYear() == lastDayOfMonth) {
                    fillTypeField.set(obj, "Y");
                } else if (currentQuarter == 4 && currentDate.getDayOfYear() == lastDayOfMonth) {
                    fillTypeField.set(obj, "Q");
                } else {
                    fillTypeField.set(obj, "M");
                }
            } else {
                fillTypeField.set(obj, "D");
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getField(Object obj, String fieldName) {
        Field field;
        block3: {
            Class<?> clazz = obj.getClass();
            field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                Class<?> superclass = clazz.getSuperclass();
                if (superclass == null) break block3;
                field = FieldFillUtil.getField(superclass, fieldName);
            }
        }
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }
}

