/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.schedule;

import com.artfess.reform.statistics.manager.BizScoringProjectBrandManager;
import com.artfess.reform.statistics.manager.BizScoringProjectIterationManager;
import com.artfess.reform.statistics.manager.BizScoringProjectMeasureManager;
import com.artfess.reform.statistics.manager.BizScoringProjectSynManager;
import com.artfess.reform.statistics.manager.BizScoringProjectTargetManager;
import java.time.LocalDate;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class ProjectSchedule {
    @Resource
    private BizScoringProjectTargetManager bizScoringProjectTargetManager;
    @Resource
    private BizScoringProjectBrandManager bizScoringProjectBrandManager;
    @Resource
    private BizScoringProjectMeasureManager bizScoringProjectMeasureManager;
    @Resource
    private BizScoringProjectIterationManager bizScoringProjectIterationManager;
    @Resource
    private BizScoringProjectSynManager bizScoringProjectSynManager;

    @Scheduled(cron="0 55 23 * * ?")
    public void scheduleProjectScore() {
        LocalDate countDate = LocalDate.now();
        this.bizScoringProjectTargetManager.countScore(countDate);
        this.bizScoringProjectBrandManager.countScore(countDate);
        this.bizScoringProjectMeasureManager.countScore(countDate);
        this.bizScoringProjectSynManager.countScore(countDate);
    }

    @Scheduled(cron="0 45 23 * * ?")
    public void scheduleProjectIteration() {
        LocalDate countDate = LocalDate.now();
        this.bizScoringProjectIterationManager.countScore(countDate);
    }
}

