/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.dao.BizPilotAdvanceRecordDao;
import com.artfess.reform.fill.dao.BizPilotAdvanceResultDao;
import com.artfess.reform.fill.dao.BizReformRiskManagementDao;
import com.artfess.reform.fill.dao.BizReformSatisfactionDistrictsDao;
import com.artfess.reform.fill.dao.BizReformSatisfactionManagementDao;
import com.artfess.reform.fill.manager.BizBlockageCardTransferManager;
import com.artfess.reform.fill.manager.BizEffectEffectivenessManager;
import com.artfess.reform.fill.manager.BizPilotAdvanceResultManager;
import com.artfess.reform.fill.manager.BizReformDemandAnalysisLibraryManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.manager.BizReformPilotManagementManager;
import com.artfess.reform.fill.manager.BizReformSatisfactionManagementManager;
import com.artfess.reform.fill.manager.BizReformWorkReportManager;
import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.artfess.reform.fill.model.BizEffectEffectiveness;
import com.artfess.reform.fill.model.BizPilotAdvanceRecord;
import com.artfess.reform.fill.model.BizPilotAdvanceResult;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.artfess.reform.fill.model.BizReformRiskManagement;
import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.reform.fill.model.BizReformSatisfactionManagement;
import com.artfess.reform.fill.model.BizReformWorkReport;
import com.artfess.reform.fill.vo.PilotAdvanceResultNumVo;
import com.artfess.reform.statistics.dao.BizScoringCountyBrandDao;
import com.artfess.reform.statistics.dao.BizScoringCountySynDao;
import com.artfess.reform.statistics.dao.BizScoringCountyWorkableDao;
import com.artfess.reform.statistics.manager.CountyLargeScreeManager;
import com.artfess.reform.statistics.model.BizScoringCountyBrand;
import com.artfess.reform.statistics.model.BizScoringCountySyn;
import com.artfess.reform.statistics.model.BizScoringCountyWorkable;
import com.artfess.reform.statistics.vo.BrandCalVo;
import com.artfess.reform.statistics.vo.CoreIndexVo;
import com.artfess.reform.statistics.vo.CountyBrandVo;
import com.artfess.reform.statistics.vo.CountyChartVo;
import com.artfess.reform.statistics.vo.CountyPilotReformVo;
import com.artfess.reform.statistics.vo.CountySynVo;
import com.artfess.reform.statistics.vo.StatementDetailVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.IsoFields;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CountyLargeScreeManagerImpl
implements CountyLargeScreeManager {
    @Resource
    private BizReformPilotManagementManager reformPilotManager;
    @Resource
    private BizPilotAdvanceResultManager advanceResultManager;
    @Resource
    private BizEffectEffectivenessManager effectManager;
    @Resource
    private OrgManager orgManager;
    @Resource
    private BizReformRiskManagementDao riskDao;
    @Resource
    private BizReformDemandAnalysisLibraryManager demandManager;
    @Resource
    private BizReformDemandAssignmentManager demandRecordMaanger;
    @Resource
    private SysDictionaryManager sdm;
    @Resource
    private BizScoringCountyWorkableDao workableDao;
    @Resource
    private BizScoringCountyBrandDao brandDao;
    @Resource
    private BizScoringCountySynDao synDao;
    @Resource
    private BizReformSatisfactionDistrictsDao satisfacttDao;
    @Resource
    private BizReformSatisfactionManagementDao satisfacttMangerDao;
    @Resource
    private BizPilotAdvanceRecordDao pilotRecordDao;
    @Resource
    private BizPilotAdvanceResultDao pilotResultDao;
    @Resource
    private BizBlockageCardTransferManager transferManager;
    @Resource
    private FileManager fileManager;
    @Resource
    private BizReformSatisfactionManagementManager satisfactionManager;
    @Resource
    private BizReformWorkReportManager reportManager;
    private final int currentYear = LocalDate.now().getYear();

    @Override
    public CoreIndexVo importantIndex(Integer year, Integer quarter) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        BizScoringCountyWorkable workableCount = this.workableDao.statisticsPilotNum(year, quarter);
        BizScoringCountyWorkable workable = this.workableDao.statisticsLatest(year, quarter);
        BizScoringCountyBrand brand = this.brandDao.statisticsLatest(year, quarter);
        BizReformSatisfactionDistricts satisfactions = this.satisfacttDao.qureySatisfactionDistrictsByUnitCode("500000");
        CoreIndexVo coreIndexVo = new CoreIndexVo();
        if (workableCount != null) {
            coreIndexVo.setNationalProjectNum(workableCount.getNationalProjectNum());
            coreIndexVo.setCityProjectNum(workableCount.getCityProjectNum());
            coreIndexVo.setAddNum(workableCount.getAddNum());
        } else {
            coreIndexVo.setNationalProjectNum(0);
            coreIndexVo.setCityProjectNum(0);
            coreIndexVo.setAddNum(0);
        }
        if (workable != null) {
            Integer projectEndNum = workable.getProjectEndNum();
            if (projectEndNum == null || projectEndNum == 0) {
                coreIndexVo.setPassRate(new BigDecimal(0.0));
            } else {
                BigDecimal passRate = new BigDecimal(workable.getPassNum()).divide(new BigDecimal(workable.getProjectEndNum()), 4, 4);
                coreIndexVo.setPassRate(passRate.multiply(new BigDecimal(100)));
            }
        } else {
            coreIndexVo.setPassRate(new BigDecimal(0.0));
        }
        if (brand != null) {
            coreIndexVo.setNationwideNum(brand.getNationwideNum());
            coreIndexVo.setCityNum(brand.getCityNum());
            coreIndexVo.setMediaNum(brand.getMediaNum());
        } else {
            coreIndexVo.setNationwideNum(0);
            coreIndexVo.setCityNum(0);
            coreIndexVo.setMediaNum(0);
        }
        if (satisfactions != null) {
            coreIndexVo.setSatisfied(satisfactions.getSatisfaction());
        } else {
            coreIndexVo.setSatisfied(new BigDecimal(0.0));
        }
        return coreIndexVo;
    }

    @Override
    public List<CountySynVo> indexRank(Integer year, Integer quarter) {
        List<CountySynVo> list;
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        if (!CollectionUtils.isEmpty(list = this.synDao.indexSynRankBest(year, quarter))) {
            for (CountySynVo countySynVo : list) {
                if (countySynVo.getSynSn() <= 9) {
                    countySynVo.setSynGrade("A");
                    continue;
                }
                if (17 >= countySynVo.getSynSn() && countySynVo.getSynSn() > 9) {
                    countySynVo.setSynGrade("B");
                    continue;
                }
                if (25 >= countySynVo.getSynSn() && countySynVo.getSynSn() > 17) {
                    countySynVo.setSynGrade("C");
                    continue;
                }
                if (33 >= countySynVo.getSynSn() && countySynVo.getSynSn() > 25) {
                    countySynVo.setSynGrade("D");
                    continue;
                }
                if (countySynVo.getSynSn() <= 33) continue;
                countySynVo.setSynGrade("E");
            }
        }
        return list;
    }

    @Override
    public CountyPilotReformVo pilotReform(Integer year, Integer quarter, String unitCode) {
        CountyPilotReformVo result = new CountyPilotReformVo();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        if (StringUtil.isEmpty((String)unitCode)) {
            Map<Integer, List<CountyChartVo>> lineChartData = this.reformPilotManager.lineChartDataForLargeScreen(year, quarter).stream().collect(Collectors.groupingBy(CountyChartVo::getLegend));
            result.setChart(lineChartData);
        }
        ArrayList achievement = Lists.newArrayList();
        List<CountyPilotReformVo> totalAR = this.advanceResultManager.count(0, year, quarter, unitCode);
        Map<Integer, Integer> lastAR = this.advanceResultManager.count(1, year, quarter, unitCode).stream().collect(Collectors.toMap(CountyPilotReformVo::getAchievementType, CountyPilotReformVo::getTotalAchievement));
        if (totalAR != null && totalAR.size() > 0) {
            totalAR.forEach(t -> {
                CountyPilotReformVo a = new CountyPilotReformVo(t.getAchievementType(), t.getTotalAchievement());
                Integer current = t.getTotalAchievement();
                Integer last = (Integer)lastAR.get(t.getAchievementType());
                if (current != null) {
                    a.setTotalAchievement(current);
                    if (last != null) {
                        a.setGapQAchievement(last);
                    } else {
                        a.setGapQAchievement(0);
                    }
                } else {
                    a.setTotalAchievement(0);
                    a.setGapQAchievement(0);
                }
                achievement.add(a);
            });
        }
        result.setAchievement(achievement);
        return result;
    }

    @Override
    public PageList<BizPilotAdvanceResult> pilotResultDetail(QueryFilter<BizPilotAdvanceResult> queryFilter) {
        return this.advanceResultManager.pilotResultDetail(queryFilter);
    }

    @Override
    public CountyBrandVo brandReform(Integer year, Integer quarter, String unitId, List<Integer> effectForm) {
        CountyBrandVo result = new CountyBrandVo();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        Map<String, List<BrandCalVo>> chart = this.brandDao.brandReformChart(year, unitId).stream().collect(Collectors.groupingBy(BrandCalVo::getEffectType));
        chart.entrySet().forEach(en -> {
            List list = (List)en.getValue();
            list.forEach(l -> l.setEffectType(null));
            boolean existsTwelveMonths = IntStream.rangeClosed(1, 12).allMatch(month -> list.stream().anyMatch(vo -> vo.getEffectMonth() == month));
            if (!existsTwelveMonths) {
                IntStream.rangeClosed(1, 12).filter(month -> list.stream().noneMatch(vo -> vo.getEffectMonth() == month)).mapToObj(month -> new BrandCalVo(month, 0)).forEach(list::add);
            }
            list.sort(Comparator.comparingInt(BrandCalVo::getEffectMonth));
        });
        result.setChart(chart);
        List<BizScoringCountyBrand> brandData = this.citywidePromotionRank(year, quarter, 2);
        result.setBrand(brandData);
        return result;
    }

    @Override
    public String satisfactionRealityDate(Integer year, Integer quarter) {
        Assert.notNull((Object)year, (String)"\u67e5\u8be2\u5e74\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)quarter, (String)"\u67e5\u8be2\u5b63\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BizReformSatisfactionManagement satisfaction = this.satisfacttMangerDao.queryLatest();
        String str = "";
        str = satisfaction != null ? (satisfaction.getScoringYear().compareTo(year) == 0 && satisfaction.getScoringQuarter().compareTo(quarter) == 0 ? "" : "\u6ce8\uff1a\u672c\u6570\u636e\u5217\u8868\u5c55\u793a\u7684\u662f" + satisfaction.getScoringYear() + "\u5e74\u7b2c" + satisfaction.getScoringQuarter() + "\u5b63\u5ea6\u7684\u6ee1\u610f\u5ea6\u8c03\u67e5\u6570\u636e\uff0c\u6682\u65e0" + year + "\u5e74\u7b2c" + quarter + "\u5b63\u5ea6\u6ee1\u610f\u5ea6\u8c03\u67e5\u7ed3\u679c\u3002") : "\u6ce8\uff1a\u76ee\u524d\u8fd8\u6ca1\u6709\u4e0a\u4f20\u6ee1\u610f\u5ea6\u8c03\u67e5\u7ed3\u8bba\u6216\u6ee1\u610f\u5ea6\u8c03\u67e5\u8fd8\u6ca1\u901a\u8fc7\u5ba1\u6279\u3002";
        return str;
    }

    @Override
    public List<BizEffectEffectiveness> brandReformDetails(String unitCode, Integer year, Integer quarter, QueryFilter<BizEffectEffectiveness> queryFilter) {
        Assert.notNull((Object)unitCode, (String)"\u533a\u53bf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        Org org = this.orgManager.getByCode(unitCode);
        Assert.notNull((Object)org, (String)"\u4f20\u5165\u7684\u7f16\u7801\u672a\u627e\u5230\u533a\u53bf\u6570\u636e\uff01");
        String unitId = org.getId();
        List<BizEffectEffectiveness> list = this.effectManager.brandDetails(unitId, year, quarter, queryFilter);
        return list;
    }

    @Override
    public List<BizScoringCountyBrand> citywidePromotionRank(Integer year, Integer quarter, Integer type) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        List<BizScoringCountyBrand> brandList = this.brandDao.queryLatest(year, quarter, null, null);
        List<BizScoringCountyBrand> lastBrandList = this.brandDao.queryLatest(year, quarter - 1, null, null);
        Map<String, List<BizScoringCountyBrand>> lastBrandMap = lastBrandList.stream().collect(Collectors.groupingBy(BizScoringCountyBrand::getUnitCode));
        if (brandList != null && brandList.size() > 0) {
            brandList.forEach(brand -> {
                brand.setNationwideAndmediaNum(brand.getNationwideNum() + brand.getMediaNum());
                if (!lastBrandMap.isEmpty()) {
                    BizScoringCountyBrand lastBrand = (BizScoringCountyBrand)((Object)((Object)((List)lastBrandMap.get(brand.getUnitCode())).get(0)));
                    if (lastBrand != null) {
                        brand.setCitySnTrend(lastBrand.getCitySn() - brand.getCitySn());
                        brand.setBrandAllSnTrend(lastBrand.getBrandAllSn() - brand.getBrandAllSn());
                    } else {
                        brand.setCitySnTrend(0);
                        brand.setBrandAllSnTrend(0);
                    }
                } else {
                    brand.setCitySnTrend(0);
                    brand.setBrandAllSnTrend(0);
                }
            });
        }
        return brandList;
    }

    @Override
    public PageList<BizEffectEffectiveness> cityPromotionDetail(QueryFilter<BizEffectEffectiveness> queryFilter) {
        return this.effectManager.cityPromotionDetail(queryFilter);
    }

    @Override
    public JSONArray gisIndex(String type, Integer year, Integer quarter) {
        JSONArray result = new JSONArray();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FILL_YEAR_", (Object)year)).eq((Object)"FILL_QUARTER_", (Object)quarter);
        switch (type) {
            case "satisfaction": 
            case "composite": {
                List<BizScoringCountySyn> synList = this.synDao.queryLatest(year, quarter, null, null);
                result.addAll(synList);
                break;
            }
            case "workable": {
                List<BizScoringCountyWorkable> workable = this.workableDao.queryLatest(year, quarter, null, null);
                result.addAll(workable);
                break;
            }
            case "brand": {
                List<BizScoringCountyBrand> brand = this.brandDao.queryLatest(year, quarter, null, null);
                result.addAll(brand);
                break;
            }
            case "risk": {
                List<BizReformRiskManagement> risk = this.riskDao.queyList(year, quarter, null, null, 1);
                result.addAll(risk);
                break;
            }
            default: {
                throw new RuntimeException("type\u4f20\u9012\u9519\u8bef\uff0c\u5141\u8bb8\u7684\u503c\uff1acomposite \u7efc\u5408\u8bc4\u4ef7\u6307\u6570\u3001workable \u6539\u9769\u843d\u5b9e\u529b\u3001brand \u54c1\u724c\u663e\u793a\u5ea6\u3001satisfaction \u6539\u9769\u6ee1\u610f\u5ea6\u3001risk \u98ce\u9669\u7ba1\u63a7\u529b");
            }
        }
        return result;
    }

    @Override
    public List<CountyChartVo> pilotLedger(Integer year, Integer quarter) {
        ArrayList result = Lists.newArrayList();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        List ssly = this.sdm.queryDictListItemsByCode("ggbb_ssly");
        List sdcj = this.sdm.queryDictListItemsByCode("sdcj");
        List tjzt = this.sdm.queryDictListItemsByCode("sd_tjzt");
        QueryWrapper queryWrapper = new QueryWrapper();
        Integer finalYear = year;
        Integer finalQuarter = quarter;
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"STATUS_", (Object)5)).inSql((Object)"ID_", "SELECT PILOT_ID_ FROM BIZ_PILOT_ADVANCE_RECORD WHERE IS_DELE_='0' AND STATUS_=12")).and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)q.lt((Object)"YEAR(START_TIME_)", (Object)finalYear)).or(qr -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)qr.eq((Object)"YEAR(START_TIME_)", (Object)finalYear)).le((Object)"QUARTER(START_TIME_)", (Object)finalQuarter);
            });
        });
        List pilots = this.reformPilotManager.list((Wrapper)queryWrapper);
        Map<Integer, List<BizReformPilotManagement>> pilotsLevelGroup = pilots.stream().collect(Collectors.groupingBy(BizReformPilotManagement::getPilotLevel));
        pilotsLevelGroup.entrySet().forEach(en -> {
            CountyChartVo level = new CountyChartVo(BizUtils.getDicValueByCode((List<DictModel>)sdcj, (Integer)en.getKey()), (Integer)((List)en.getValue()).size());
            HashMap subData = Maps.newHashMap();
            ArrayList field = Lists.newArrayList();
            Map<Integer, List<BizReformPilotManagement>> fieldMap = ((List)en.getValue()).stream().filter(e -> e.getPilotField() != null).collect(Collectors.groupingBy(BizReformPilotManagement::getPilotField));
            ssly.forEach(dictModel -> {
                int size = 0;
                if (fieldMap.get(Integer.valueOf(dictModel.getValue())) != null) {
                    size = ((List)fieldMap.get(Integer.valueOf(dictModel.getValue()))).size();
                }
                field.add(new CountyChartVo(BizUtils.getDicValueByCode((List<DictModel>)ssly, dictModel.getValue()), (Integer)size));
            });
            subData.put("field", field);
            ArrayList ledger = Lists.newArrayList();
            long n = ((List)en.getValue()).stream().filter(e -> e.getPropulsiveStatus() == null).count();
            Map<Integer, List<BizReformPilotManagement>> ledgerMap = ((List)en.getValue()).stream().filter(e -> e.getPropulsiveStatus() != null).collect(Collectors.groupingBy(BizReformPilotManagement::getPropulsiveStatus));
            tjzt.forEach(dictModel -> {
                int size = 0;
                if (ledgerMap.get(Integer.valueOf(dictModel.getValue())) != null) {
                    size = ((List)ledgerMap.get(Integer.valueOf(dictModel.getValue()))).size();
                }
                if (dictModel.getValue().equals("1")) {
                    ledger.add(new CountyChartVo(BizUtils.getDicValueByCode((List<DictModel>)tjzt, dictModel.getValue()), (Integer)Math.toIntExact((long)size + n)));
                } else {
                    ledger.add(new CountyChartVo(BizUtils.getDicValueByCode((List<DictModel>)tjzt, dictModel.getValue()), (Integer)size));
                }
            });
            subData.put("ledger", ledger);
            level.setSubData(subData);
            result.add(level);
        });
        return result;
    }

    @Override
    public PageList<BizReformPilotManagement> pilotLedgerDetail(QueryFilter<BizReformPilotManagement> queryFilter) {
        queryFilter.addFilter("STATUS_", (Object)5, QueryOP.EQUAL);
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageList<BizReformPilotManagement> data = this.reformPilotManager.queryDetail(queryFilter);
        return data;
    }

    @Override
    public BizReformPilotManagement pilotPushDetail(String pilotId, String unitCode) {
        List<BizPilotAdvanceRecord> list;
        Assert.hasText((String)pilotId, (String)"\u8bf7\u9009\u62e9\u8bd5\u70b9\u9879\u76ee");
        Assert.hasText((String)unitCode, (String)"\u8bf7\u9009\u62e9\u8bd5\u70b9\u9879\u76ee\u7684\u63a8\u8fdb\u533a\u53bf");
        BizReformPilotManagement pilotManagement = (BizReformPilotManagement)((Object)this.reformPilotManager.getById((Serializable)((Object)pilotId)));
        if (pilotManagement != null && (list = this.pilotRecordDao.queryLatest(pilotId, null, unitCode)) != null && list.size() > 0) {
            BizPilotAdvanceRecord record = list.get(0);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"PILOT_ID_", (Object)pilotId);
            queryWrapper.eq((Object)"RECORD_ID_", (Object)record.getId());
            pilotManagement.setExistingProblems(record == null ? null : record.getExistingProblems());
            pilotManagement.setWorkPlan(record == null ? null : record.getWorkPlan());
            pilotManagement.setPropulDetails(record == null ? null : record.getPropulsiveDetails());
            List<PilotAdvanceResultNumVo> rList = this.pilotResultDao.countByPilot(pilotId, null, null, unitCode);
            pilotManagement.setResultNumList(rList);
            pilotManagement.setAncPropulsiveStatus(record.getPropulsiveStatus());
        }
        return pilotManagement;
    }

    @Override
    public JSONObject historyStatementFile(Integer year) {
        JSONObject result = new JSONObject();
        List satisList = this.satisfactionManager.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"STATUS_", (Object)5)).eq((Object)"is_dele_", (Object)0)).eq((Object)"SCORING_YEAR_", (Object)(year == null ? this.currentYear : year)));
        List satisfactionIDs = satisList.stream().map(BizReformSatisfactionManagement::getId).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(satisfactionIDs)) {
            List satFiles = this.fileManager.list((Wrapper)new QueryWrapper().in((Object)"biz_id_", satisfactionIDs));
            JSONObject quarterGroup = new JSONObject();
            satisList.forEach(s -> satFiles.stream().filter(sf -> s.getId().equals(sf.getBizId())).forEach(sf -> quarterGroup.put(String.valueOf(s.getScoringQuarter()), sf)));
            result.put("satisfaction", BeanUtils.isNotEmpty((Object)satFiles) ? quarterGroup : this.currentYear + "\u5e74" + " \u6682\u65e0\u6ee1\u610f\u5ea6\u62a5\u544a\u6570\u636e\uff01");
        } else {
            result.put("satisfaction", (Object)(this.currentYear + "\u5e74" + " \u6682\u65e0\u6ee1\u610f\u5ea6\u62a5\u544a\u6570\u636e\uff01"));
        }
        List reportList = this.reportManager.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_dele_", (Object)0)).orderByDesc((Object)"REPORT_DATE_")).last("limit 1"));
        List reportIDs = reportList.stream().map(BizReformWorkReport::getId).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(reportIDs)) {
            List reportFiles = this.fileManager.list((Wrapper)new QueryWrapper().in((Object)"biz_id_", reportIDs));
            JSONObject quarterGroup = new JSONObject();
            reportList.forEach(r -> reportFiles.stream().filter(rf -> r.getId().equals(rf.getBizId())).forEach(rf -> quarterGroup.put(String.valueOf(r.getReportQuarter()), rf)));
            result.put("composite", BeanUtils.isNotEmpty((Object)reportFiles) ? quarterGroup : this.currentYear + "\u5e74 \u6682\u65e0\u6ee1\u610f\u5ea6\u62a5\u544a\u6570\u636e\uff01");
        } else {
            result.put("composite", (Object)(this.currentYear + "\u5e74 \u6682\u65e0\u6ee1\u610f\u5ea6\u62a5\u544a\u6570\u636e\uff01"));
        }
        return result;
    }

    @Override
    public JSONObject currentStatementFile(Integer year, Integer quarter) {
        BizReformSatisfactionManagement satis;
        JSONObject result = new JSONObject();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        String currentSatisId = BeanUtils.isNotEmpty((Object)((Object)(satis = (BizReformSatisfactionManagement)((Object)this.satisfactionManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"STATUS_", (Object)5)).eq((Object)"is_dele_", (Object)0)).eq((Object)"SCORING_YEAR_", (Object)year)).eq((Object)"SCORING_QUARTER_", (Object)quarter)))))) ? satis.getId() : null;
        DefaultFile satisCurrentFile = (DefaultFile)this.fileManager.getOne((Wrapper)new QueryWrapper().eq((Object)"biz_id_", (Object)currentSatisId));
        result.put("satisfaction", (Object)satisCurrentFile);
        BizReformWorkReport report = (BizReformWorkReport)((Object)this.reportManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_dele_", (Object)0)).eq((Object)"REPORT_YEAR_", (Object)year)).eq((Object)"REPORT_QUARTER_", (Object)quarter)).orderByDesc((Object)"REPORT_DATE_")).last("limit 1")));
        String reportId = BeanUtils.isNotEmpty((Object)((Object)report)) ? report.getId() : null;
        DefaultFile reportCurrentFile = (DefaultFile)this.fileManager.getOne((Wrapper)new QueryWrapper().eq((Object)"biz_id_", (Object)reportId));
        result.put("composite", (Object)reportCurrentFile);
        return result;
    }

    @Override
    public CoreIndexVo queryCoreIndex(String unitCode, Integer year, Integer quarter) {
        Assert.hasText((String)unitCode, (String)"\u67e5\u8be2\u533a\u53bf\u6838\u5fc3\u6307\u6570\u7684\u533a\u53bf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        List<BizScoringCountyBrand> currentBrands = this.brandDao.queryLatest(year, quarter, null, unitCode);
        List<BizScoringCountyWorkable> currentWorkables = this.workableDao.queryLatest(year, quarter, null, unitCode);
        List<BizScoringCountySyn> currentSyns = this.synDao.queryLatest(year, quarter, null, unitCode);
        List<Object> lastBrands = new ArrayList();
        List<Object> lastWorkables = new ArrayList();
        List<Object> lastSyns = new ArrayList();
        if (quarter != 1) {
            int lastQuarter = quarter - 1;
            lastBrands = this.brandDao.queryLatest(year, lastQuarter, "Q", unitCode);
            lastWorkables = this.workableDao.queryLatest(year, lastQuarter, "Q", unitCode);
            lastSyns = this.synDao.queryLatest(year, lastQuarter, "Q", unitCode);
        }
        CoreIndexVo coreIndexVo = new CoreIndexVo();
        if (currentSyns != null && currentSyns.size() > 0) {
            BizScoringCountySyn currentSyn = currentSyns.get(0);
            coreIndexVo.setFillDate(currentSyn.getFillDate());
            coreIndexVo.setFillYear(currentSyn.getFillYear());
            coreIndexVo.setUnitCode(unitCode);
            coreIndexVo.setUnitName(currentSyn.getUnitName());
            coreIndexVo.setUnitGrade(currentSyn.getUnitGrade());
            coreIndexVo.setSatisfied(currentSyn.getSatisfied());
            coreIndexVo.setSatisfiedAllSn(currentSyn.getSatisfiedAllSn() == null ? 0 : currentSyn.getSatisfiedAllSn());
            coreIndexVo.setSatisfiedGrade(currentSyn.getSatisfiedGrade());
            if (lastSyns != null && lastSyns.size() > 0) {
                int satisfiedTrend = 0;
                if (currentSyn.getSatisfiedAllSn() != null && ((BizScoringCountySyn)((Object)lastSyns.get(0))).getSatisfiedAllSn() != null) {
                    satisfiedTrend = ((BizScoringCountySyn)((Object)lastSyns.get(0))).getSatisfiedAllSn() - currentSyn.getSatisfiedAllSn();
                }
                coreIndexVo.setSatisfiedAllTrend(satisfiedTrend);
            } else {
                coreIndexVo.setSatisfiedAllTrend(0);
            }
        }
        if (currentWorkables != null && currentWorkables.size() > 0) {
            BizScoringCountyWorkable currentWorkable = currentWorkables.get(0);
            coreIndexVo.setNationalProjectNum(currentWorkable.getNationalProjectNum());
            coreIndexVo.setNationalProjectSn(currentWorkable.getNationalProjectSn());
            coreIndexVo.setNationalProjectGrade(currentWorkable.getNationalProjectGrade());
            coreIndexVo.setCityProjectNum(currentWorkable.getCityProjectNum());
            coreIndexVo.setCityProjectSn(currentWorkable.getCityProjectSn());
            coreIndexVo.setCityProjectGrade(currentWorkable.getCityProjectGrade());
            coreIndexVo.setAddNum(currentWorkable.getAddNum());
            coreIndexVo.setAddSn(currentWorkable.getAddSn());
            coreIndexVo.setAddGrade(currentWorkable.getAddGrade());
            coreIndexVo.setPassRate(currentWorkable.getPassRate());
            coreIndexVo.setPassSn(currentWorkable.getPassSn());
            coreIndexVo.setPassGrade(currentWorkable.getPassGrade());
            if (lastWorkables != null && lastWorkables.size() > 0) {
                int nationalProjectTrend = ((BizScoringCountyWorkable)((Object)lastWorkables.get(0))).getNationalProjectSn() - currentWorkable.getNationalProjectSn();
                int cityProjectTrend = ((BizScoringCountyWorkable)((Object)lastWorkables.get(0))).getCityProjectSn() - currentWorkable.getCityProjectSn();
                int passTrend = ((BizScoringCountyWorkable)((Object)lastWorkables.get(0))).getPassSn() - currentWorkable.getPassSn();
                int addTrend = ((BizScoringCountyWorkable)((Object)lastWorkables.get(0))).getAddSn() - currentWorkable.getAddSn();
                coreIndexVo.setNationalProjectTrend(nationalProjectTrend);
                coreIndexVo.setCityProjectTrend(cityProjectTrend);
                coreIndexVo.setPassTrend(passTrend);
                coreIndexVo.setAddTrend(addTrend);
            } else {
                coreIndexVo.setWorkableAllTrend(0);
                coreIndexVo.setNationalProjectTrend(0);
                coreIndexVo.setCityProjectTrend(0);
                coreIndexVo.setPassTrend(0);
                coreIndexVo.setAddTrend(0);
            }
        }
        if (currentBrands != null && currentBrands.size() > 0) {
            BizScoringCountyBrand currentBrand = currentBrands.get(0);
            coreIndexVo.setNationwideNum(currentBrand.getNationwideNum());
            coreIndexVo.setNationwideSn(currentBrand.getNationwideSn());
            coreIndexVo.setNationwideGrade(currentBrand.getNationwideGrade());
            coreIndexVo.setCityNum(currentBrand.getCityNum());
            coreIndexVo.setCitySn(currentBrand.getCitySn());
            coreIndexVo.setCityGrade(currentBrand.getCityGrade());
            coreIndexVo.setMediaNum(currentBrand.getMediaNum());
            coreIndexVo.setMediaSn(currentBrand.getMediaSn());
            coreIndexVo.setMediaGrade(currentBrand.getMediaGrade());
            if (lastBrands != null && lastBrands.size() > 0) {
                int nationwideTrend = ((BizScoringCountyBrand)((Object)lastBrands.get(0))).getNationwideSn() - currentBrand.getNationwideSn();
                int cityTrend = ((BizScoringCountyBrand)((Object)lastBrands.get(0))).getCitySn() - currentBrand.getCitySn();
                int mediaTrend = ((BizScoringCountyBrand)((Object)lastBrands.get(0))).getMediaSn() - currentBrand.getMediaSn();
                coreIndexVo.setNationwideTrend(nationwideTrend);
                coreIndexVo.setCityTrend(cityTrend);
                coreIndexVo.setMediaTrend(mediaTrend);
            } else {
                coreIndexVo.setNationwideTrend(0);
                coreIndexVo.setCityTrend(0);
                coreIndexVo.setMediaTrend(0);
            }
        }
        return coreIndexVo;
    }

    @Override
    public CoreIndexVo queryIndexSn(String unitCode, Integer year, Integer quarter) {
        Assert.hasText((String)unitCode, (String)"\u67e5\u8be2\u533a\u53bf\u6838\u5fc3\u6307\u6570\u7684\u533a\u53bf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        List<BizScoringCountyWorkable> currentWorkables = this.workableDao.queryLatest(year, quarter, null, unitCode);
        List<BizScoringCountyWorkable> passAndPush = this.workableDao.queryPassAndPush(year, quarter, unitCode);
        List<Object> lastWorkables = new ArrayList();
        if (quarter != 1) {
            int lastQuarter = quarter - 1;
            lastWorkables = this.workableDao.queryLatest(year, lastQuarter, "Q", unitCode);
        }
        CoreIndexVo coreIndexVo = new CoreIndexVo();
        if (currentWorkables != null && currentWorkables.size() > 0) {
            BizScoringCountyWorkable workable = currentWorkables.get(0);
            coreIndexVo.setFillDate(workable.getFillDate());
            coreIndexVo.setFillYear(workable.getFillYear());
            coreIndexVo.setUnitCode(unitCode);
            coreIndexVo.setUnitName(workable.getUnitName());
            coreIndexVo.setUnitGrade(Integer.valueOf(workable.getUnitGrade()));
            coreIndexVo.setNationalProjectNum(workable.getNationalProjectNum());
            coreIndexVo.setNationalProjectSn(workable.getNationalProjectSn());
            coreIndexVo.setCityProjectNum(workable.getCityProjectNum());
            coreIndexVo.setCityProjectSn(workable.getCityProjectSn());
            coreIndexVo.setCityAddNum(workable.getCityAddNum());
            coreIndexVo.setNationalAddNum(workable.getNationalAddNum());
            if (lastWorkables != null && lastWorkables.size() > 0) {
                int nationalProjectAdd = workable.getNationalProjectNum() - ((BizScoringCountyWorkable)((Object)lastWorkables.get(0))).getNationalProjectNum();
                int cityProjectAdd = workable.getCityProjectNum() - ((BizScoringCountyWorkable)((Object)lastWorkables.get(0))).getCityProjectNum();
                coreIndexVo.setNationalProjectAddNum(nationalProjectAdd);
                coreIndexVo.setCityProjectAddNum(cityProjectAdd);
            } else {
                coreIndexVo.setNationalProjectAddNum(workable.getNationalProjectNum());
                coreIndexVo.setCityProjectAddNum(workable.getCityProjectNum());
            }
            if (passAndPush != null && passAndPush.size() > 0) {
                coreIndexVo.setNationalPassNum(passAndPush.get(0).getNationalPassNum());
                coreIndexVo.setNationalPushNum(passAndPush.get(0).getNationalPushNum());
                coreIndexVo.setCityPassNum(passAndPush.get(0).getCityPassNum());
                coreIndexVo.setCityPushNum(passAndPush.get(0).getCityPushNum());
            } else {
                coreIndexVo.setNationalPassNum(0);
                coreIndexVo.setNationalPushNum(0);
                coreIndexVo.setCityPassNum(0);
                coreIndexVo.setCityPushNum(0);
            }
        }
        return coreIndexVo;
    }

    @Override
    public List<StatementDetailVo> statementDetail(Integer year, Integer quarter) {
        List<StatementDetailVo> result;
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        if (!CollectionUtils.isEmpty(result = this.synDao.statementDetail(year, quarter))) {
            List<CountySynVo> list = this.synDao.indexSynRankBest(year, quarter);
            if (!CollectionUtils.isEmpty(list)) {
                for (CountySynVo countySynVo : list) {
                    if (countySynVo.getSynSn() <= 9) {
                        countySynVo.setSynGrade("A");
                    } else if (17 >= countySynVo.getSynSn() && countySynVo.getSynSn() > 9) {
                        countySynVo.setSynGrade("B");
                    } else if (25 >= countySynVo.getSynSn() && countySynVo.getSynSn() > 17) {
                        countySynVo.setSynGrade("C");
                    } else if (33 >= countySynVo.getSynSn() && countySynVo.getSynSn() > 25) {
                        countySynVo.setSynGrade("D");
                    } else if (countySynVo.getSynSn() > 33) {
                        countySynVo.setSynGrade("E");
                    }
                    for (StatementDetailVo statementDetailVo : result) {
                        if (!statementDetailVo.getUnitCode().equals(countySynVo.getUnitCode())) continue;
                        statementDetailVo.setAllSn(countySynVo.getSynSn());
                        statementDetailVo.setAllGrade(countySynVo.getSynGrade());
                        statementDetailVo.setScore(new BigDecimal(countySynVo.getSynScore() == null ? 0 : countySynVo.getSynScore()));
                    }
                }
            }
            result.sort(Comparator.comparingInt(StatementDetailVo::getAllSn));
        }
        return result;
    }

    @Override
    public JSONObject reformDemand(Integer year, Integer quarter, String unitCode) {
        Assert.notNull((Object)unitCode, (String)"\u533a\u53bf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        JSONObject result = new JSONObject();
        List cyzt = this.sdm.queryDictListItemsByCode("ggbb_cyzt");
        List xqzt = this.sdm.queryDictListItemsByCode("xqzt");
        List demandDataList = this.demandManager.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RESPONSIBLE_UNIT_CODE_", (Object)unitCode)).eq((Object)"DEMAND_YEAR_", (Object)year)).le((Object)"DEMAND_QUARTER_", (Object)quarter)).eq((Object)"STATUS_", (Object)5));
        Map<Integer, List<BizReformDemandAnalysisLibrary>> demandData = demandDataList.stream().collect(Collectors.groupingBy(BizReformDemandAnalysisLibrary::getDemandAdoptionStatus));
        HashMap<String, Integer> demandMap = new HashMap<String, Integer>();
        demandMap.put("totlal", demandDataList.size());
        cyzt.forEach(dictModel -> {
            String key = "";
            if (dictModel.getValue().equals("1")) {
                key = "incomeNum";
            } else if (dictModel.getValue().equals("2")) {
                key = "assignNum";
            } else if (dictModel.getValue().equals("3")) {
                key = "projectNum";
            } else if (dictModel.getValue().equals("4")) {
                key = "stopNum";
            }
            if (demandData.get(Integer.valueOf(dictModel.getValue())) != null) {
                demandMap.put(key, ((List)demandData.get(Integer.valueOf(dictModel.getValue()))).size());
            } else {
                demandMap.put(key, 0);
            }
        });
        result.put("demand", demandMap);
        List assignmentList = this.demandRecordMaanger.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RESPONSIBLE_UNIT_CODE_", (Object)unitCode)).eq((Object)"PROPULSIVE_YEAR_", (Object)year)).le((Object)"PROPULSIVE_QUARTER_", (Object)quarter));
        Map<Integer, List<BizReformDemandAssignment>> fulfillData = assignmentList.stream().collect(Collectors.groupingBy(BizReformDemandAssignment::getDemandStatus));
        HashMap<String, Integer> fulfillMap = new HashMap<String, Integer>();
        fulfillMap.put("totlal", fulfillData.size());
        xqzt.forEach(dictModel -> {
            String key = "undefined";
            if (dictModel.getValue().equals("1")) {
                key = "unStartNum";
            } else if (dictModel.getValue().equals("2")) {
                key = "pushNum";
            } else if (dictModel.getValue().equals("3")) {
                key = "endNum";
            }
            if (fulfillData.get(Integer.valueOf(dictModel.getValue())) != null) {
                fulfillMap.put(key, ((List)fulfillData.get(Integer.valueOf(dictModel.getValue()))).size());
            } else {
                fulfillMap.put(key, 0);
            }
        });
        result.put("fulfill", fulfillMap);
        return result;
    }

    @Override
    public JSONObject problemSolving(Integer year, Integer quarter, String unitCode) {
        Assert.notNull((Object)unitCode, (String)"\u533a\u53bf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        JSONObject result = new JSONObject();
        List tjztDict = this.sdm.queryDictListItemsByCode("tjzt");
        List list = this.transferManager.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_DELE_", (Object)"0")).eq((Object)"UNIT_CODE_", (Object)unitCode)).eq((Object)"BLOCKAGE_YEAR_", (Object)year)).le((Object)"BLOCKAGE_QUARTER_", (Object)quarter));
        Map<Integer, List<BizBlockageCardTransfer>> countData = list.stream().collect(Collectors.groupingBy(BizBlockageCardTransfer::getPropulsiveStatus));
        HashMap<String, Integer> statisticsNum = new HashMap<String, Integer>();
        statisticsNum.put("totlal", list.size());
        tjztDict.forEach(dictModel -> {
            String key = "undefined";
            if (dictModel.getValue().equals("1")) {
                key = "unStartNum";
            } else if (dictModel.getValue().equals("2")) {
                key = "pushNum";
            } else if (dictModel.getValue().equals("3")) {
                key = "endNum";
            }
            if (countData.get(Integer.valueOf(dictModel.getValue())) != null) {
                statisticsNum.put(key, ((List)countData.get(Integer.valueOf(dictModel.getValue()))).size());
            } else {
                statisticsNum.put(key, 0);
            }
        });
        result.put("count", statisticsNum);
        List<BizBlockageCardTransfer> detail = this.transferManager.problemSolvingDetail(unitCode, year, quarter);
        result.put("detail", detail);
        return result;
    }

    @Override
    public JSONObject brandBuild(Integer year, Integer quarter, String unitCode, QueryFilter<BizEffectEffectiveness> queryFilter) {
        Assert.notNull((Object)unitCode, (String)"\u533a\u53bf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (quarter == null || quarter == 0) {
            quarter = LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        Org org = this.orgManager.getByCode(unitCode);
        Assert.notNull((Object)org, (String)"\u4f20\u5165\u7684\u7f16\u7801\u672a\u627e\u5230\u533a\u53bf\u6570\u636e\uff01");
        String unitId = org.getId();
        JSONObject result = new JSONObject();
        ArrayList<Integer> effectForm = new ArrayList<Integer>();
        effectForm.add(1);
        effectForm.add(2);
        effectForm.add(3);
        CountyBrandVo brandVo = this.brandReform(year, quarter, unitId, effectForm);
        result.put("count", brandVo.getChart());
        List<BizEffectEffectiveness> details = this.effectManager.brandDetails(unitId, year, quarter, queryFilter);
        result.put("details", details);
        return result;
    }

    @Override
    public PageList<BizReformPilotManagement> pilotLedgerDetailSec(QueryFilter<BizReformPilotManagement> queryFilter) {
        queryFilter.addFilter("m.STATUS_", (Object)5, QueryOP.EQUAL);
        queryFilter.addFilter("m.is_dele_", (Object)"0", QueryOP.EQUAL);
        PageList<BizReformPilotManagement> data = this.reformPilotManager.queryDetailForUnit(queryFilter);
        return data;
    }
}

