/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.statistics.dao.BizScoringProjectTargetDao;
import com.artfess.reform.statistics.manager.BizScoringProjectTargetManager;
import com.artfess.reform.statistics.model.BizScoringProjectTarget;
import com.artfess.reform.utils.CumputeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizScoringProjectTargetManagerImpl
extends BaseManagerImpl<BizScoringProjectTargetDao, BizScoringProjectTarget>
implements BizScoringProjectTargetManager {
    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional
    public List<BizScoringProjectTarget> countScore(LocalDate countDate) {
        LocalDate now = LocalDate.now();
        if (countDate == null) {
            countDate = now;
        }
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());
        List<BizScoringProjectTarget> list = ((BizScoringProjectTargetDao)this.baseMapper).statisticsNum(countDate.getYear());
        if (list != null && list.size() > 0) {
            ArrayList<BigDecimal> reachRateList = new ArrayList<BigDecimal>();
            for (BizScoringProjectTarget bizScoringProjectTarget : list) {
                bizScoringProjectTarget.setFillDate(countDate);
                bizScoringProjectTarget.setFillYear(countDate.getYear());
                bizScoringProjectTarget.setFillQuarter(BizScoringProjectTargetManagerImpl.getSeasonDay(countDate));
                bizScoringProjectTarget.setFillMonth(countDate.getMonthValue());
                bizScoringProjectTarget.setFillType(BizScoringProjectTargetManagerImpl.getFillType(countDate));
                reachRateList.add(bizScoringProjectTarget.getReachRate());
            }
            CumputeUtil util = new CumputeUtil(3);
            for (BizScoringProjectTarget target : list) {
                BigDecimal targetScore = util.cumpute3(reachRateList.toArray(new BigDecimal[reachRateList.size()]), target.getReachRate(), new BigDecimal(35), true);
                target.setTargetScore(targetScore);
            }
            ArrayList arrayList = new ArrayList();
            if (countDate.getMonthValue() != 1 && countDate.getDayOfMonth() == lastDay.getDayOfMonth()) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"TARGET_SN_", (Object)1);
                queryWrapper.eq((Object)"FILL_YEAR_", (Object)countDate.getYear());
                queryWrapper.eq((Object)"FILL_MONTH_", (Object)(countDate.getMonthValue() - 1));
                queryWrapper.eq((Object)"FILL_TYPE_", (Object)"M");
                List list2 = ((BizScoringProjectTargetDao)this.baseMapper).selectList((Wrapper)queryWrapper);
            }
            list = list.stream().sorted((s1, s2) -> -s1.getTargetScore().compareTo(s2.getTargetScore())).collect(Collectors.toList());
            List snlist = list.stream().collect(Collectors.groupingBy(BizScoringProjectTarget::getTargetScore)).entrySet().stream().sorted((s1, s2) -> -((BigDecimal)s1.getKey()).compareTo((BigDecimal)s2.getKey())).collect(Collectors.toList());
            Integer index = 1;
            for (Map.Entry entry : snlist) {
                block3: for (BizScoringProjectTarget target : (List)entry.getValue()) {
                    void var7_11;
                    target.setTargetSn(index);
                    if (lastDay.getDayOfMonth() != countDate.getDayOfMonth()) continue;
                    if ((var7_11 == null || var7_11.size() == 0) && index == 1) {
                        target.setHoldNum(0);
                        continue;
                    }
                    if (var7_11 == null || var7_11.size() <= 0 || index != 1) continue;
                    for (BizScoringProjectTarget NO1 : var7_11) {
                        if (NO1.getProjectId().equals(target.getProjectId())) {
                            target.setHoldNum(NO1.getHoldNum() + 1);
                            continue block3;
                        }
                        target.setHoldNum(0);
                    }
                }
                index = index + ((List)entry.getValue()).size();
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"FILL_DATE_", (Object)countDate);
            ((BizScoringProjectTargetDao)this.baseMapper).delete((Wrapper)queryWrapper);
            this.saveBatch(list);
        }
        return list;
    }

    public static String getFillType(LocalDate dateTime) {
        LocalDate lastDay;
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        if (day == (lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth())).getDayOfMonth()) {
            type = "M";
            if (month == 3 || month == 6 || month == 9 || month == 12) {
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue() + 2) / 3;
    }
}

