/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.statistics.dao.BizScoringProjectBrandDao;
import com.artfess.reform.statistics.manager.BizScoringProjectBrandManager;
import com.artfess.reform.statistics.model.BizScoringProjectBrand;
import com.artfess.reform.utils.CumputeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizScoringProjectBrandManagerImpl
extends BaseManagerImpl<BizScoringProjectBrandDao, BizScoringProjectBrand>
implements BizScoringProjectBrandManager {
    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional
    public List<BizScoringProjectBrand> countScore(LocalDate countDate) {
        LocalDate now = LocalDate.now();
        if (countDate == null) {
            countDate = now;
        }
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());
        int fillYear = countDate.getYear();
        String completionDate = fillYear + "-01-01";
        List<BizScoringProjectBrand> list = ((BizScoringProjectBrandDao)this.baseMapper).statisticsBrandNum(fillYear, null, null, completionDate);
        if (list != null && list.size() > 0) {
            ArrayList<Integer> nationwideList = new ArrayList<Integer>();
            ArrayList<Integer> mediaList = new ArrayList<Integer>();
            for (BizScoringProjectBrand bizScoringProjectBrand : list) {
                bizScoringProjectBrand.setFillDate(countDate);
                bizScoringProjectBrand.setFillYear(countDate.getYear());
                bizScoringProjectBrand.setFillQuarter(BizScoringProjectBrandManagerImpl.getSeasonDay(countDate));
                bizScoringProjectBrand.setFillMonth(countDate.getMonthValue());
                bizScoringProjectBrand.setFillType(BizScoringProjectBrandManagerImpl.getFillType(countDate));
                nationwideList.add(bizScoringProjectBrand.getNationwideNum());
                mediaList.add(bizScoringProjectBrand.getMediaNum());
            }
            CumputeUtil util = new CumputeUtil(3);
            for (BizScoringProjectBrand brand : list) {
                BigDecimal nationwideScore = util.cumpute3(nationwideList.toArray(new BigDecimal[nationwideList.size()]), new BigDecimal(brand.getNationwideNum()), new BigDecimal(20));
                BigDecimal[] gerar3 = new BigDecimal[]{new BigDecimal("1"), new BigDecimal("0.9"), new BigDecimal("0.6")};
                BigDecimal mediaScore = util.cumpute3(mediaList.toArray(new BigDecimal[mediaList.size()]), new BigDecimal(brand.getMediaNum()), new BigDecimal(15), gerar3, true);
                BigDecimal brandScore = nationwideScore.add(mediaScore);
                brand.setNationwideScore(nationwideScore);
                brand.setMediaScore(mediaScore);
                brand.setBrandScore(brandScore);
            }
            ArrayList arrayList = new ArrayList();
            if (countDate.getMonthValue() != 1 && countDate.getDayOfMonth() == lastDay.getDayOfMonth()) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"BRAND_ALL_SN_", (Object)1);
                queryWrapper.eq((Object)"FILL_YEAR_", (Object)countDate.getYear());
                queryWrapper.eq((Object)"FILL_MONTH_", (Object)(countDate.getMonthValue() - 1));
                queryWrapper.eq((Object)"FILL_TYPE_", (Object)"M");
                List list2 = ((BizScoringProjectBrandDao)this.baseMapper).selectList((Wrapper)queryWrapper);
            }
            list = list.stream().sorted((s1, s2) -> -s1.getBrandScore().compareTo(s2.getBrandScore())).collect(Collectors.toList());
            List snlist = list.stream().collect(Collectors.groupingBy(BizScoringProjectBrand::getBrandScore)).entrySet().stream().sorted((s1, s2) -> -((BigDecimal)s1.getKey()).compareTo((BigDecimal)s2.getKey())).collect(Collectors.toList());
            Integer index = 1;
            for (Map.Entry entry : snlist) {
                block3: for (BizScoringProjectBrand brand : (List)entry.getValue()) {
                    void var10_14;
                    brand.setBrandAllSn(index);
                    if (lastDay.getDayOfMonth() != countDate.getDayOfMonth()) continue;
                    if ((var10_14 == null || var10_14.size() == 0) && index == 1) {
                        brand.setHoldNum(0);
                        continue;
                    }
                    if (var10_14 == null || var10_14.size() <= 0 || index != 1) continue;
                    for (BizScoringProjectBrand NO1 : var10_14) {
                        if (NO1.getProjectId().equals(brand.getProjectId())) {
                            brand.setHoldNum(NO1.getHoldNum() + 1);
                            continue block3;
                        }
                        brand.setHoldNum(0);
                    }
                }
                index = index + ((List)entry.getValue()).size();
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"FILL_DATE_", (Object)countDate);
            ((BizScoringProjectBrandDao)this.baseMapper).delete((Wrapper)queryWrapper);
            this.saveBatch(list);
        }
        return list;
    }

    public static String getFillType(LocalDate dateTime) {
        LocalDate lastDay;
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        if (day == (lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth())).getDayOfMonth()) {
            type = "M";
            if (month == 3 || month == 6 || month == 9 || month == 12) {
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue() + 2) / 3;
    }
}

