/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.dao.BizReformRiskInvolvedDistrictsDao;
import com.artfess.reform.fill.dao.BizReformSatisfactionDistrictsDao;
import com.artfess.reform.fill.model.BizReformRiskInvolvedDistricts;
import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.reform.statistics.dao.BizScoringCountyBrandDao;
import com.artfess.reform.statistics.dao.BizScoringCountySynDao;
import com.artfess.reform.statistics.dao.BizScoringCountyWorkableDao;
import com.artfess.reform.statistics.manager.BizScoringCountySynManager;
import com.artfess.reform.statistics.model.BizScoringCountyBrand;
import com.artfess.reform.statistics.model.BizScoringCountySyn;
import com.artfess.reform.statistics.model.BizScoringCountyWorkable;
import com.artfess.reform.utils.CumputeUtil;
import com.artfess.uc.dao.OrgDao;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizScoringCountySynManagerImpl
extends BaseManagerImpl<BizScoringCountySynDao, BizScoringCountySyn>
implements BizScoringCountySynManager {
    @Resource
    private OrgDao orgDao;
    @Resource
    private BizReformSatisfactionDistrictsDao satisfacttDao;
    @Resource
    private BizReformRiskInvolvedDistrictsDao riskDao;
    @Resource
    private BizScoringCountyWorkableDao workableDao;
    @Resource
    private BizScoringCountyBrandDao brandDao;

    @Override
    @Transactional
    public List<BizScoringCountySyn> countScore(LocalDate countDate) {
        QueryWrapper queryWrapper;
        LocalDate now = LocalDate.now();
        if (countDate == null) {
            countDate = now;
        }
        LocalDate finalCountDate = countDate;
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());
        int quarter = Integer.valueOf(countDate.getMonthValue() + 2) / 3;
        List orgs = this.orgDao.groupOrg();
        List<BizReformSatisfactionDistricts> satisfactions = this.satisfacttDao.countSatisfactForOrg();
        List<BizReformRiskInvolvedDistricts> risks = this.riskDao.countRiskForOrg(countDate.getYear(), quarter, 1);
        List<BizScoringCountyBrand> brands = this.brandDao.queryLatest(countDate.getYear(), quarter, null, null);
        List<BizScoringCountyWorkable> workables = this.workableDao.queryLatest(countDate.getYear(), quarter, null, null);
        List<Object> dataList = new ArrayList();
        ArrayList finalDataList = dataList;
        orgs.forEach(o -> {
            BizScoringCountySyn d = new BizScoringCountySyn();
            d.setUnitCode(o.getCode());
            d.setUnitName(o.getName());
            d.setUnitGrade(Integer.valueOf(o.getGrade()));
            d.setFillDate(finalCountDate);
            d.setFillYear(finalCountDate.getYear());
            d.setFillQuarter(BizScoringCountySynManagerImpl.getSeasonDay(finalCountDate));
            d.setFillMonth(finalCountDate.getMonthValue());
            d.setFillType(BizScoringCountySynManagerImpl.getFillType(finalCountDate));
            satisfactions.forEach(s -> {
                if (s.getUnitCode().equals(d.getUnitCode())) {
                    d.setSatisfied(s.getSatisfaction());
                    d.setSatisfiedAllSn(s.getAllSn() == null ? null : Integer.valueOf(s.getAllSn().intValue()));
                    d.setSatisfiedRegionSn(s.getRegionSn() == null ? null : Integer.valueOf(s.getRegionSn().intValue()));
                    d.setSatisfiedHoldNum(s.getHoldNum() == null ? null : s.getHoldNum());
                    if (s.getAllSn() <= 9.0) {
                        d.setSatisfiedGrade("A");
                    } else if (17.0 >= s.getAllSn() && s.getAllSn() > 9.0) {
                        d.setSatisfiedGrade("B");
                    } else if (25.0 >= s.getAllSn() && s.getAllSn() > 17.0) {
                        d.setSatisfiedGrade("C");
                    } else if (33.0 >= s.getAllSn() && s.getAllSn() > 25.0) {
                        d.setSatisfiedGrade("D");
                    } else if (s.getAllSn() > 33.0) {
                        d.setSatisfiedGrade("E");
                    }
                }
            });
            brands.forEach(b -> {
                if (b.getUnitCode().equals(d.getUnitCode()) && b.getFillDate().isEqual(d.getFillDate())) {
                    d.setScore(d.getScore().add(b.getBrandScore()));
                }
            });
            workables.forEach(w -> {
                if (w.getUnitCode().equals(d.getUnitCode()) && w.getFillDate().isEqual(d.getFillDate())) {
                    d.setScore(d.getScore().add(w.getWorkableScore()));
                }
            });
            risks.forEach(r -> {
                if (r.getUnitCode().equals(d.getUnitCode()) && r.getRiskQuarter().equals(d.getFillQuarter())) {
                    d.setOpinionNum(d.getOpinionNum() + 1);
                    if (r.getRiskTpye() == 1) {
                        if (r.getRiskLevel() == 1) {
                            d.setOpinionDeScore(d.getOpinionDeScore().add(new BigDecimal(1)));
                        }
                        if (r.getRiskLevel() == 2) {
                            d.setOpinionDeScore(d.getOpinionDeScore().add(new BigDecimal(3)));
                        }
                        if (r.getRiskLevel() == 3) {
                            d.setOpinionDeScore(d.getOpinionDeScore().add(new BigDecimal(5)));
                        }
                    }
                    if (r.getRiskTpye() == 2) {
                        if (r.getRiskLevel() == 1) {
                            d.setOpinionDeScore(d.getOpinionDeScore().add(new BigDecimal(3)));
                        }
                        if (r.getRiskLevel() == 2) {
                            d.setOpinionDeScore(d.getOpinionDeScore().add(new BigDecimal(5)));
                        }
                        if (r.getRiskLevel() == 3) {
                            d.setOpinionDeScore(d.getOpinionDeScore().add(new BigDecimal(10)));
                        }
                    }
                }
            });
            if (new BigDecimal(15).subtract(d.getOpinionDeScore()).compareTo(new BigDecimal(0)) == -1) {
                d.setOpinionScore(new BigDecimal(0));
            } else {
                d.setOpinionScore(new BigDecimal(15).subtract(d.getOpinionDeScore()));
            }
            finalDataList.add(d);
        });
        BigDecimal[] satisCount = (BigDecimal[])dataList.stream().map(BizScoringCountySyn::getSatisfied).toArray(BigDecimal[]::new);
        dataList.forEach(d -> {
            d.setSatisfiedScore(new CumputeUtil(2).cumpute3(satisCount, d.getSatisfied(), new BigDecimal(20), false).setScale(4, 4));
            d.setScore(d.getScore().add(d.getSatisfiedScore().add(d.getOpinionScore()).setScale(2, 4)));
        });
        List NO1List = new ArrayList();
        int month = countDate.getMonthValue();
        if ((month == 6 || month == 9 || month == 12) && countDate.getDayOfMonth() == lastDay.getDayOfMonth()) {
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"ALL_SN_", (Object)1);
            queryWrapper.eq((Object)"FILL_YEAR_", (Object)countDate.getYear());
            queryWrapper.eq((Object)"FILL_QUARTER_", (Object)(BizScoringCountySynManagerImpl.getSeasonDay(countDate) - 1));
            queryWrapper.eq((Object)"FILL_TYPE_", (Object)"Q");
            NO1List = this.list((Wrapper)queryWrapper);
        }
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"FILL_YEAR_", (Object)countDate.getYear());
        queryWrapper.eq((Object)"FILL_QUARTER_", (Object)(BizScoringCountySynManagerImpl.getSeasonDay(countDate) - 1));
        queryWrapper.eq((Object)"FILL_TYPE_", (Object)"Q");
        List holdList = this.list((Wrapper)queryWrapper);
        HashMap snmap = new HashMap();
        if (holdList != null && holdList.size() > 0) {
            holdList.forEach(hold -> {
                if (hold.getHoldNum() != null) {
                    snmap.put(hold.getUnitCode(), hold.getHoldNum());
                }
            });
        }
        dataList = dataList.stream().sorted((s1, s2) -> -s1.getScore().compareTo(s2.getScore())).collect(Collectors.toList());
        List snList = dataList.stream().collect(Collectors.groupingBy(BizScoringCountySyn::getScore)).entrySet().stream().sorted((s1, s2) -> -((BigDecimal)s1.getKey()).compareTo((BigDecimal)s2.getKey())).collect(Collectors.toList());
        Integer index = 1;
        for (Map.Entry entry : snList) {
            block1: for (BizScoringCountySyn syn : (List)entry.getValue()) {
                syn.setAllSn(index);
                if ((month == 3 || month == 6 || month == 9 || month == 12) && lastDay.getDayOfMonth() == countDate.getDayOfMonth()) {
                    if ((NO1List == null || NO1List.size() == 0) && index == 1) {
                        syn.setHoldNum(0);
                        continue;
                    }
                    if (NO1List == null || NO1List.size() <= 0 || index != 1) continue;
                    for (BizScoringCountySyn NO1 : NO1List) {
                        if (NO1.getUnitCode().equals(syn.getUnitCode())) {
                            syn.setHoldNum(NO1.getHoldNum() + 1);
                            continue block1;
                        }
                        syn.setHoldNum(0);
                    }
                    continue;
                }
                if (snmap.isEmpty()) continue;
                syn.setHoldNum((Integer)snmap.get(syn.getUnitCode()));
            }
            index = index + ((List)entry.getValue()).size();
        }
        dataList = dataList.stream().sorted((s1, s2) -> -s1.getOpinionScore().compareTo(s2.getOpinionScore())).collect(Collectors.toList());
        List opList = dataList.stream().collect(Collectors.groupingBy(BizScoringCountySyn::getOpinionScore)).entrySet().stream().sorted((s1, s2) -> -((BigDecimal)s1.getKey()).compareTo((BigDecimal)s2.getKey())).collect(Collectors.toList());
        Integer opIndex = 1;
        for (Map.Entry entry : opList) {
            for (BizScoringCountySyn syn : (List)entry.getValue()) {
                syn.setOpinionAllSn(opIndex);
            }
            opIndex = opIndex + ((List)entry.getValue()).size();
        }
        QueryWrapper delWrapper = new QueryWrapper();
        delWrapper.eq((Object)"FILL_DATE_", (Object)countDate);
        ((BizScoringCountySynDao)this.baseMapper).delete((Wrapper)delWrapper);
        this.saveBatch(dataList);
        return dataList;
    }

    public static String getFillType(LocalDate dateTime) {
        LocalDate lastDay;
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        if (day == (lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth())).getDayOfMonth()) {
            type = "M";
            if (month == 3 || month == 6 || month == 9 || month == 12) {
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue() + 2) / 3;
    }
}

