/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.statistics.dao.BizScoringCountyBrandDao;
import com.artfess.reform.statistics.manager.BizScoringCountyBrandManager;
import com.artfess.reform.statistics.model.BizScoringCountyBrand;
import com.artfess.reform.utils.CumputeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizScoringCountyBrandManagerImpl
extends BaseManagerImpl<BizScoringCountyBrandDao, BizScoringCountyBrand>
implements BizScoringCountyBrandManager {
    @Override
    @Transactional
    public List<BizScoringCountyBrand> countScore(LocalDate countDate) {
        LocalDate now = LocalDate.now();
        if (countDate == null) {
            countDate = now;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, countDate.getYear());
        Date currYearFirst = calendar.getTime();
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());
        List<BizScoringCountyBrand> data = ((BizScoringCountyBrandDao)this.baseMapper).countEffrctive(currYearFirst, countDate);
        if (data != null && data.size() > 0) {
            QueryWrapper queryWrapper;
            for (BizScoringCountyBrand brand : data) {
                brand.setFillDate(countDate);
                brand.setFillYear(countDate.getYear());
                brand.setFillQuarter(BizScoringCountyBrandManagerImpl.getSeasonDay(countDate));
                brand.setFillMonth(countDate.getMonthValue());
                brand.setFillType(BizScoringCountyBrandManagerImpl.getFillType(countDate));
                if (brand.getNationwideSn() <= 9) {
                    brand.setNationwideGrade("A");
                } else if (17 >= brand.getNationwideSn() && brand.getNationwideSn() > 9) {
                    brand.setNationwideGrade("B");
                } else if (25 >= brand.getNationwideSn() && brand.getNationwideSn() > 17) {
                    brand.setNationwideGrade("C");
                } else if (33 >= brand.getNationwideSn() && brand.getNationwideSn() > 25) {
                    brand.setNationwideGrade("D");
                } else if (brand.getNationwideSn() > 33) {
                    brand.setNationwideGrade("E");
                }
                if (brand.getCitySn() <= 9) {
                    brand.setCityGrade("A");
                } else if (17 >= brand.getCitySn() && brand.getCitySn() > 9) {
                    brand.setCityGrade("B");
                } else if (25 >= brand.getCitySn() && brand.getCitySn() > 17) {
                    brand.setCityGrade("C");
                } else if (33 >= brand.getCitySn() && brand.getCitySn() > 25) {
                    brand.setCityGrade("D");
                } else if (brand.getCitySn() > 33) {
                    brand.setCityGrade("E");
                }
                if (brand.getMediaSn() <= 9) {
                    brand.setMediaGrade("A");
                    continue;
                }
                if (17 >= brand.getMediaSn() && brand.getMediaSn() > 9) {
                    brand.setMediaGrade("B");
                    continue;
                }
                if (25 >= brand.getMediaSn() && brand.getMediaSn() > 17) {
                    brand.setMediaGrade("C");
                    continue;
                }
                if (33 >= brand.getMediaSn() && brand.getMediaSn() > 25) {
                    brand.setMediaGrade("D");
                    continue;
                }
                if (brand.getMediaSn() <= 33) continue;
                brand.setMediaGrade("E");
            }
            BigDecimal[] nationCount = (BigDecimal[])data.stream().map(BizScoringCountyBrand::getNationwideNum).map(BigDecimal::new).toArray(BigDecimal[]::new);
            BigDecimal[] cityCount = (BigDecimal[])data.stream().map(BizScoringCountyBrand::getCityNum).map(BigDecimal::new).toArray(BigDecimal[]::new);
            BigDecimal[] mediaCount = (BigDecimal[])data.stream().map(BizScoringCountyBrand::getMediaNum).map(BigDecimal::new).toArray(BigDecimal[]::new);
            data.forEach(d -> {
                d.setNationwideScore(new CumputeUtil().cumpute3(nationCount, new BigDecimal(d.getNationwideNum()), new BigDecimal(20), false));
                d.setCityScore(new CumputeUtil().cumpute3(cityCount, new BigDecimal(d.getCityNum()), new BigDecimal(10), false));
                BigDecimal[] mediaCoefficient = new BigDecimal[]{new BigDecimal(1.0), new BigDecimal(0.8), new BigDecimal(0.6)};
                d.setMediaScore(new CumputeUtil(mediaCoefficient, 2).cumpute3(mediaCount, new BigDecimal(d.getMediaNum()), new BigDecimal(10), false));
                d.setBrandScore(d.getNationwideScore().add(d.getCityScore().add(d.getMediaScore()).setScale(2, 4)));
            });
            List NO1List = new ArrayList();
            int month = countDate.getMonthValue();
            if ((month == 6 || month == 9 || month == 12) && countDate.getDayOfMonth() == lastDay.getDayOfMonth()) {
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"BRAND_ALL_SN_", (Object)1);
                queryWrapper.eq((Object)"FILL_YEAR_", (Object)countDate.getYear());
                queryWrapper.eq((Object)"FILL_QUARTER_", (Object)(BizScoringCountyBrandManagerImpl.getSeasonDay(countDate) - 1));
                queryWrapper.eq((Object)"FILL_TYPE_", (Object)"Q");
                NO1List = this.list((Wrapper)queryWrapper);
            }
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"FILL_YEAR_", (Object)countDate.getYear());
            queryWrapper.eq((Object)"FILL_QUARTER_", (Object)(BizScoringCountyBrandManagerImpl.getSeasonDay(countDate) - 1));
            queryWrapper.eq((Object)"FILL_TYPE_", (Object)"Q");
            List holdList = this.list((Wrapper)queryWrapper);
            HashMap snmap = new HashMap();
            if (holdList != null && holdList.size() > 0) {
                holdList.forEach(hold -> {
                    if (hold.getHoldNum() != null) {
                        snmap.put(hold.getUnitCode(), hold.getHoldNum());
                    }
                });
            }
            data = data.stream().sorted((s1, s2) -> -s1.getBrandScore().compareTo(s2.getBrandScore())).collect(Collectors.toList());
            List snList = data.stream().collect(Collectors.groupingBy(BizScoringCountyBrand::getBrandScore)).entrySet().stream().sorted((s1, s2) -> -((BigDecimal)s1.getKey()).compareTo((BigDecimal)s2.getKey())).collect(Collectors.toList());
            Integer index = 1;
            for (Map.Entry entry : snList) {
                block2: for (BizScoringCountyBrand workable : (List)entry.getValue()) {
                    workable.setBrandAllSn(index);
                    if ((month == 3 || month == 6 || month == 9 || month == 12) && lastDay.getDayOfMonth() == countDate.getDayOfMonth()) {
                        if ((NO1List == null || NO1List.size() == 0) && index == 1) {
                            workable.setHoldNum(0);
                            continue;
                        }
                        if (NO1List == null || NO1List.size() <= 0 || index != 1) continue;
                        for (BizScoringCountyBrand NO1 : NO1List) {
                            if (NO1.getUnitCode().equals(workable.getUnitCode())) {
                                workable.setHoldNum(NO1.getHoldNum() + 1);
                                continue block2;
                            }
                            workable.setHoldNum(0);
                        }
                        continue;
                    }
                    if (snmap.isEmpty()) continue;
                    workable.setHoldNum((Integer)snmap.get(workable.getUnitCode()));
                }
                index = index + ((List)entry.getValue()).size();
            }
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.eq((Object)"FILL_DATE_", (Object)countDate);
            ((BizScoringCountyBrandDao)this.baseMapper).delete((Wrapper)delWrapper);
            this.saveBatch(data);
        }
        return data;
    }

    public static String getFillType(LocalDate dateTime) {
        LocalDate lastDay;
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        if (day == (lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth())).getDayOfMonth()) {
            type = "M";
            if (month == 3 || month == 6 || month == 9 || month == 12) {
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue() + 2) / 3;
    }
}

