/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.majorProjects.manager.PilotMeasuresPushManager;
import com.artfess.reform.majorProjects.model.PilotBrandPush;
import com.artfess.reform.majorProjects.model.PilotExperiencePush;
import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedule;
import com.artfess.reform.majorProjects.vo.PilotMeasuresPushVo;
import com.artfess.reform.majorProjects.vo.QuantitativeObjectivesVo;
import com.artfess.reform.statistics.manager.ProjectLargeScreeManager;
import com.artfess.reform.statistics.model.BizScoringProjectIteration;
import com.artfess.reform.statistics.vo.BrandLineChartVO;
import com.artfess.reform.statistics.vo.ComplianceRateVo;
import com.artfess.reform.statistics.vo.IterationVo;
import com.artfess.reform.statistics.vo.MonthPlanNumVO;
import com.artfess.reform.statistics.vo.OverViewComplianceStatusVo;
import com.artfess.reform.statistics.vo.OverviewComplianceVo;
import com.artfess.reform.statistics.vo.ScheduleVo;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u91cd\u5927\u9879\u76ee\u6539\u9769\u62a5\u8868\u5927\u5c4f\u63a5\u53e3"})
@RequestMapping(value={"/project/largeScreen/v1/"})
@ApiGroup(group={"group_biz"})
public class ProjectLargeScreeController {
    private static final Logger log = LoggerFactory.getLogger(ProjectLargeScreeController.class);
    @Resource
    private ProjectLargeScreeManager baseManager;
    @Resource
    private PilotMeasuresPushManager measuresPushManager;
    @Autowired
    SysDictionaryDetailManager sysDictionaryDetailManager;

    @PostMapping(value={"/indexRank"})
    @ApiOperation(value="\u6307\u6570\u6392\u884c\u699c\u63a5\u53e3", notes="URI\u53c2\u6570type: composite \u7efc\u5408\u6392\u540d\u3001single \u5355\u9879")
    public CommonResult<String> indexRank(@RequestParam String type, @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        JSONArray data = this.baseManager.indexRank(type, year, month);
        return CommonResult.success((Object)data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/monthPlanNum"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9879\u76ee\u4f5c\u6218\u56fe\u7edf\u8ba1", httpMethod="POST", notes="\u9879\u76ee\u4f5c\u6218\u56fe\u7edf\u8ba1")
    public CommonResult<String> monthPlanNum(@RequestParam(required=false) String projectId, @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        JSONObject data = this.baseManager.monthPlanNum(projectId, year, month);
        return CommonResult.success((Object)data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/monthPlanNumForProject"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5404\u4e2a\u9879\u76ee\u4f5c\u6218\u56fe\u7edf\u8ba1", httpMethod="POST", notes="\u9879\u76ee\u4f5c\u6218\u56fe\u7edf\u8ba1")
    public CommonResult<String> monthPlanNumForProject(@RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        List<MonthPlanNumVO> list = this.baseManager.monthPlanNumForProject(year, month);
        return CommonResult.success(list, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/monthPlanNumDetails"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9879\u76ee\u4f5c\u6218\u56fe\u8be6\u60c5\u7edf\u8ba1", httpMethod="POST", notes="\u9879\u76ee\u4f5c\u6218\u56fe\u8be6\u60c5\u7edf\u8ba1")
    public CommonResult<String> monthPlanNumDetails(@RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month, @RequestParam(required=false) String projectId) {
        JSONObject data = this.baseManager.monthPlanNumDetails(year, month, projectId);
        return CommonResult.success((Object)data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/monthPlanPageList"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u9879\u76ee\u6708\u5ea6\u8ba1\u5212\u53ca\u63a8\u8fdb\u60c5\u51b5", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2\u9879\u76ee\u6708\u5ea6\u8ba1\u5212\u53ca\u63a8\u8fdb\u60c5\u51b5")
    public PageList<PilotMeasuresPushVo> monthPlanPageList(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<PilotMeasuresPush> queryFilter) {
        PageList<PilotMeasuresPushVo> pageList = this.measuresPushManager.queryList(queryFilter);
        return pageList;
    }

    @RequestMapping(value={"exportMonthPlanList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6708\u5ea6\u8ba1\u5212\u63a8\u8fdb\u5217\u8868", httpMethod="POST", notes="\u5bfc\u51fa\u6708\u5ea6\u8ba1\u5212\u63a8\u8fdb\u5217\u8868")
    public void exportList(HttpServletResponse response, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<PilotMeasuresPush> queryFilter) throws Exception {
        try {
            queryFilter.getPageBean().setPageSize(-1);
            PageList<PilotMeasuresPushVo> pageList = this.measuresPushManager.queryList(queryFilter);
            ArrayList<Map> list = new ArrayList<Map>();
            if (BeanUtils.isNotEmpty((Object)pageList.getRows())) {
                for (PilotMeasuresPushVo effect : pageList.getRows()) {
                    String jsonStr = JsonUtil.toJson((Object)((Object)effect));
                    Map map = JsonUtil.toMap((String)jsonStr);
                    if (map.get("projectType") != null) {
                        String projectType = map.get("projectType").toString();
                        String projectTypeText = this.sysDictionaryDetailManager.getTextByValue("xmlx", projectType);
                        map.put("projectTypeText", projectTypeText);
                    } else {
                        map.put("projectTypeText", "");
                    }
                    if (map.get("projectField") != null) {
                        String projectField = map.get("projectField").toString();
                        String projectFieldText = this.sysDictionaryDetailManager.getTextByValue("ggbb_ssly", projectField);
                        map.put("projectFieldText", projectFieldText);
                    } else {
                        map.put("projectFieldText", "");
                    }
                    if (map.get("projectRunway") != null) {
                        String projectRunway = map.get("projectRunway").toString();
                        String projectRunwayText = this.sysDictionaryDetailManager.getTextByValue("ggbb_sspd", projectRunway);
                        map.put("projectRunwayText", projectRunwayText);
                    } else {
                        map.put("projectRunwayText", "");
                    }
                    if (map.get("planYear") != null && map.get("planMonth") != null) {
                        String planYear = map.get("planYear").toString();
                        String planMonth = map.get("planMonth").toString();
                        String planMonthText = planYear + "-" + planMonth;
                        map.put("planMonthText", planMonthText);
                    } else {
                        map.put("planMonthText", "");
                    }
                    if (map.get("isOver") != null) {
                        String isOver = map.get("isOver").toString();
                        String isOverText = this.sysDictionaryDetailManager.getTextByValue("tjzt", isOver);
                        map.put("isOverText", isOverText);
                    } else {
                        map.put("isOverText", "");
                    }
                    if (map.get("planType") != null) {
                        String planType = map.get("planType").toString();
                        String planTypeText = this.sysDictionaryDetailManager.getTextByValue("yd_jhlx", planType);
                        map.put("planTypeText", planTypeText);
                    } else {
                        map.put("planTypeText", "");
                    }
                    list.add(map);
                }
            }
            String tempName = "\u91cd\u5927\u9879\u76ee\u6708\u5ea6\u8ba1\u5212\u63a8\u8fdb\u8868";
            LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("projectName", "\u9879\u76ee\u540d\u79f0");
            exportMaps.put("leader", "\u7275\u5934\u5e02\u9886\u5bfc");
            exportMaps.put("projectFieldText", "\u6240\u5c5e\u9886\u57df");
            exportMaps.put("projectRunwayText", "\u6240\u5c5e\u8dd1\u9053");
            exportMaps.put("unitName", "\u8d23\u4efb\u5355\u4f4d");
            exportMaps.put("projectTypeText", "\u9879\u76ee\u7c7b\u578b");
            exportMaps.put("planMonthText", "\u8ba1\u5212\u6708\u5ea6");
            exportMaps.put("planTypeText", "\u8ba1\u5212\u7c7b\u578b");
            exportMaps.put("isOverText", "\u63a8\u8fdb\u72b6\u6001");
            exportMaps.put("planContent", "\u8ba1\u5212\u5185\u5bb9");
            exportMaps.put("completedWork", "\u5df2\u5b8c\u6210\u5de5\u4f5c");
            exportMaps.put("problems", "\u5b58\u5728\u95ee\u9898");
            exportMaps.put("workPlan", "\u4e0b\u4e00\u6b65\u5de5\u4f5c\u8ba1\u5212");
            HSSFWorkbook book = ExcelUtil.exportTemplateExcel((String)tempName, exportMaps, list, (int)1, (String)"excel/monthPlanPush.xls");
            ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @PostMapping(value={"/targetNum"})
    @ApiOperation(value="\u91cf\u5316\u76ee\u6807")
    public CommonResult<String> targetNum(@RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        JSONObject data = this.baseManager.targetNum(year, month);
        return CommonResult.success((Object)data, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/demandHeatList"})
    @ApiOperation(value="\u9700\u6c42\u70ed\u529b\u699c", notes="month: \u6708\u5ea6")
    public JSONObject demandHeatList(@RequestParam(required=false) Integer year, @RequestParam Integer month) {
        Assert.isTrue((month >= 1 && month <= 12 ? 1 : 0) != 0, (String)"\u6708\u5ea6\u4f20\u9012\u9519\u8bef\uff0c\u5141\u8bb8\u503c\u30101~12\u3011");
        return this.baseManager.demandHeatList(year, month);
    }

    @PostMapping(value={"/demandDetailList"})
    @ApiOperation(value="\u6539\u9769\u9700\u6c42\u6e05\u5355")
    public JSONObject demandDetailList(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BizReformDemandAssignment> queryFilter) {
        return this.baseManager.demandDetailList(queryFilter);
    }

    @PostMapping(value={"/brandLineChart"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6309\u6708\u7edf\u8ba1\u54c1\u724c\u699c\u6570\u636e\uff08\u6298\u7ebf\u56fe\uff09")
    public List<BrandLineChartVO> brandLineChart(@RequestParam(required=false) String projectId, @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        List<BrandLineChartVO> list = this.baseManager.brandLineChart(projectId, year, month);
        return list;
    }

    @PostMapping(value={"/queryBrandForProject"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6309\u7167\u9879\u76ee\u7edf\u8ba1\u54c1\u724c\u699c\u6570\u636e")
    public List<BrandLineChartVO> queryBrandForProject(@RequestParam(required=false) String projectId, @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        List<BrandLineChartVO> list = this.baseManager.queryBrandForProject(projectId, year, month);
        return list;
    }

    @PostMapping(value={"/queryBrandForProjectInfo"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9879\u76ee\u54c1\u724c\u699c\u8be6\u60c5\u6570\u636e")
    public List<PilotBrandPush> queryBrandForProjectInfo(@RequestParam(required=false) String projectId, @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        List<PilotBrandPush> list = this.baseManager.queryBrandForProjectInfo(projectId, year, month);
        return list;
    }

    @PostMapping(value={"/queryIterationForProject"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6309\u7167\u9879\u76ee\u7edf\u8ba1\u8fed\u4ee3\u6b21\u6570\uff08\u8fed\u4ee3\u699c\uff09")
    public List<BizScoringProjectIteration> queryIterationForProject(@RequestParam(value="year", required=false) Integer year, @RequestParam(value="month", required=false) Integer month) {
        List<BizScoringProjectIteration> list = this.baseManager.queryIterationForProject(year, month);
        return list;
    }

    @PostMapping(value={"/queryIterationForProjectInfo"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6309\u7167\u9879\u76ee\u67e5\u8be2\u8fed\u4ee3\u6570\u636e")
    public IterationVo queryIterationForProjectInfo(@RequestParam(value="projectId") String projectId, @RequestParam(value="year", required=false) Integer year, @RequestParam(value="month", required=false) Integer month) {
        IterationVo entity = this.baseManager.queryIterationForProjectInfo(projectId, year, month);
        return entity;
    }

    @PostMapping(value={"/achievementCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6210\u679c\u699c\u6570\u91cf\u548c\u73af\u6bd4\u7edf\u8ba1")
    public ScheduleVo achievementCount(@RequestParam(required=false) String projectId, @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        return this.baseManager.achievementCount(projectId, year, month);
    }

    @PostMapping(value={"/achievementInfo"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6210\u679c\u699c\u67e5\u8be2")
    public PageList<PilotMeasuresPush> achievementInfo(@RequestBody QueryFilter<PilotMeasuresPush> queryFilter) {
        return this.baseManager.achievementInfo(queryFilter);
    }

    @PostMapping(value={"/achievementFindById/{id}"})
    @ApiOperation(value="\u6210\u679c\u699c\u67e5\u8be2\u8be6\u60c5")
    public PilotMeasuresPush achievementFindById(@PathVariable(value="id") String id) {
        PilotMeasuresPush entity = this.measuresPushManager.achievementFindById(id);
        return entity;
    }

    @PostMapping(value={"/complianceRateCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5927\u5c4f\u6307\u6807\u5e93\u8fbe\u6807\u7387\u67e5\u8be2")
    public ComplianceRateVo complianceRate(@RequestParam(required=false) String projectId, @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        return this.baseManager.complianceRateCount(projectId, year, month);
    }

    @PostMapping(value={"/overviewComplianceCount"})
    @ApiOperation(value="\u5927\u5c4f\u6307\u6807\u5e93\u5404\u9879\u76ee\u6838\u5fc3\u6307\u6807\u8fbe\u6807\u60c5\u51b5\u603b\u89c8")
    public OverViewComplianceStatusVo overviewCompliance(@RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        return this.baseManager.overviewComplianceStatusInfo(year, month);
    }

    @PostMapping(value={"/overviewComplianceInfo"})
    @ApiOperation(value="\u8fdb\u5165\u6307\u6807\u5e93\u67e5\u8be2")
    public OverviewComplianceVo overviewComplianceInfo(@RequestParam(required=false) String projectId, @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        return this.baseManager.overviewComplianceInfo(projectId, year, month);
    }

    @PostMapping(value={"/schedulePlanInfo"})
    @ApiOperation(value="\u5e02\u7ea7\u5927\u5c4f\u8fdb\u5165\u5404\u9879\u76ee\u5206\u9a7e\u9a76\u8231\u6708\u5ea6\u8ba1\u5212\u6e05\u5355\u67e5\u8be2")
    public List<PilotSpecificSchedule> schedulePlanInfo(@RequestParam(required=false) String projectId, @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        return this.baseManager.schedulePlanInfo(projectId, year, month);
    }

    @PostMapping(value={"/pilotExperiencePushInfo"})
    @ApiOperation(value="\u5e02\u7ea7\u5927\u5c4f\u8fdb\u5165\u5404\u9879\u76ee\u5206\u9a7e\u9a76\u8231\u7ecf\u9a8c\u63a8\u5e7f\u67e5\u8be2")
    public List<PilotExperiencePush> pilotExperiencePushInfo(@RequestParam(required=false) String projectId, @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        return this.baseManager.pilotExperiencePushInfo(projectId, year, month);
    }

    @PostMapping(value={"/quantitativeObjectivesInfo"})
    @ApiOperation(value="\u5e02\u7ea7\u5927\u5c4f\u8fdb\u5165\u5404\u9879\u76ee\u5206\u9a7e\u9a76\u8231\u91cf\u5316\u76ee\u6807\u67e5\u8be2")
    public List<QuantitativeObjectivesVo> quantitativeObjectivesInfo(@RequestParam(required=false) String projectId, @RequestParam(required=false) Integer year, @RequestParam(required=false) Integer month) {
        return this.baseManager.quantitativeObjectivesInfo(projectId, year, month);
    }
}

