/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.fill.vo.MeasureListVO;
import com.artfess.reform.fill.vo.MeasureNumVO;
import com.artfess.reform.fill.vo.MeasureTrendVO;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotMeasuresPushManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresManager;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.statistics.dao.BizScoringProjectSynDao;
import com.artfess.reform.statistics.manager.BizScoringProjectMeasureManager;
import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.artfess.reform.statistics.vo.ProjectSynScoreVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizScoringProjectMeasure/v1/"})
@ApiGroup(group={"group_biz"})
@Api(tags={"\u9879\u76ee\u5177\u4f53\u63aa\u65bd\u63a8\u8fdb\u529b\u8bc4\u5206\u7ed3\u679c"})
public class BizScoringProjectMeasureController
extends BaseController<BizScoringProjectMeasureManager, BizScoringProjectMeasure> {
    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;
    @Resource
    private PilotSpecificMeasuresManager pilotSpecificMeasuresManager;
    @Resource
    private PilotMeasuresPushManager pilotMeasuresPushManager;
    @Resource
    private BizScoringProjectSynDao bizScoringProjectSynDao;

    @GetMapping(value={"/getNumVo"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5b63\u5ea6\u8bc4\u6bd4")
    public MeasureNumVO getNumVo() {
        MeasureNumVO vo = new MeasureNumVO();
        QueryWrapper projectwrapper = new QueryWrapper();
        projectwrapper.eq((Object)"IS_DELE_", (Object)"0");
        projectwrapper.eq((Object)"CLOSING_", (Object)1);
        List projects = this.municipalMajorProjectManagementManager.list((Wrapper)projectwrapper);
        int allNum = 0;
        int finishNum = 0;
        for (MunicipalMajorProjectManagement project : projects) {
            QueryWrapper scheduleQueryWrapper = new QueryWrapper();
            scheduleQueryWrapper.eq((Object)"STATUS_", (Object)5);
            scheduleQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            scheduleQueryWrapper.eq((Object)"PROJECT_ID_", (Object)project.getId());
            List schedules = this.pilotSpecificMeasuresManager.list((Wrapper)scheduleQueryWrapper);
            allNum += schedules.size();
            QueryWrapper pushQueryWrapper = new QueryWrapper();
            pushQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            pushQueryWrapper.eq((Object)"PROJECT_ID_", (Object)project.getId());
            pushQueryWrapper.eq((Object)"IS_OVER_", (Object)1);
            List pushes = this.pilotMeasuresPushManager.list((Wrapper)pushQueryWrapper);
            finishNum += pushes.size();
        }
        vo.setNum(allNum);
        vo.setFinishNum(finishNum);
        if (allNum > 0 && finishNum > 0) {
            vo.setFinishRate(new BigDecimal(finishNum).divide(new BigDecimal(allNum), 2, 0));
        } else {
            vo.setFinishRate(BigDecimal.ZERO);
        }
        return vo;
    }

    public static int getSeasonDay(Date date) {
        int month;
        Calendar cal = Calendar.getInstance();
        if (null != date) {
            cal.setTime(date);
        }
        return (month = cal.get(2) + 1) % 3 == 0 ? month / 3 : month / 3 + 1;
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizScoringProjectMeasure> query(@RequestBody QueryFilter<BizScoringProjectMeasure> queryFilter) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.orderByDesc((Object)"FILL_DATE_");
        wrapper.last("limit 1");
        BizScoringProjectMeasure projects = (BizScoringProjectMeasure)((Object)((BizScoringProjectMeasureManager)this.baseService).getOne((Wrapper)wrapper));
        if (projects != null) {
            queryFilter.addFilter("FILL_DATE_", (Object)df.format(projects.getFillDate()), QueryOP.EQUAL);
        } else {
            Date date = new Date(System.currentTimeMillis());
            queryFilter.addFilter("FILL_DATE_", (Object)formatter.format(date), QueryOP.EQUAL);
        }
        return super.query(queryFilter);
    }

    @PostMapping(value={"/getTrend"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8d8b\u52bf\u5bf9\u6bd4")
    public MeasureTrendVO getTrend() {
        MeasureTrendVO vo = new MeasureTrendVO();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.orderByDesc((Object)"FILL_DATE_");
        wrapper.last("limit 1");
        BizScoringProjectMeasure projects = (BizScoringProjectMeasure)((Object)((BizScoringProjectMeasureManager)this.baseService).getOne((Wrapper)wrapper));
        QueryWrapper queryWrapper = new QueryWrapper();
        QueryWrapper oldWrapper = new QueryWrapper();
        LocalDate firstDay = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        oldWrapper.eq((Object)"FILL_DATE_", (Object)df.format(firstDay));
        if (projects != null) {
            queryWrapper.eq((Object)"FILL_DATE_", (Object)df.format(projects.getFillDate()));
        } else {
            queryWrapper.eq((Object)"FILL_DATE_", (Object)df.format(LocalDate.now()));
        }
        List oldlist = ((BizScoringProjectMeasureManager)this.baseService).list((Wrapper)oldWrapper);
        List list = ((BizScoringProjectMeasureManager)this.baseService).list((Wrapper)queryWrapper);
        int regimeNum = list.stream().mapToInt(BizScoringProjectMeasure::getActualRegimeNum).sum();
        int oldRegimeNum = oldlist.stream().mapToInt(BizScoringProjectMeasure::getActualRegimeNum).sum();
        vo.setRegimeNum(regimeNum);
        int appNum = list.stream().mapToInt(BizScoringProjectMeasure::getActualAppNum).sum();
        int oldAppNum = oldlist.stream().mapToInt(BizScoringProjectMeasure::getActualAppNum).sum();
        vo.setAppNum(appNum);
        int plafeormNum = list.stream().mapToInt(BizScoringProjectMeasure::getActualPlatformNum).sum();
        int oldPlafeormNum = oldlist.stream().mapToInt(BizScoringProjectMeasure::getActualPlatformNum).sum();
        vo.setPlatformNum(plafeormNum);
        if (regimeNum < oldRegimeNum) {
            vo.setRegimeTrend(2);
            vo.setRegimeTrendNum(oldRegimeNum - regimeNum);
        } else if (regimeNum > oldRegimeNum) {
            vo.setRegimeTrendNum(regimeNum - oldAppNum);
            vo.setRegimeTrend(1);
        } else {
            vo.setRegimeTrendNum(0);
            vo.setRegimeTrend(0);
        }
        if (appNum < oldAppNum) {
            vo.setAppTrendNum(oldAppNum - appNum);
            vo.setAppTrend(2);
        } else if (appNum > oldAppNum) {
            vo.setAppTrendNum(appNum - oldAppNum);
            vo.setAppTrend(1);
        } else {
            vo.setAppTrendNum(0);
            vo.setAppTrend(0);
        }
        if (plafeormNum < oldPlafeormNum) {
            vo.setPlatormTrendNum(oldPlafeormNum - plafeormNum);
            vo.setPlatormTrend(2);
        } else if (plafeormNum > oldPlafeormNum) {
            vo.setPlatormTrendNum(plafeormNum - oldPlafeormNum);
            vo.setPlatormTrend(1);
        } else {
            vo.setPlatormTrendNum(0);
            vo.setPlatormTrend(0);
        }
        return vo;
    }

    @PostMapping(value={"/getList"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u5404\u7c7b\u578b\u5206\u9875\u67e5\u8be2")
    public IPage<MeasureListVO> getList(@RequestBody QueryFilter<BizScoringProjectMeasure> queryFilter) {
        return ((BizScoringProjectMeasureManager)this.baseService).select4Cockpit(queryFilter);
    }

    @PostMapping(value={"/getLists"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d4b\u8bd5")
    public Map<String, ProjectSynScoreVo> getLists(@RequestParam(name="date", required=false) LocalDate date) {
        if (date == null) {
            date = LocalDate.now();
        }
        List<ProjectSynScoreVo> synList = this.bizScoringProjectSynDao.statisticsSynScore(date);
        Map<String, ProjectSynScoreVo> synScoreMap = synList.stream().collect(Collectors.toMap(ProjectSynScoreVo::getProjectId, ProjectSynScoreVo2 -> ProjectSynScoreVo2));
        return synScoreMap;
    }

    @GetMapping(value={"/testCountScore"})
    public List<BizScoringProjectMeasure> testCountScore(LocalDate countDate) {
        return ((BizScoringProjectMeasureManager)this.baseService).countScore(countDate);
    }
}

