/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.statistics.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.fill.vo.IterationAddVO;
import com.artfess.reform.fill.vo.IterationUpdateVO;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresHistoryManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresManager;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasures;
import com.artfess.reform.majorProjects.model.PilotSpecificMeasuresHistory;
import com.artfess.reform.statistics.manager.BizScoringProjectIterationManager;
import com.artfess.reform.statistics.model.BizScoringProjectIteration;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizScoringProjectIteration/v1/"})
@ApiGroup(group={"group_biz"})
@Api(tags={"\u9879\u76ee\u5177\u4f53\u4e3e\u63aa\u8fed\u4ee3\u7edf\u8ba1"})
public class BizScoringProjectIterationController
extends BaseController<BizScoringProjectIterationManager, BizScoringProjectIteration> {
    @Resource
    private PilotSpecificMeasuresHistoryManager pilotSpecificMeasuresHistoryManager;
    @Resource
    private PilotSpecificMeasuresManager pilotSpecificMeasuresManager;

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizScoringProjectIteration> query(@RequestBody QueryFilter<BizScoringProjectIteration> queryFilter) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        QueryWrapper wrapper = new QueryWrapper();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        wrapper.orderByDesc((Object)"FILL_DATE_");
        wrapper.last("limit 1");
        BizScoringProjectIteration projects = (BizScoringProjectIteration)((Object)((BizScoringProjectIterationManager)this.baseService).getOne((Wrapper)wrapper));
        if (projects != null) {
            queryFilter.addFilter("FILL_DATE_", (Object)df.format(projects.getFillDate()), QueryOP.EQUAL);
        } else {
            Date date = new Date(System.currentTimeMillis());
            queryFilter.addFilter("FILL_DATE_", (Object)formatter.format(date), QueryOP.EQUAL);
        }
        PageList result = super.query(queryFilter);
        List list = result.getRows();
        for (BizScoringProjectIteration iteration : list) {
            QueryWrapper historyQueryWrapper = new QueryWrapper();
            historyQueryWrapper.eq((Object)"PROJECT_ID_", (Object)iteration.getProjectId());
            historyQueryWrapper.eq((Object)"STATUS_", (Object)5);
            historyQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            historyQueryWrapper.eq((Object)"DISTRIBUTION_TYPE_", (Object)1);
            historyQueryWrapper.eq((Object)"ITERATION_", (Object)1);
            List histories = this.pilotSpecificMeasuresHistoryManager.list((Wrapper)historyQueryWrapper);
            ArrayList<IterationAddVO> addVOS = new ArrayList<IterationAddVO>();
            if (histories.size() > 0) {
                for (PilotSpecificMeasuresHistory add : histories) {
                    IterationAddVO addVO = new IterationAddVO();
                    addVO.setCause(add.getIterationAccording());
                    addVO.setName(add.getReformSpecificMeasures());
                    addVOS.add(addVO);
                }
            }
            iteration.setAddVOS(addVOS);
            QueryWrapper updateWrapper = new QueryWrapper();
            updateWrapper.eq((Object)"PROJECT_ID_", (Object)iteration.getProjectId());
            updateWrapper.eq((Object)"STATUS_", (Object)5);
            updateWrapper.eq((Object)"IS_DELE_", (Object)"0");
            updateWrapper.eq((Object)"DISTRIBUTION_TYPE_", (Object)1);
            updateWrapper.eq((Object)"ITERATION_", (Object)1);
            ArrayList<IterationUpdateVO> updateVOS = new ArrayList<IterationUpdateVO>();
            for (PilotSpecificMeasures measures : this.pilotSpecificMeasuresManager.list((Wrapper)updateWrapper)) {
                QueryWrapper updateHistory = new QueryWrapper();
                updateHistory.eq((Object)"PROJECT_ID_", (Object)iteration.getProjectId());
                updateHistory.eq((Object)"STATUS_", (Object)5);
                updateHistory.eq((Object)"IS_DELE_", (Object)0);
                updateHistory.eq((Object)"DISTRIBUTION_TYPE_", (Object)1);
                updateHistory.eq((Object)"ITERATION_", (Object)2);
                updateHistory.eq((Object)"SPECIFIC_MEASURES_ID_", (Object)measures.getId());
                updateHistory.orderByDesc((Object)"SN_");
                List updateList = this.pilotSpecificMeasuresHistoryManager.list((Wrapper)updateHistory);
                if (updateList.size() <= 0) continue;
                IterationUpdateVO updateVO = new IterationUpdateVO();
                PilotSpecificMeasuresHistory newUpdate = (PilotSpecificMeasuresHistory)((Object)updateList.get(0));
                PilotSpecificMeasuresHistory oldUpdate = (PilotSpecificMeasuresHistory)((Object)updateList.get(updateList.size() - 1));
                updateVO.setCause(newUpdate.getIterationAccording());
                updateVO.setNewName(newUpdate.getReformSpecificMeasures());
                updateVO.setOldName(oldUpdate.getReformSpecificMeasures());
                updateVOS.add(updateVO);
            }
            iteration.setUpdateVOS(updateVOS);
        }
        result.setRows(list);
        return result;
    }

    @GetMapping(value={"/testCountScore"})
    public List<BizScoringProjectIteration> testCountScore(LocalDate countDate) {
        return ((BizScoringProjectIterationManager)this.baseService).countScore(countDate);
    }
}

