/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.majorProjects.dao.PilotBrandPushDao;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotBrandPushManager;
import com.artfess.reform.majorProjects.manager.PilotProjectFillManager;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotBrandPush;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.vo.PilotProjectFillCreateVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizPilotBrandPushManagerImpl
extends BaseManagerImpl<PilotBrandPushDao, PilotBrandPush>
implements PilotBrandPushManager {
    @Resource
    private FileManager fileManager;
    @Resource
    private SysDictionaryManager sysDictionaryManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    private PilotProjectFillManager pilotProjectFillManager;
    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;
    @Resource
    private UniversalWayManager universalWayManager;

    @Override
    public List<PilotBrandPush> queryListByFillId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"FILL_ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)0);
        List list = this.list((Wrapper)queryWrapper);
        if (null != list && list.size() > 0) {
            list.stream().forEach(p -> p.setFiles(this.fileManager.queryFileByBizId(p.getId())));
        }
        return list;
    }

    @Override
    @Transactional
    public void insertInfo(PilotProjectFillCreateVo pilotProjectFillCreateVo) {
        Assert.notNull((Object)pilotProjectFillCreateVo, (String)"\u4fdd\u5b58\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        PilotProjectFill pilotProjectFill = pilotProjectFillCreateVo.getPilotProjectFill();
        Assert.notNull((Object)((Object)pilotProjectFill), (String)"\u586b\u62a5\u5ba1\u6838\u8bb0\u5f55\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)pilotProjectFill.getProjectId(), (String)"\u586b\u62a5\u5ba1\u6838\u8bb0\u5f55\u672a\u5173\u8054\u9879\u76ee\u3010projectId\u3011");
        LocalDate fillDate = LocalDate.now();
        int quarter = (fillDate.getMonthValue() - 1) / 3 + 1;
        pilotProjectFill.setFillDate(fillDate);
        pilotProjectFill.setFillYear(fillDate.getYear());
        pilotProjectFill.setFillMonth(fillDate.getMonthValue());
        pilotProjectFill.setFillQuarter(quarter);
        pilotProjectFill.setFlowType(4);
        pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
        pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
        pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
        pilotProjectFill.setUnitGrade(ContextUtil.getCurrentOrgGrade());
        this.pilotProjectFillManager.save((Object)pilotProjectFill);
        this.setApprovalLog(pilotProjectFill.getId(), pilotProjectFill.getApprovalResults(), pilotProjectFill.getStatus(), pilotProjectFill.getApprovalComments());
        pilotProjectFillCreateVo.getPilotBrandPushList().stream().forEach(p -> {
            p.setFillId(pilotProjectFill.getId());
            p.setProjectId(pilotProjectFill.getProjectId());
            p.setIsDelete("0");
            super.save((Object)p);
            if (BeanUtils.isNotEmpty(p.getIds())) {
                this.universalWayManager.attachmentUpdates(p.getIds(), p.getId());
            }
        });
    }

    @Override
    @Transactional
    public void updateInfo(PilotProjectFillCreateVo pilotProjectFillCreateVo) {
        LocalDate fillDate = LocalDate.now();
        int quarter = (fillDate.getMonthValue() - 1) / 3 + 1;
        PilotProjectFill pilotProjectFill = pilotProjectFillCreateVo.getPilotProjectFill();
        PilotProjectFill entity = (PilotProjectFill)((Object)this.pilotProjectFillManager.getById((Serializable)((Object)pilotProjectFillCreateVo.getPilotProjectFill().getId())));
        if (pilotProjectFill.getStatus() == 1 && entity.getStatus() == 0) {
            this.setApprovalLog(pilotProjectFill.getId(), pilotProjectFill.getApprovalResults(), pilotProjectFill.getStatus(), pilotProjectFill.getApprovalComments());
        }
        this.pilotProjectFillManager.update((Wrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"ID_", (Object)pilotProjectFill.getId())).eq((Object)"FLOW_TYPE_", (Object)4)).set((Object)"STATUS_", (Object)pilotProjectFill.getStatus())).set((Object)"FILL_DATE_", (Object)fillDate)).set((Object)"FILL_YEAR_", (Object)fillDate.getYear())).set((Object)"FILL_QUARTER_", (Object)quarter)).set((Object)"FILL_MONTH_", (Object)fillDate.getMonthValue()));
        List ids = pilotProjectFillCreateVo.getPilotBrandPushList().stream().map(PilotBrandPush::getId).collect(Collectors.toList());
        super.remove((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FILL_ID_", (Object)pilotProjectFill.getId())).notIn((Object)"ID_", ids)).eq((Object)"IS_DELE_", (Object)"0"));
        pilotProjectFillCreateVo.getPilotBrandPushList().stream().forEach(p -> {
            p.setFillId(pilotProjectFill.getId());
            p.setProjectId(pilotProjectFill.getProjectId());
            super.saveOrUpdate((Object)p);
            if (BeanUtils.isNotEmpty(p.getIds())) {
                this.universalWayManager.attachmentUpdates(p.getIds(), p.getId());
            }
        });
    }

    @Override
    public List<PilotProjectFill> findByHis(String projectId) {
        List list = this.pilotProjectFillManager.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)projectId)).eq((Object)"FLOW_TYPE_", (Object)4)).orderByDesc((Object)"CREATE_TIME_")).last("limit 2"));
        list.stream().forEach(p -> {
            AchieveStatusLog log;
            List models = super.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FILL_ID_", (Object)p.getId())).eq((Object)"IS_DELE_", (Object)"0"));
            models.stream().forEach(t -> {
                List files = this.fileManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BIZ_ID_", (Object)t.getId())).eq((Object)"IS_DEL_", (Object)"0"));
                if (BeanUtils.isNotEmpty((Object)files)) {
                    t.setFiles(files);
                }
            });
            p.setPilotBrandPushList(models);
            if (BeanUtils.isNotEmpty((Object)p) && BeanUtils.isNotEmpty((Object)((Object)(log = (AchieveStatusLog)((Object)((Object)this.achieveStatusLogManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BIZ_ID_", (Object)p.getId())).orderByDesc((Object)"OPERATE_DATE_")).last("LIMIT 1"))))))) && p.getStatus() != 0 && p.getStatus() != 1 && p.getStatus() != 3 && p.getStatus() != 5) {
                p.setApprovalComments(log.getApprovalComments());
            }
        });
        return list;
    }

    @Override
    @Transactional
    public boolean updateByStatus(PilotProjectFill pilotProjectFill) {
        boolean res = this.pilotProjectFillManager.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"ID_", (Object)pilotProjectFill.getId())).eq((Object)"FLOW_TYPE_", (Object)4)).set((Object)"STATUS_", (Object)pilotProjectFill.getStatus()));
        this.setApprovalLog(pilotProjectFill.getId(), pilotProjectFill.getApprovalResults(), pilotProjectFill.getStatus(), pilotProjectFill.getApprovalComments());
        return res;
    }

    private void setApprovalLog(String id, Integer approvalResults, Integer status, String approvalComments) {
        PilotProjectFill model = (PilotProjectFill)((Object)this.pilotProjectFillManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)"0")));
        MunicipalMajorProjectManagement manager = (MunicipalMajorProjectManagement)((Object)this.municipalMajorProjectManagementManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)model.getProjectId())).eq((Object)"IS_DELE_", (Object)"0")));
        List shzt = this.sysDictionaryManager.queryDictListItemsByCode("shzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("6-4");
        logVo.setModuleTableName("BIZ_PILOT_PROJECT_FILL");
        if (BeanUtils.isNotEmpty((Object)approvalResults) && approvalResults == 2) {
            if (status == 0) {
                logVo.setItemTitle("\u3010" + manager.getProjectName() + "\u3011\u64a4\u56de\u4e3a\u8349\u7a3f\u72b6\u6001");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u8349\u7a3f");
            } else if (status == 1) {
                logVo.setItemTitle("\u3010" + manager.getProjectName() + "\u3011\u64a4\u56de\u4e3a\u63d0\u4ea4\u5f85\u5ba1\u6838");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u63d0\u4ea4\u5f85\u5ba1\u6838");
            } else if (status == 3) {
                logVo.setItemTitle("\u3010" + manager.getProjectName() + "\u3011\u64a4\u56de\u4e3a\u8d23\u4efb\u5355\u4f4d\u9886\u5bfc\u5ba1\u6838\u901a\u8fc7");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u8d23\u4efb\u5355\u4f4d\u9886\u5bfc\u5ba1\u6838\u901a\u8fc7");
            }
            logVo.setApprovalResults(2);
        } else {
            if (status % 2 == 0) {
                logVo.setApprovalResults(1);
            } else {
                logVo.setApprovalResults(0);
            }
            if (status == 0) {
                logVo.setItemTitle("\u3010" + manager.getProjectName() + "\u3011\u54c1\u724c\u663e\u793a\u5ea6\u5f55\u5165");
            } else {
                logVo.setItemTitle("\u3010" + manager.getProjectName() + "\u3011" + BizUtils.getDicValueByCode((List<DictModel>)shzt, status));
            }
            logVo.setOperateInfo(BizUtils.getDicValueByCode((List<DictModel>)shzt, status));
        }
        logVo.setStatus(status.toString());
        if (status == 2 || status == 4) {
            logVo.setApprovalComments(approvalComments);
        }
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        this.achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }
}

