/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizPilotAdvanceRecordDao;
import com.artfess.reform.fill.dao.BizReformPilotManagementDao;
import com.artfess.reform.fill.dto.MentDTO;
import com.artfess.reform.fill.manager.BizPilotAdvanceRecordManager;
import com.artfess.reform.fill.manager.BizPilotAdvanceResultManager;
import com.artfess.reform.fill.manager.BizReformInvolvedDistrictsManager;
import com.artfess.reform.fill.manager.BizReformPilotManagementManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizPilotAdvanceRecord;
import com.artfess.reform.fill.model.BizReformInvolvedDistricts;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.artfess.reform.fill.vo.InvVO;
import com.artfess.reform.fill.vo.StateVO;
import com.artfess.reform.statistics.vo.CountyChartVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizReformPilotManagementManagerImpl
extends BaseManagerImpl<BizReformPilotManagementDao, BizReformPilotManagement>
implements BizReformPilotManagementManager {
    @Resource
    private BizReformInvolvedDistrictsManager bizReformInvolvedDistrictsManager;
    @Resource
    BizPilotAdvanceRecordManager bizPilotAdvanceRecordManager;
    @Resource
    SysDictionaryManager sysDictionaryManager;
    @Resource
    AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    UniversalWayManager universalWayManager;
    @Resource
    BizPilotAdvanceResultManager bizPilotAdvanceResultManager;
    @Resource
    FileManager fileManager;
    @Resource
    SysDictionaryDetailManager sysDictionaryDetailManager;
    @Resource
    private BizReformInvolvedDistrictsManager reformInvolvedDistrictsManager;
    @Resource
    BizPilotAdvanceRecordDao bizPilotAdvanceRecordDao;

    @Override
    @Transactional
    public String insertInfo(BizReformPilotManagement bizReformPilotManagement) {
        String resDocName = bizReformPilotManagement.getDocName().replaceAll(" ", "");
        String docNo = resDocName + "\u3010" + bizReformPilotManagement.getDocYear() + "\u3011" + bizReformPilotManagement.getDocNum() + "\u53f7";
        if (BeanUtils.isEmpty((Object)bizReformPilotManagement.getUnitId())) {
            throw new BaseException("\u6240\u586b\u4e3b\u7ba1\u90e8\u95e8\u6682\u672a\u5f55\u5165\u6210\u529f,\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u6dfb\u52a0\uff01");
        }
        bizReformPilotManagement.setStatus(0);
        bizReformPilotManagement.setDocNo(docNo);
        bizReformPilotManagement.setIsDele("0");
        bizReformPilotManagement.setPropulsiveStatus(0);
        super.save((Object)bizReformPilotManagement);
        if (BeanUtils.isNotEmpty(bizReformPilotManagement.getIds())) {
            this.universalWayManager.attachmentUpdates(bizReformPilotManagement.getIds(), bizReformPilotManagement.getId());
        }
        for (BizReformInvolvedDistricts inv : bizReformPilotManagement.getInvs()) {
            inv.setPilotId(bizReformPilotManagement.getId());
            this.bizReformInvolvedDistrictsManager.save((Object)inv);
        }
        List collect = bizReformPilotManagement.getInvs().stream().map(BizReformInvolvedDistricts::getUnitId).collect(Collectors.toList());
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && !collect.contains(ContextUtil.getCurrentOrgId())) {
            BizReformInvolvedDistricts bizReform = new BizReformInvolvedDistricts();
            bizReform.setPilotId(bizReformPilotManagement.getId());
            bizReform.setUnitId(ContextUtil.getCurrentOrgId());
            bizReform.setUnitName(ContextUtil.getCurrentOrgName());
            bizReform.setUnitCode(ContextUtil.getCurrentOrgCode());
            bizReform.setUnitGrade(ContextUtil.getCurrentOrgGrade());
            bizReform.setTenantId("-1");
            this.bizReformInvolvedDistrictsManager.create((Model)bizReform);
        }
        this.setApprovalLog(bizReformPilotManagement.getId(), null, bizReformPilotManagement.getStatus(), null);
        return bizReformPilotManagement.getId();
    }

    @Override
    @Transactional
    public void updateInfo(BizReformPilotManagement bizReformPilotManagement) {
        boolean bothAudit = this.bothAudit(bizReformPilotManagement.getId(), bizReformPilotManagement.getStatus());
        if (!bothAudit) {
            throw new BaseException("\u8be5\u6570\u636e\u5df2\u88ab\u64a4\u56de,\u65e0\u6cd5\u5728\u8fdb\u884c\u64cd\u4f5c");
        }
        BizReformPilotManagement entity = (BizReformPilotManagement)((Object)super.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)bizReformPilotManagement.getId())).eq((Object)"IS_DELE_", (Object)"0")).last("LIMIT 1")));
        List districts = this.bizReformInvolvedDistrictsManager.list((Wrapper)new QueryWrapper().eq((Object)"PILOT_ID_", (Object)bizReformPilotManagement.getId()));
        if (bizReformPilotManagement.getInvs().size() > 0) {
            boolean containsInv = districts.containsAll(bizReformPilotManagement.getInvs());
            int recordCount = this.bizPilotAdvanceRecordManager.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PILOT_ID_", (Object)bizReformPilotManagement.getId())).eq((Object)"IS_DELE_", (Object)"0"));
            if (!containsInv && recordCount > 0) {
                bizReformPilotManagement.setPropulsiveStatus(2);
            }
        }
        boolean check = entity == null || entity.getStatus() != bizReformPilotManagement.getStatus();
        super.update((Model)bizReformPilotManagement);
        if (check) {
            this.setApprovalLog(bizReformPilotManagement.getId(), null, bizReformPilotManagement.getStatus(), bizReformPilotManagement.getApprovalComments());
        }
        if (BeanUtils.isNotEmpty(bizReformPilotManagement.getInvs())) {
            this.bizReformInvolvedDistrictsManager.remove((Wrapper)new QueryWrapper().eq((Object)"PILOT_ID_", (Object)bizReformPilotManagement.getId()));
            for (BizReformInvolvedDistricts inv : bizReformPilotManagement.getInvs()) {
                inv.setPilotId(bizReformPilotManagement.getId());
                this.bizReformInvolvedDistrictsManager.saveOrUpdate((Object)inv);
            }
            List collect = bizReformPilotManagement.getInvs().stream().map(BizReformInvolvedDistricts::getUnitId).collect(Collectors.toList());
            List records = this.bizPilotAdvanceRecordManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PILOT_ID_", (Object)bizReformPilotManagement.getId())).notIn((Object)"UNIT_ID_", collect));
            if (records.size() > 0 && null != records) {
                List delCollect = records.stream().map(BizPilotAdvanceRecord::getId).collect(Collectors.toList());
                this.bizPilotAdvanceResultManager.remove((Wrapper)new QueryWrapper().in((Object)"RECORD_ID_", delCollect));
                this.bizPilotAdvanceRecordManager.remove((Wrapper)new QueryWrapper().in((Object)"ID_", delCollect));
            }
        }
        if (bizReformPilotManagement.getInvs().size() > 0) {
            this.verify(bizReformPilotManagement.getId());
        }
        if (BeanUtils.isNotEmpty(bizReformPilotManagement.getIds())) {
            this.universalWayManager.attachmentUpdates(bizReformPilotManagement.getIds(), bizReformPilotManagement.getId());
        }
    }

    @Override
    @Transactional
    public void updateByStatus(StateVO stateVO) {
        Assert.notNull((Object)stateVO.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)stateVO.getStatus(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        boolean bothAudit = this.bothAudit(stateVO.getId(), stateVO.getStatus());
        if (!bothAudit) {
            throw new BaseException("\u8be5\u6570\u636e\u5df2\u88ab\u64a4\u56de,\u65e0\u6cd5\u5728\u8fdb\u884c\u64cd\u4f5c");
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"id_", (Object)stateVO.getId())).set((Object)"STATUS_", (Object)stateVO.getStatus());
        if (stateVO.getStatus() == 5) {
            updateWrapper.set((Object)"PROPULSIVE_STATUS_", (Object)1);
        }
        super.update((Wrapper)updateWrapper);
        this.setApprovalLog(stateVO.getId(), stateVO.getApprovalResults(), stateVO.getStatus(), stateVO.getApprovalComments());
    }

    @Override
    @Transactional
    public void removeInfo(String ids) {
        Assert.notNull((Object)ids, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (String id : ids.split(",")) {
            List mants = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)"0"));
            List mans = mants.stream().map(BizReformPilotManagement::getStatus).collect(Collectors.toList());
            if (mans.contains(2) || mans.contains(4) || mans.contains(1) || mans.contains(3) || mans.contains(5)) {
                throw new BaseException("\u65e0\u6cd5\u5220\u9664\u9664\u8349\u7a3f\u4ee5\u5916\u7684\u6570\u636e\uff01");
            }
            this.universalWayManager.deleteFiles(id);
            super.remove((Serializable)((Object)id));
        }
    }

    @Override
    public BizPilotAdvanceRecord findModel(String id) {
        BizPilotAdvanceRecord record = (BizPilotAdvanceRecord)((Object)this.bizPilotAdvanceRecordManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)"0")));
        List results = this.bizPilotAdvanceResultManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RECORD_ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)"0"));
        record.setResults(results);
        results.stream().forEach(p -> {
            List files = this.fileManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BIZ_ID_", (Object)p.getId())).eq((Object)"IS_DEL_", (Object)"0"));
            p.setFileList(files);
        });
        return record;
    }

    @Override
    public List<BizPilotAdvanceRecord> findByHis(String id, String unitId) {
        List res = this.bizPilotAdvanceRecordManager.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PILOT_ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)"0")).eq((Object)"UNIT_ID_", (Object)unitId)).orderByDesc((Object)"CREATE_TIME_")).last("LIMIT 2"));
        res.stream().forEach(p -> {
            List recFiles = this.fileManager.queryFileByBizId(p.getId());
            if (recFiles != null && recFiles.size() > 0) {
                p.setFileList(recFiles);
            }
            List results = this.bizPilotAdvanceResultManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RECORD_ID_", (Object)p.getId())).eq((Object)"IS_DELE_", (Object)"0"));
            results.stream().forEach(t -> {
                List files = this.fileManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BIZ_ID_", (Object)t.getId())).eq((Object)"IS_DEL_", (Object)"0"));
                t.setFileList(files);
            });
            p.setResults(results);
            AchieveStatusLog logCom = (AchieveStatusLog)((Object)((Object)this.achieveStatusLogManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BIZ_ID_", (Object)p.getId())).in((Object)"STATUS_", new Object[]{7, 9, 11})).orderByDesc((Object)"OPERATE_DATE_")).last("LIMIT 1"))));
            if (BeanUtils.isNotEmpty((Object)((Object)logCom))) {
                p.setApprovalComments(logCom.getApprovalComments());
            }
        });
        return res;
    }

    @Override
    public boolean ifExists(String docNo) {
        Assert.notNull((Object)docNo, (String)"docNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List res = super.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DOC_NO_", (Object)docNo)).eq((Object)"IS_DELE_", (Object)"0"));
        return null == res || res.size() <= 0;
    }

    @Override
    public PageList<BizReformPilotManagement> invQueryList(QueryFilter<BizReformPilotManagement> filter) {
        filter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && user != null) {
            filter.addFilter("CREATE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        IPage<BizReformPilotManagement> iPage = ((BizReformPilotManagementDao)this.baseMapper).pushQuery((IPage<BizReformPilotManagement>)this.convert2IPage(filter.getPageBean()), (Wrapper<BizReformPilotManagement>)this.convert2Wrapper(filter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public PageList<BizReformPilotManagement> disQueryList(QueryFilter<BizReformPilotManagement> filter) {
        filter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        filter.addFilter("STATUS_", (Object)0, QueryOP.NOT_EQUAL);
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && user != null) {
            filter.addFilter("CREATE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        IPage<BizReformPilotManagement> iPage = ((BizReformPilotManagementDao)this.baseMapper).pushQuery((IPage<BizReformPilotManagement>)this.convert2IPage(filter.getPageBean()), (Wrapper<BizReformPilotManagement>)this.convert2Wrapper(filter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public PageList<BizReformPilotManagement> pilQueryList(QueryFilter<BizReformPilotManagement> filter) {
        filter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        filter.addFilter("STATUS_", (Object)2, QueryOP.GREAT);
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && user != null) {
            filter.addFilter("UNIT_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        IPage<BizReformPilotManagement> iPage = ((BizReformPilotManagementDao)this.baseMapper).pushQuery((IPage<BizReformPilotManagement>)this.convert2IPage(filter.getPageBean()), (Wrapper<BizReformPilotManagement>)this.convert2Wrapper(filter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public BizReformPilotManagement findById(String id) {
        Assert.notNull((Object)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        BizReformPilotManagement pilot = (BizReformPilotManagement)((Object)((BizReformPilotManagementDao)this.baseMapper).selectById((Serializable)((Object)id)));
        pilot.setInvs(this.bizReformInvolvedDistrictsManager.list((Wrapper)new QueryWrapper().eq((Object)"PILOT_ID_", (Object)pilot.getId())));
        AchieveStatusLog log = (AchieveStatusLog)((Object)this.achieveStatusLogManager.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BIZ_ID_", (Object)pilot.getId())).orderByDesc((Object)"OPERATE_DATE_")).last("LIMIT 1")));
        if (BeanUtils.isNotEmpty((Object)((Object)log)) && (pilot.getStatus() == 0 || pilot.getStatus() == 2 || pilot.getStatus() == 4)) {
            pilot.setApprovalComments(log.getApprovalComments());
        }
        return pilot;
    }

    @Override
    public PageList<InvVO> invPush(MentDTO dto, boolean isAffirm) {
        PageBean pageBean = new PageBean();
        pageBean.setPage(dto.getPage().intValue());
        pageBean.setPageSize(dto.getSize().intValue());
        if (!ContextUtil.getCurrentUser().isAdmin() && ContextUtil.getCurrentUser() != null && !isAffirm) {
            dto.setUnitId(ContextUtil.getCurrentOrgId());
        }
        IPage<InvVO> iPage = ((BizReformPilotManagementDao)this.baseMapper).invPush((IPage<BizReformPilotManagement>)this.convert2IPage(pageBean), dto.getUnitId(), dto.getUnitName(), dto.getMainUnitName(), dto.getDocNo(), dto.getPilotProjectName(), dto.getPilotLevel(), dto.getStatus(), dto.getPilotField(), dto.getPilotRunway(), dto.getPilotSupervisor(), dto.getPropulsiveStatus());
        return new PageList(iPage);
    }

    @Override
    public PageList<InvVO> invAudit(MentDTO dto) {
        PageBean pageBean = new PageBean();
        pageBean.setPage(dto.getPage().intValue());
        pageBean.setPageSize(dto.getSize().intValue());
        if (!ContextUtil.getCurrentUser().isAdmin() && ContextUtil.getCurrentUser() != null) {
            dto.setUnitId(ContextUtil.getCurrentOrgId());
        }
        IPage<InvVO> iPage = ((BizReformPilotManagementDao)this.baseMapper).invAudit((IPage<BizReformPilotManagement>)this.convert2IPage(pageBean), dto.getUnitId(), dto.getUnitName(), dto.getMainUnitName(), dto.getDocNo(), dto.getPilotProjectName(), dto.getPilotLevel(), dto.getPilotSupervisor(), dto.getList(), dto.getStatus(), dto.getPilotField(), dto.getPilotRunway(), dto.getPropulsiveStatus());
        return new PageList(iPage);
    }

    @Override
    public PageList<InvVO> pilAudit(MentDTO dto) {
        PageBean pageBean = new PageBean();
        pageBean.setPage(dto.getPage().intValue());
        pageBean.setPageSize(dto.getSize().intValue());
        if (!ContextUtil.getCurrentUser().isAdmin() && ContextUtil.getCurrentUser() != null) {
            dto.setUnitId(ContextUtil.getCurrentOrgId());
        }
        IPage<InvVO> iPage = ((BizReformPilotManagementDao)this.baseMapper).pilAudit((IPage<BizReformPilotManagement>)this.convert2IPage(pageBean), dto.getUnitId(), dto.getUnitName(), dto.getMainUnitName(), dto.getDocNo(), dto.getPilotProjectName(), dto.getPilotLevel(), dto.getPilotSupervisor(), dto.getList(), dto.getStatus(), dto.getPilotField(), dto.getPilotRunway(), dto.getPropulsiveStatus());
        return new PageList(iPage);
    }

    @Override
    public PageList<InvVO> munAudit(MentDTO dto) {
        PageBean pageBean = new PageBean();
        pageBean.setPage(dto.getPage().intValue());
        pageBean.setPageSize(dto.getSize().intValue());
        pageBean.setShowTotal(true);
        dto.setUnitId(null);
        IPage<InvVO> iPage = ((BizReformPilotManagementDao)this.baseMapper).munAudit((IPage<BizReformPilotManagement>)this.convert2IPage(pageBean), dto.getUnitId(), dto.getUnitName(), dto.getMainUnitName(), dto.getDocNo(), dto.getPilotProjectName(), dto.getPilotLevel(), dto.getPilotSupervisor(), dto.getList(), dto.getStatus(), dto.getPilotField(), dto.getPilotRunway(), dto.getPropulsiveStatus());
        return new PageList(iPage);
    }

    @Override
    public PageList<BizReformPilotManagement> munInfo(QueryFilter<BizReformPilotManagement> queryFilter) {
        queryFilter.addFilter("m.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("m.STATUS_", (Object)5, QueryOP.EQUAL);
        IPage<BizReformPilotManagement> iPage = ((BizReformPilotManagementDao)this.baseMapper).munInfo((IPage<BizReformPilotManagement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizReformPilotManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public void pilotExport(HttpServletResponse response, MentDTO dto) throws Exception {
        ArrayList list = new ArrayList();
        PageBean pageBean = new PageBean();
        pageBean.setPage(dto.getPage().intValue());
        pageBean.setPageSize(dto.getSize().intValue());
        dto.setUnitId(null);
        List records = ((BizReformPilotManagementDao)this.baseMapper).excelInfo((IPage<BizReformPilotManagement>)this.convert2IPage(pageBean), dto.getUnitId(), dto.getUnitName(), dto.getMainUnitName(), dto.getDocNo(), dto.getPilotProjectName(), dto.getPilotLevel(), dto.getPilotSupervisor(), dto.getList(), dto.getStatus(), dto.getPilotField(), dto.getPilotRunway(), dto.getPropulsiveStatus()).getRecords();
        PageList models = new PageList(records);
        if (BeanUtils.isNotEmpty((Object)models.getRows())) {
            models.getRows().stream().forEach(p -> {
                try {
                    String jsonStr = JsonUtil.toJson((Object)p);
                    Map map = JsonUtil.toMap((String)jsonStr);
                    if (map.get("recordsStatus") != null) {
                        String recordsStatus = map.get("recordsStatus").toString();
                        String recordsStatusText = this.sysDictionaryDetailManager.getTextByValue("ggsd_shzt", recordsStatus);
                        map.put("recordsStatusText", recordsStatusText);
                    } else {
                        map.put("recordsStatusText", "");
                    }
                    if (map.get("pilotLevel") != null) {
                        String pilotLevel = map.get("pilotLevel").toString();
                        String pilotLevelText = this.sysDictionaryDetailManager.getTextByValue("sdcj", pilotLevel);
                        map.put("pilotLevelText", pilotLevelText);
                    } else {
                        map.put("pilotLevelText", "");
                    }
                    list.add(map);
                }
                catch (Exception e) {
                    throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
                }
            });
            String tempName = "\u6539\u9769\u8bd5\u70b9\u9879\u76ee";
            LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("pilotProjectName", "\u8bd5\u70b9\u9879\u76ee\u540d\u79f0");
            exportMaps.put("docNo", "\u8bd5\u70b9\u9879\u76ee\u6587\u53f7");
            exportMaps.put("pilotLevelText", "\u8bd5\u70b9\u5c42\u7ea7");
            exportMaps.put("mainUnitName", "\u5e02\u7ea7\u4e3b\u7ba1\u90e8\u95e8");
            exportMaps.put("unitName", "\u4e0a\u62a5\u533a\u53bf");
            exportMaps.put("auditTime", "\u63d0\u4ea4\u5ba1\u6838\u65f6\u95f4");
            exportMaps.put("recordsStatusText", "\u5ba1\u6838\u72b6\u6001");
            exportMaps.put("propulsiveDetails", "\u5df2\u5f00\u5c55\u5de5\u4f5c");
            exportMaps.put("existingProblems", "\u5b58\u5728\u95ee\u9898");
            exportMaps.put("workPlan", "\u4e0b\u4e00\u6b65\u5de5\u4f5c\u8ba1\u5212");
            HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
            ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
        }
    }

    @Override
    public void auditRemoveInfo(String ids) {
        String[] res;
        Assert.notNull((Object)ids, (String)"\u9700\u8981\u5220\u9664\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        for (String id : res = ids.split(",")) {
            this.universalWayManager.deleteFiles(id);
            this.bizPilotAdvanceResultManager.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PILOT_ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)"0"));
            this.bizPilotAdvanceRecordManager.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PILOT_ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)"0"));
            this.bizReformInvolvedDistrictsManager.remove((Wrapper)new QueryWrapper().eq((Object)"PILOT_ID_", (Object)id));
            super.removeById((Serializable)((Object)id));
        }
    }

    private void setApprovalLog(String bizId, Integer approvalResults, Integer status, String approvalComments) {
        BizReformPilotManagement model = (BizReformPilotManagement)((Object)this.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)bizId)).eq((Object)"IS_DELE_", (Object)"0")).last("LIMIT 1")));
        List glb_shzt = this.sysDictionaryManager.queryDictListItemsByCode("glb_shzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(bizId);
        logVo.setModeType(1);
        logVo.setModuleTableName("BIZ_REFORM_PILOT_MANAGEMENT");
        if (BeanUtils.isEmpty((Object)approvalResults)) {
            if (status % 2 == 0 && status != 0) {
                logVo.setApprovalResults(1);
            } else {
                logVo.setApprovalResults(0);
            }
            if (status == 0) {
                logVo.setItemTitle("\u3010" + model.getPilotProjectName() + "\u3011\u8bd5\u70b9\u9879\u76ee\u5f55\u5165");
            } else if (status == 1) {
                logVo.setItemTitle("\u3010" + model.getPilotProjectName() + "\u3011\u63d0\u4ea4\u672c\u7ea7\u5ba1\u6838");
            } else if (status == 2) {
                logVo.setItemTitle("\u3010" + model.getPilotProjectName() + "\u3011\u672c\u7ea7\u5ba1\u6838\u9a73\u56de");
            } else if (status == 3) {
                logVo.setItemTitle("\u3010" + model.getPilotProjectName() + "\u3011\u63d0\u4ea4\u90e8\u95e8\u786e\u8ba4");
            } else if (status == 4) {
                logVo.setItemTitle("\u3010" + model.getPilotProjectName() + "\u3011\u90e8\u95e8\u786e\u8ba4\u9a73\u56de");
            } else if (status == 5) {
                logVo.setItemTitle("\u3010" + model.getPilotProjectName() + "\u3011\u90e8\u95e8\u786e\u8ba4\u5206\u53d1");
            }
            logVo.setOperateInfo(BizUtils.getDicValueByCode((List<DictModel>)glb_shzt, status));
        } else if (approvalResults == 2) {
            if (status == 0) {
                logVo.setItemTitle("\u3010" + model.getPilotProjectName() + "\u3011\u64a4\u56de\u4e3a\u8349\u7a3f");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u8349\u7a3f");
            } else if (status == 1) {
                logVo.setItemTitle("\u3010" + model.getPilotProjectName() + "\u3011\u64a4\u56de\u4e3a\u63d0\u4ea4\u672c\u7ea7\u5ba1\u6838");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u63d0\u4ea4\u672c\u7ea7\u5ba1\u6838");
            } else if (status == 3) {
                logVo.setItemTitle("\u3010" + model.getPilotProjectName() + "\u3011\u64a4\u56de\u4e3a\u63d0\u4ea4\u90e8\u95e8\u786e\u8ba4");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u63d0\u4ea4\u90e8\u95e8\u786e\u8ba4");
            }
            logVo.setApprovalResults(2);
        }
        logVo.setStatus(status.toString());
        logVo.setApprovalComments(approvalComments);
        logVo.setBizType("5");
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        if (BeanUtils.isNotEmpty((Object)((Object)logVo))) {
            this.achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
        }
    }

    @Override
    public List<CountyChartVo> lineChartDataForLargeScreen(Integer year, Integer quarter) {
        return ((BizReformPilotManagementDao)this.baseMapper).lineChartDataForLargeScreen(year, quarter);
    }

    @Override
    public boolean inputRevInfo(String pid) {
        List list = this.bizPilotAdvanceRecordManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PILOT_ID_", (Object)pid)).eq((Object)"IS_DELE_", (Object)"0"));
        return list.size() <= 0;
    }

    @Override
    public void distinct() {
        List list = this.list();
        for (BizReformPilotManagement bizReformPilotManagement : list) {
            List bizId = this.achieveStatusLogManager.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"BIZ_ID_", (Object)bizReformPilotManagement.getId())).orderByAsc((Object)"SN_"));
            for (int i = 0; i < bizId.size(); ++i) {
                AchieveStatusLog achieveStatusLog = (AchieveStatusLog)((Object)bizId.get(i));
                if (i == bizId.size() - 1) continue;
                AchieveStatusLog achieveStatusLog1 = (AchieveStatusLog)((Object)bizId.get(i + 1));
                if (!achieveStatusLog.getStatus().equals(achieveStatusLog1.getStatus())) continue;
                this.achieveStatusLogManager.remove((Wrapper)new QueryWrapper().eq((Object)"ID_", (Object)achieveStatusLog1.getId()));
            }
        }
    }

    @Override
    public boolean isUpdateAcceptanceTime(String id, Date time) {
        Assert.notNull((Object)id, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)time, (String)"\u6240\u586b\u9a8c\u6536\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        BizReformPilotManagement entity = (BizReformPilotManagement)((Object)super.getById((Serializable)((Object)id)));
        return entity == null || entity.getAcceptanceTime() == null || entity.getAcceptanceTime().equals(time);
    }

    boolean bothAudit(String id, Integer status) {
        BizReformPilotManagement entity = (BizReformPilotManagement)((Object)super.getById((Serializable)((Object)id)));
        switch (status) {
            case 0: {
                return entity.getStatus() == 2 || entity.getStatus() == 4 || entity.getStatus() == null || entity.getStatus() == 1 || entity.getStatus() == 0;
            }
            case 1: {
                return entity.getStatus() == 0 || entity.getStatus() == 2 || entity.getStatus() == 3 || entity.getStatus() == 1;
            }
            case 2: {
                return entity.getStatus() == 1 || entity.getStatus() == 2;
            }
            case 3: {
                return entity.getStatus() == 1 || entity.getStatus() == 3 || entity.getStatus() == 4 || entity.getStatus() == 5;
            }
            case 4: {
                return entity.getStatus() == 3 || entity.getStatus() == 4;
            }
            case 5: {
                return entity.getStatus() == 3 || entity.getStatus() == 5;
            }
        }
        return false;
    }

    @Override
    public PageList<BizReformPilotManagement> queryDetail(QueryFilter<BizReformPilotManagement> queryFilter) {
        IPage<BizReformPilotManagement> iPage = ((BizReformPilotManagementDao)this.baseMapper).queryDetail((IPage<BizReformPilotManagement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizReformPilotManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        PageList data = new PageList(iPage);
        if (data.getRows() != null && data.getRows().size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (BizReformPilotManagement reformPilotManagement : data.getRows()) {
                list.add(reformPilotManagement.getId());
            }
            List districts = this.reformInvolvedDistrictsManager.list((Wrapper)new QueryWrapper().in((Object)"PILOT_ID_", list));
            if (districts != null && districts.size() > 0) {
                data.getRows().forEach(d -> {
                    List<BizReformInvolvedDistricts> invs = districts.stream().filter(dt -> d.getId().equals(dt.getPilotId())).collect(Collectors.toList());
                    d.setInvs(invs);
                });
            }
        }
        return data;
    }

    @Override
    public List<BizReformPilotManagement> queryLatestDetail(QueryFilter<BizReformPilotManagement> queryFilter) {
        List<BizReformPilotManagement> list = ((BizReformPilotManagementDao)this.baseMapper).queryLatestRecordsForInvolved((Wrapper<BizReformPilotManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return list;
    }

    @Override
    public List<BizReformPilotManagement> queryLatest(QueryFilter<BizReformPilotManagement> queryFilter) {
        List<BizReformPilotManagement> list = ((BizReformPilotManagementDao)this.baseMapper).queryLatestRecords((Wrapper<BizReformPilotManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return list;
    }

    @Override
    public PageList<BizReformPilotManagement> queryDetailForUnit(QueryFilter<BizReformPilotManagement> queryFilter) {
        IPage<BizReformPilotManagement> iPage = ((BizReformPilotManagementDao)this.baseMapper).queryDetailForUnit((IPage<BizReformPilotManagement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizReformPilotManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        PageList data = new PageList(iPage);
        if (data.getRows() != null && data.getRows().size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (BizReformPilotManagement reformPilotManagement : data.getRows()) {
                list.add(reformPilotManagement.getId());
            }
            List districts = this.reformInvolvedDistrictsManager.list((Wrapper)new QueryWrapper().in((Object)"PILOT_ID_", list));
            if (districts != null && districts.size() > 0) {
                data.getRows().forEach(d -> {
                    List<BizReformInvolvedDistricts> invs = districts.stream().filter(dt -> d.getId().equals(dt.getPilotId())).collect(Collectors.toList());
                    d.setInvs(invs);
                });
            }
        }
        return data;
    }

    private void verify(String id) {
        Integer invCount = this.bizPilotAdvanceRecordDao.invCount(id);
        Integer recCount = this.bizPilotAdvanceRecordDao.recCount(id);
        if (BeanUtils.isNotEmpty((Object)recCount) && BeanUtils.isNotEmpty((Object)invCount) && invCount <= recCount) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"id_", (Object)id);
            updateWrapper.set((Object)"PROPULSIVE_STATUS_", (Object)3);
            super.update((Wrapper)updateWrapper);
        }
    }
}

