/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizMeetingEventPushDao;
import com.artfess.reform.fill.manager.BizMeetingEventDetailsManager;
import com.artfess.reform.fill.manager.BizMeetingEventPushManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizMeetingEventDetails;
import com.artfess.reform.fill.model.BizMeetingEventPush;
import com.artfess.reform.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizMeetingEventPushManagerImpl
extends BaseManagerImpl<BizMeetingEventPushDao, BizMeetingEventPush>
implements BizMeetingEventPushManager {
    @Resource
    FileManager fileManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    private BizMeetingEventDetailsManager bizMeetingEventDetailsManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    private UniversalWayManager universalWayManager;

    @Override
    @Transactional
    public void saveOrUpdateList(List<BizMeetingEventPush> bizMeetingEventPushList) {
        bizMeetingEventPushList.stream().forEach(p -> {
            Map<String, Integer> map = this.universalWayManager.setDate(p.getFeedbackDate());
            p.setFeedbackYear(map.get("year"));
            p.setFeedbackMonth(map.get("month"));
            p.setFeedbackQuarter(map.get("quarter"));
            p.setFeedbackWeek(map.get("week"));
        });
        super.saveOrUpdateBatch(bizMeetingEventPushList);
        for (BizMeetingEventPush mep : bizMeetingEventPushList) {
            List<DefaultFile> files = mep.getFiles();
            if (null == files || files.size() <= 0) continue;
            List fileList = files.stream().map(f -> f.getId()).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileList, mep.getId());
        }
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizMeetingEventPush bizMeetingEventPush) {
        Map<String, Integer> map = this.universalWayManager.setDate(new Date());
        bizMeetingEventPush.setFeedbackDate(new Date());
        bizMeetingEventPush.setFeedbackYear(map.get("year"));
        bizMeetingEventPush.setFeedbackMonth(map.get("month"));
        bizMeetingEventPush.setFeedbackQuarter(map.get("quarter"));
        bizMeetingEventPush.setFeedbackWeek(map.get("week"));
        if (BeanUtils.isNotEmpty((Object)bizMeetingEventPush.getId()) && bizMeetingEventPush.getStatus() == 0) {
            super.saveOrUpdate((Object)bizMeetingEventPush);
        } else {
            super.saveOrUpdate((Object)bizMeetingEventPush);
            this.setApprovalLog(bizMeetingEventPush.getId(), bizMeetingEventPush.getDetailsId(), null, bizMeetingEventPush.getStatus(), null);
        }
        List<DefaultFile> files = bizMeetingEventPush.getFiles();
        if (null != files && files.size() > 0) {
            List fileList = files.stream().map(f -> f.getId()).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileList, bizMeetingEventPush.getId());
        }
    }

    @Override
    public PageList<BizMeetingEventPush> queryByPage(QueryFilter<BizMeetingEventPush> queryFilter) {
        PageList result;
        List rows;
        if (BizUtils.isAdmin(this.ucFeignService)) {
            queryFilter.addFilter("UNIT_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        if (BeanUtils.isNotEmpty((Object)(rows = (result = super.query(queryFilter)).getRows())) && rows.size() > 0) {
            rows.stream().forEach(s -> s.setFiles(this.fileManager.queryFileByBizId(s.getId())));
        }
        return result;
    }

    @Override
    public BizMeetingEventPush detailedById(String id) {
        BizMeetingEventPush result = (BizMeetingEventPush)((Object)super.getById((Serializable)((Object)id)));
        result.setFiles(this.fileManager.queryFileByBizId(id));
        return result;
    }

    @Override
    @Transactional
    public boolean modifyStatus(String id, String projectId, Integer approvalResults, String status) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.set((Object)"STATUS_", (Object)status)).eq((Object)"ID_", (Object)id);
        this.setApprovalLog(id, projectId, approvalResults, Integer.parseInt(status), null);
        return super.update((Wrapper)updateWrapper);
    }

    @Override
    public List<BizMeetingEventPush> queryHistory(QueryFilter<BizMeetingEventPush> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        List result = super.query(queryFilter).getRows();
        if (BeanUtils.isNotEmpty((Object)result) && result.size() > 0) {
            for (BizMeetingEventPush mep : result) {
                if (BeanUtils.isNotEmpty((Object)mep.getStatus())) {
                    QueryWrapper logQW = new QueryWrapper();
                    ((QueryWrapper)((QueryWrapper)((QueryWrapper)logQW.eq((Object)"BIZ_ID_", (Object)mep.getId())).eq((Object)"APPROVAL_RESULTS_", (Object)1)).orderByDesc((Object)"LAST_TIME_")).last("limit 1");
                    AchieveStatusLog achieveStatusLog = (AchieveStatusLog)((Object)this.achieveStatusLogManager.getBaseMapper().selectOne((Wrapper)logQW));
                    if (BeanUtils.isNotEmpty((Object)((Object)achieveStatusLog))) {
                        mep.setApprovalComments(achieveStatusLog.getApprovalComments());
                    }
                }
                List files = this.fileManager.queryFileByBizId(mep.getId());
                mep.setFiles(files);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public void examineAndVerify(BizMeetingEventPush bizMeetingEventPush) {
        if (!bizMeetingEventPush.getAbutmentStatus().equals("1") && bizMeetingEventPush.getStatus().equals("3")) {
            UpdateWrapper detailsUW = new UpdateWrapper();
            ((UpdateWrapper)((UpdateWrapper)detailsUW.set((Object)"ABUTMENT_STATUS_", (Object)bizMeetingEventPush.getAbutmentStatus())).eq((Object)"ID_", (Object)bizMeetingEventPush.getDetailsId())).ne((Object)"ABUTMENT_STATUS_", (Object)bizMeetingEventPush.getAbutmentStatus());
            this.bizMeetingEventDetailsManager.update((Wrapper)detailsUW);
        }
        this.setApprovalLog(bizMeetingEventPush.getId(), bizMeetingEventPush.getDetailsId(), bizMeetingEventPush.getApprovalResults(), bizMeetingEventPush.getStatus(), bizMeetingEventPush.getApprovalComments());
        super.updateById((Object)bizMeetingEventPush);
        List<DefaultFile> files = bizMeetingEventPush.getFiles();
        if (null != files && files.size() > 0) {
            List fileList = files.stream().map(f -> f.getId()).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileList, bizMeetingEventPush.getId());
        }
    }

    @Transactional
    public void setApprovalLog(String id, String projectId, Integer approvalResults, Integer status, String approvalComments) {
        BizMeetingEventDetails details = (BizMeetingEventDetails)((Object)this.bizMeetingEventDetailsManager.getById((Serializable)((Object)projectId)));
        String title = details.getMeetingTask();
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("9");
        logVo.setApprovalComments(approvalComments);
        logVo.setModuleTableName("BIZ_MEETING_EVENT_PUSH");
        if (BeanUtils.isNotEmpty((Object)approvalResults) && approvalResults == 2) {
            if (status == 0) {
                logVo.setItemTitle("\u3010" + title + "\u3011\u64a4\u56de\u4e3a\u8349\u7a3f\uff01");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u8349\u7a3f");
            } else if (status == 1) {
                logVo.setItemTitle("\u3010" + title + "\u3011\u64a4\u56de\u4e3a\u63d0\u4ea4\u672c\u7ea7\u5ba1\u6838\uff01");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u63d0\u4ea4\u672c\u7ea7\u5ba1\u6838");
            } else if (status == 3) {
                logVo.setItemTitle("\u3010" + title + "\u3011\u64a4\u56de\u4e3a\u672c\u7ea7\u5ba1\u6838\u901a\u8fc7\uff01");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u672c\u7ea7\u5ba1\u6838\u901a\u8fc7");
            }
            logVo.setApprovalResults(2);
        } else if (status == 0) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u521b\u5efa\u5f55\u5165\uff01");
            logVo.setOperateInfo("\u8349\u7a3f");
            logVo.setApprovalResults(0);
        } else if (status == 1) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63d0\u4ea4\u672c\u7ea7\u5ba1\u6838\uff01");
            logVo.setOperateInfo("\u63d0\u4ea4\u672c\u7ea7\u5ba1\u6838");
            logVo.setApprovalResults(0);
        } else if (status == 2) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u672c\u7ea7\u5ba1\u6838\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u672c\u7ea7\u5ba1\u6838\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (status == 3) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u672c\u7ea7\u5ba1\u6838\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u672c\u7ea7\u5ba1\u6838\u901a\u8fc7");
            logVo.setApprovalResults(0);
        } else if (status == 4) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u6539\u9769\u529e\u786e\u8ba4\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u786e\u8ba4\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (status == 5) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u6539\u9769\u529e\u786e\u8ba4\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u786e\u8ba4\u901a\u8fc7");
            logVo.setApprovalResults(0);
        }
        logVo.setStatus(status.toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        this.achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }
}

