/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizEffectDryingCompetitionDao;
import com.artfess.reform.fill.dao.BizEffectEffectivenessDao;
import com.artfess.reform.fill.manager.BizEffectDryingCompetitionManager;
import com.artfess.reform.fill.manager.BizEffectEffectivenessManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizEffectDryingCompetition;
import com.artfess.reform.fill.model.BizEffectEffectiveness;
import com.artfess.reform.fill.vo.EffectDryingCompetitionExportVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizEffectDryingCompetitionManagerImpl
extends BaseManagerImpl<BizEffectDryingCompetitionDao, BizEffectDryingCompetition>
implements BizEffectDryingCompetitionManager {
    @Resource
    private BizEffectEffectivenessManager effectEffectivenessManager;
    @Resource
    private UniversalWayManager universalWayManager;
    @Resource
    private BizEffectEffectivenessDao effectEffectivenessDao;
    @Resource
    private FileManager fileManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @Override
    @Transactional
    public String inertInfo(BizEffectDryingCompetition effectDrying) {
        this.saveOrUpdate((Object)effectDrying);
        List<BizEffectEffectiveness> records = effectDrying.getRecords();
        if (BeanUtils.isNotEmpty(records)) {
            for (BizEffectEffectiveness model : records) {
                if (model.getStatus() == null) {
                    model.setStatus(0);
                }
                model.setEffectId(effectDrying.getId());
                LocalDate completionDate = model.getCompletionDate();
                if (completionDate == null) {
                    completionDate = LocalDate.now();
                }
                model.setCompletionYear(completionDate.getYear());
                model.setCompletionQuarter(Integer.valueOf(completionDate.getMonthValue() + 2) / 3);
                model.setCompletionMonth(completionDate.getMonthValue());
                this.effectEffectivenessManager.saveOrUpdate((Object)model);
                if (model.getIds() != null && model.getIds().size() > 0) {
                    this.universalWayManager.attachmentUpdates(model.getIds(), model.getId());
                }
                this.setApprovalLog(model.getId(), effectDrying.getId(), model.getStatus(), "", model.getApprovalResults());
            }
        }
        return effectDrying.getId();
    }

    @Override
    @Transactional
    public CommonResult<String> updateInfo(BizEffectDryingCompetition effectDryingCompetition) {
        List<BizEffectEffectiveness> records = effectDryingCompetition.getRecords();
        if (BeanUtils.isNotEmpty(records)) {
            for (BizEffectEffectiveness model : records) {
                model.setEffectId(effectDryingCompetition.getId());
                if (model.getIds() != null && model.getIds().size() > 0) {
                    this.universalWayManager.attachmentUpdates(model.getIds(), model.getId());
                }
                boolean check = this.check(model);
                this.effectEffectivenessDao.updateById((Object)model);
                if (!check) continue;
                this.setApprovalLog(model.getId(), model.getEffectId(), model.getStatus(), model.getApprovalComments(), model.getApprovalResults());
            }
        }
        ((BizEffectDryingCompetitionDao)this.baseMapper).updateById((Object)effectDryingCompetition);
        return new CommonResult(true, "\u4fee\u6539\u6210\u529f\uff01");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteById(String id) {
        Assert.hasText((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"EFFECT_ID_", (Object)id)).notIn((Object)"STATUS_", Arrays.asList(0, 2, 4));
        int num = this.effectEffectivenessDao.selectCount((Wrapper)queryWrapper);
        if (num > 0) {
            return new CommonResult(false, "\u5df2\u63d0\u4ea4\u5ba1\u6838\u65e0\u6cd5\u5220\u9664");
        }
        ((BizEffectDryingCompetitionDao)this.baseMapper).deleteById((Serializable)((Object)id));
        QueryWrapper delWrapper = new QueryWrapper();
        delWrapper.eq((Object)"EFFECT_ID_", (Object)id);
        this.effectEffectivenessDao.delete((Wrapper)delWrapper);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public PageList<EffectDryingCompetitionExportVo> queryAudit(QueryFilter<BizEffectDryingCompetition> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<EffectDryingCompetitionExportVo> result = ((BizEffectDryingCompetitionDao)this.baseMapper).queryAudit((IPage<BizEffectDryingCompetition>)this.convert2IPage(pageBean), (Wrapper<BizEffectDryingCompetition>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public BizEffectDryingCompetition queryById(String id) {
        Assert.hasText((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BizEffectDryingCompetition effectDryingCompetition = (BizEffectDryingCompetition)((Object)((BizEffectDryingCompetitionDao)this.baseMapper).selectById((Serializable)((Object)id)));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"EFFECT_ID_", (Object)id);
        List list = this.effectEffectivenessDao.selectList((Wrapper)queryWrapper);
        if (BeanUtils.isNotEmpty((Object)list)) {
            for (BizEffectEffectiveness record : list) {
                if (record.getStatus() == 2 || record.getStatus() == 4) {
                    AchieveStatusLog log = this.achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(record.getId(), record.getStatus());
                    record.setApprovalComments(log.getApprovalComments());
                }
                QueryWrapper fileQuery = new QueryWrapper();
                fileQuery.eq((Object)"biz_id_", (Object)record.getId());
                List filesList = this.fileManager.list((Wrapper)fileQuery);
                record.setFiles(filesList);
            }
            effectDryingCompetition.setRecords(list);
        }
        return effectDryingCompetition;
    }

    @Override
    @Transactional
    public void updateAuditStatus(BizEffectEffectiveness record) {
        boolean check = this.check(record);
        this.effectEffectivenessDao.updateById((Object)record);
        if (check) {
            this.setApprovalLog(record.getId(), record.getEffectId(), record.getStatus(), record.getApprovalComments(), record.getApprovalResults());
        }
    }

    @Transactional
    public void setApprovalLog(String id, String effectId, Integer status, String approvalComments, Integer approvalResults) {
        BizEffectDryingCompetition effectDrying = (BizEffectDryingCompetition)((Object)((BizEffectDryingCompetitionDao)this.baseMapper).selectById((Serializable)((Object)effectId)));
        String title = effectDrying.getEffectCardTopic();
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("4");
        logVo.setApprovalComments(approvalComments);
        logVo.setModuleTableName("biz_effect_effectiveness");
        if (approvalResults != null && approvalResults == 2) {
            if (status == 0) {
                logVo.setItemTitle("\u3010" + title + "\u3011\u64a4\u56de\u4e3a\u8349\u7a3f\u72b6\u6001\uff01");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u8349\u7a3f\u72b6\u6001\uff01");
                logVo.setApprovalResults(2);
            } else if (status == 1) {
                logVo.setItemTitle("\u3010" + title + "\u3011\u64a4\u56de\u4e3a\u63d0\u4ea4\u5ba1\u6838\uff01");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u63d0\u4ea4\u5ba1\u6838");
                logVo.setApprovalResults(2);
            } else if (status == 3) {
                logVo.setItemTitle("\u3010" + title + "\u3011\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7\uff01");
                logVo.setOperateInfo("\u64a4\u56de\u4e3a\u5ba1\u6838\u901a\u8fc7");
                logVo.setApprovalResults(2);
            }
        } else if (status == 0) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u5f55\u5165\uff01");
            logVo.setOperateInfo("\u6210\u6548\u667e\u6652\u4fe1\u606f\u5f55\u5165\uff01");
            logVo.setApprovalResults(0);
        } else if (status == 1) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u63d0\u4ea4\u5ba1\u6838\uff01");
            logVo.setOperateInfo("\u63d0\u4ea4\u5ba1\u6838");
            logVo.setApprovalResults(0);
        } else if (status == 2) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u5ba1\u6838\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u5ba1\u6838\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (status == 3) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u5ba1\u6838\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u5ba1\u6838\u901a\u8fc7");
            logVo.setApprovalResults(0);
        } else if (status == 4) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u6539\u9769\u529e\u9a73\u56de\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u9a73\u56de");
            logVo.setApprovalResults(1);
        } else if (status == 5) {
            logVo.setItemTitle("\u3010" + title + "\u3011\u6539\u9769\u529e\u901a\u8fc7\uff01");
            logVo.setOperateInfo("\u6539\u9769\u529e\u901a\u8fc7");
            logVo.setApprovalResults(0);
        }
        logVo.setStatus(status.toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        this.achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

    boolean check(BizEffectEffectiveness record) {
        BizEffectEffectiveness entity = (BizEffectEffectiveness)((Object)this.effectEffectivenessManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)record.getId())).eq((Object)"IS_DELE_", (Object)"0"), false));
        return entity == null || entity.getStatus() != record.getStatus();
    }
}

