package com.artfess.reform.statistics.schedule;

import com.artfess.reform.statistics.manager.BizScoringCountyBrandManager;
import com.artfess.reform.statistics.manager.BizScoringCountySynManager;
import com.artfess.reform.statistics.manager.BizScoringCountyWorkableManager;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;

@Component
@EnableScheduling
public class ScoreCalSchedule {

    @Resource
    BizScoringCountyWorkableManager workableManager;
    @Resource
    BizScoringCountyBrandManager brandManager;
    @Resource
    BizScoringCountySynManager synManager;

    //计算区县改革落实力、区县品牌显示度、区县综合评分结果
    @Scheduled(cron = "0 50 23 * * ?")
    public void scheduleWorkable(){
        LocalDate countDate =LocalDate.now();
        workableManager.countScore(countDate);
        brandManager.countScore(countDate);
        synManager.countScore(countDate);
    }

}
