package com.artfess.reform.statistics.model;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;

import java.time.LocalDate;
import java.time.LocalDateTime;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目量化目标推进力评分结果
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-13
 */
@TableName("BIZ_SCORING_PROJECT_TARGET")
@ApiModel(value="BizScoringProjectTarget对象", description="项目量化目标推进力评分结果")
@Data
public class BizScoringProjectTarget extends BaseModel<BizScoringProjectTarget> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评比日期")
    @TableField("FILL_DATE_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "评比年")
    @TableField("FILL_YEAR_")
    private Integer fillYear;

    @ApiModelProperty(value = "评比季度")
    @TableField("FILL_QUARTER_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "评比月")
    @TableField("FILL_MONTH_")
    private Integer fillMonth;

    @ApiModelProperty(value = "评比类型")
    @TableField("FILL_TYPE_")
    private String fillType;

    @ApiModelProperty(value = "评比项目")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "评比项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "明确目标个数")
    @TableField("TARGET_NUM_")
    private Integer targetNum=0;

    @ApiModelProperty(value = "达成目标个数")
    @TableField("REACH_NUM_")
    private Integer reachNum =0;

    @ApiModelProperty(value = "目标达成率")
    @TableField("REACH_RATE_")
    private BigDecimal reachRate = new BigDecimal(0);

    @ApiModelProperty(value = "目标推进力评分")
    @TableField("TARGET_SCORE_")
    private BigDecimal targetScore;

    @ApiModelProperty(value = "目标推进力排名")
    @TableField("TARGET_SN_")
    private Integer targetSn;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private Long lastTime;

    @ApiModelProperty(value = "蝉联次数")
    @TableField("HOLD_NUM_")
    private Integer holdNum;


}
