package com.artfess.reform.statistics.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.dao.BizReformRiskInvolvedDistrictsDao;
import com.artfess.reform.fill.dao.BizReformSatisfactionDistrictsDao;
import com.artfess.reform.fill.model.BizReformRiskInvolvedDistricts;
import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.reform.statistics.dao.BizScoringCountySynDao;
import com.artfess.reform.statistics.manager.BizScoringCountySynManager;
import com.artfess.reform.statistics.model.BizScoringCountySyn;
import com.artfess.reform.statistics.vo.CountySynVo;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 区县满意度评分、风险扣分、综合评分结果 服务实现类
 *
 * @author 黎沐华
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-30
 */
@Service
public class BizScoringCountySynManagerImpl extends BaseManagerImpl<BizScoringCountySynDao, BizScoringCountySyn> implements BizScoringCountySynManager {

    @Resource
    private OrgDao orgDao;
    @Resource
    private BizReformSatisfactionDistrictsDao satisfacttDao;
    @Resource
    private BizReformRiskInvolvedDistrictsDao riskDao;
   
    @Override
    @Transactional
    public List<BizScoringCountySyn> countScore(LocalDate countDate) {
        // 取出并合并根数据
        LocalDate now = LocalDate.now();
        if(countDate == null){
            countDate = now;
        }
        LocalDate finalCountDate = countDate;
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());
        int quarter = Integer.valueOf(countDate.getMonthValue() + 2) / 3;
        List<Org> orgs = orgDao.groupOrg();
        //查询满意度的数据
        List<BizReformSatisfactionDistricts> satisfactions = satisfacttDao.countSatisfactForOrg(countDate.getYear(),quarter);
       //查询改革风险的数据
        List<BizReformRiskInvolvedDistricts> risks = riskDao.countRiskForOrg(countDate.getYear(),quarter,1);

        List<BizScoringCountySyn> dataList = new ArrayList<>();
        List<BizScoringCountySyn> finalDataList = dataList;

        //查询统计改革落实力与品牌榜的统计数据
        List<CountySynVo> countySynVoList = baseMapper.indexSynForWorkableAndBrand(countDate.getYear(),quarter);

        orgs.forEach(o -> {
            BizScoringCountySyn d = new BizScoringCountySyn();
            d.setUnitCode(o.getCode());
            d.setUnitName(o.getName());
            d.setUnitGrade(Integer.valueOf(o.getGrade()));
            d.setFillDate(finalCountDate);
            d.setFillYear(finalCountDate.getYear());
            d.setFillQuarter(getSeasonDay(finalCountDate));
            d.setFillMonth(finalCountDate.getMonthValue());
            d.setFillType(getFillType(finalCountDate));
            satisfactions.forEach(s -> {
                if (s.getUnitCode().equals(d.getUnitCode()) ) {
                    d.setSatisfied(s.getSatisfaction());
                    d.setSatisfiedAllSn(s.getAllSn() == null ? null : s.getAllSn().intValue());
                    d.setSatisfiedRegionSn(s.getRegionSn() == null ? null : s.getRegionSn().intValue());
                    d.setSatisfiedHoldNum(s.getHoldNum() == null ? null : s.getHoldNum());

                    if(s.getSatisfaction().compareTo(new BigDecimal("88.93"))>=0){
                        d.setSatisfiedGrade("A");
                    }else if(s.getSatisfaction().compareTo(new BigDecimal("88.93"))<0&&s.getSatisfaction().compareTo(new BigDecimal("87.92"))>=0){
                        d.setSatisfiedGrade("B");
                    }else if(s.getSatisfaction().compareTo(new BigDecimal("87.92"))<0&&s.getSatisfaction().compareTo(new BigDecimal("86.34"))>=0){
                        d.setSatisfiedGrade("C");
                    }else{
                        d.setSatisfiedGrade("D");
                    }

                }
            });

            countySynVoList.forEach(c ->{
                //将改革落实力与品牌榜计算的得分加上满意度的得分（A:3，B:1,C:0,D:-1,E:-3）
                if (c.getUnitCode().equals(d.getUnitCode()) ) {
                    if(d.getSatisfiedGrade()!= null && d.getSatisfiedGrade().equals("A")){
                        d.setScore(new BigDecimal( c.getSynScore() + 3));
                    }else if(d.getSatisfiedGrade()!= null && d.getSatisfiedGrade().equals("B")){
                        d.setScore(new BigDecimal( c.getSynScore() + 1));
                    }else if(d.getSatisfiedGrade()!= null && d.getSatisfiedGrade().equals("C")){
                        d.setScore(new BigDecimal( c.getSynScore() -1));
                    }else if(d.getSatisfiedGrade()!= null && d.getSatisfiedGrade().equals("D")){
                        d.setScore(new BigDecimal( c.getSynScore() - 3));
                    }else{
                        d.setScore(new BigDecimal( c.getSynScore() ));
                    }

                }
            });
            // TODO 可优化魔法值，魔法值参见改革报表--指标体系.doc  (这个版本弃用)
            //      采取有事法则按件次扣分。其中，发生一起因改革引发的较大负面网络舆情扣1分，重大负面网络舆情扣3分，特别重大负面舆情扣5分；
            //      按照《重庆市群体性事件应急预案》（渝委办发〔2016〕58号）等有关规定，对群体性事件划分为“较大”“重大”“特别重大”三类，发生一起因改革引发的较大群体性事件扣3分，重大群体性事件扣5分，特别重大群体性事件扣10分。
            risks.forEach(r -> {
                if (r.getUnitCode().equals(d.getUnitCode()) && r.getRiskQuarter().equals(d.getFillQuarter())) {
                    d.setOpinionNum(d.getOpinionNum() + 1);
                    if (r.getRiskTpye() == 1) {
                        if (r.getRiskLevel() == 1) {
                            d.setOpinionDeScore(d.getOpinionDeScore().add(new BigDecimal(1)));
                        }
                        if (r.getRiskLevel() == 2) {
                            d.setOpinionDeScore(d.getOpinionDeScore().add(new BigDecimal(3)));
                        }
                        if (r.getRiskLevel() == 3) {
                            d.setOpinionDeScore(d.getOpinionDeScore().add(new BigDecimal(5)));
                        }
                    }
                    if (r.getRiskTpye() == 2) {
                        if (r.getRiskLevel() == 1) {
                            d.setOpinionDeScore(d.getOpinionDeScore().add(new BigDecimal(3)));
                        }
                        if (r.getRiskLevel() == 2) {
                           d.setOpinionDeScore(d.getOpinionDeScore().add(new BigDecimal(5)));
                        }
                        if (r.getRiskLevel() == 3) {
                            d.setOpinionDeScore(d.getOpinionDeScore().add(new BigDecimal(10)));
                        }
                    }
                }
            });
            if(new BigDecimal(15).subtract(d.getOpinionDeScore()).compareTo(new BigDecimal(0))==-1){
                d.setOpinionScore(new BigDecimal(0));
            }else{
                d.setOpinionScore(new BigDecimal(15).subtract(d.getOpinionDeScore()));
            }
            finalDataList.add(d);
        });

        // 计算得分
 /*       BigDecimal[] satisCount = dataList.stream().map(BizScoringCountySyn::getSatisfied).toArray(BigDecimal[]::new);
        dataList.forEach(d -> {
            d.setSatisfiedScore(new CumputeUtil(2).cumpute3(satisCount, d.getSatisfied(), new BigDecimal(20), false).setScale(4, BigDecimal.ROUND_HALF_UP));
            d.setScore(d.getScore().add(d.getSatisfiedScore().add(d.getOpinionScore()).setScale(2, BigDecimal.ROUND_HALF_UP)));
        });*/

        //查询上季度的第一名
        List<BizScoringCountySyn> NO1List = new ArrayList<>();
        int month = countDate.getMonthValue();
        if ((month == 6 || month == 9 || month == 12) && countDate.getDayOfMonth() == lastDay.getDayOfMonth()) {
            QueryWrapper<BizScoringCountySyn> queryWrapper = new QueryWrapper();
            queryWrapper.eq("ALL_SN_", 1);
            queryWrapper.eq("FILL_YEAR_", countDate.getYear());
            queryWrapper.eq("FILL_QUARTER_", getSeasonDay(countDate) - 1);
            queryWrapper.eq("FILL_TYPE_", "Q");
            NO1List = list(queryWrapper);
        }
        //查询上季度的蝉联情况
        QueryWrapper<BizScoringCountySyn> queryWrapper = new QueryWrapper();
        queryWrapper.eq("FILL_YEAR_", countDate.getYear());
        queryWrapper.eq("FILL_QUARTER_", getSeasonDay(countDate) - 1);
        queryWrapper.eq("FILL_TYPE_", "Q");
        List<BizScoringCountySyn> holdList = list(queryWrapper);
        Map<String, Integer> snmap = new HashMap<>();
        if (holdList != null && holdList.size() > 0) {
            holdList.forEach(hold ->{
                if(hold.getHoldNum()!=null){
                    snmap.put(hold.getUnitCode(),hold.getHoldNum());
                }
            });
           // snmap = holdList.stream().collect(Collectors.toMap(BizScoringCountySyn::getUnitCode, BizScoringCountySyn::getHoldNum, (key1, key2) -> key2));
        }

        //全市排名
        dataList = dataList.stream().sorted((s1, s2) -> -s1.getScore().compareTo(s2.getScore())).collect(Collectors.toList());
        List<Map.Entry<BigDecimal, List<BizScoringCountySyn>>> snList = dataList.stream().collect(Collectors.groupingBy(BizScoringCountySyn::getScore)).entrySet()
                .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
        Integer index = 1;
        for (Map.Entry<BigDecimal, List<BizScoringCountySyn>> entry : snList) {
            for (BizScoringCountySyn syn : entry.getValue()) {
                syn.setAllSn(index);
                if(index<=9){
                    syn.setGrade("A");
                }else if(17 >= index && index > 9){
                    syn.setGrade("B");
                }else if(25 >= index && index > 17){
                    syn.setGrade("C");
                }else if(33 >= index && index > 25){
                    syn.setGrade("D");
                }else if(index > 33){
                    syn.setGrade("E");
                }
                //蝉联(每个季度最后一天计算)
                if ((month == 3 ||month == 6 || month == 9 || month == 12) && lastDay.getDayOfMonth() == countDate.getDayOfMonth()) {
                    if ((NO1List == null || NO1List.size() == 0) && index == 1) {
                        syn.setHoldNum(0);
                    } else if ((NO1List != null && NO1List.size() > 0) && index == 1) {
                        for (BizScoringCountySyn NO1 : NO1List) {
                            if (NO1.getUnitCode().equals(syn.getUnitCode())) {
                                syn.setHoldNum(NO1.getHoldNum() + 1);
                                break;
                            } else {
                                syn.setHoldNum(0);
                            }
                        }
                    }
                } else {
                    //其它时候的蝉联数据取上月的数据
                    if (!snmap.isEmpty()) {
                        syn.setHoldNum(snmap.get(syn.getUnitCode()));
                    }
                }
            }

            // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
            index = index + entry.getValue().size();
            // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
            //index = ++index;
        }
        //区域排名
       /* Map<Integer, List<BizScoringCountySyn>> regionMap = dataList.stream().collect(Collectors.groupingBy(BizScoringCountySyn::getUnitGrade)); // 按照区域进行分组
        for (Integer key : regionMap.keySet()) {
            //区域综合排名
            List<BizScoringCountySyn> groupList = regionMap.get(key);
            groupList = groupList.stream().sorted((s1, s2) -> -s1.getScore().compareTo(s2.getScore())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringCountySyn>>> snGroupList = groupList.stream().collect(Collectors.groupingBy(BizScoringCountySyn::getScore)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer groupIndex = 1;
            for (Map.Entry<BigDecimal, List<BizScoringCountySyn>> entry : snGroupList) {
                for (BizScoringCountySyn syn : entry.getValue()) {
                    syn.setRegionSn(groupIndex);
                }
                groupIndex = groupIndex + entry.getValue().size();
            }

            //区域风险排名
            List<BizScoringCountySyn> groupOpList = regionMap.get(key);
            groupOpList = groupOpList.stream().sorted((s1, s2) -> -s1.getOpinionScore().compareTo(s2.getOpinionScore())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringCountySyn>>> opGroupList = groupOpList.stream().collect(Collectors.groupingBy(BizScoringCountySyn::getOpinionScore)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer opGroupIndex = 1;

            for (Map.Entry<BigDecimal, List<BizScoringCountySyn>> entry : opGroupList) {
                for (BizScoringCountySyn syn : entry.getValue()) {
                    syn.setOpinionRegionSn(opGroupIndex);
                }
                opGroupIndex = opGroupIndex + entry.getValue().size();
            }

        }*/

        //全市风险排名
        dataList = dataList.stream().sorted((s1, s2) -> -s1.getOpinionScore().compareTo(s2.getOpinionScore())).collect(Collectors.toList());
        List<Map.Entry<BigDecimal, List<BizScoringCountySyn>>> opList = dataList.stream().collect(Collectors.groupingBy(BizScoringCountySyn::getOpinionScore)).entrySet()
                .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
        Integer opIndex = 1;
        for (Map.Entry<BigDecimal, List<BizScoringCountySyn>> entry : opList) {
            for (BizScoringCountySyn syn : entry.getValue()) {
                syn.setOpinionAllSn(opIndex);
            }
            // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
            opIndex = opIndex + entry.getValue().size();
            // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
            //index = ++index;
        }
        if(CollectionUtils.isNotEmpty(dataList) ){
            QueryWrapper<BizScoringCountySyn> delWrapper = new QueryWrapper<>();
            delWrapper.eq("FILL_DATE_", countDate);
            this.baseMapper.delete(delWrapper);
            saveBatch(dataList);
        }
        return dataList;

    }

    public static String getFillType(LocalDate dateTime) {
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        LocalDate lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth());
        if (day == lastDay.getDayOfMonth()) {
            type = "M";
            if (month == 3 || month == 6 || month == 9 || month == 12) {
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue() + 2) / 3;
    }

}
