package com.artfess.reform.statistics.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.artfess.reform.statistics.vo.BrandLineChartVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.statistics.model.BizScoringProjectBrand;
import com.artfess.reform.statistics.manager.BizScoringProjectBrandManager;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目品牌显示度评分结果 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-14
 */
@RestController
@RequestMapping("/bizScoringProjectBrand/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "项目品牌显示度评分结果")
public class BizScoringProjectBrandController extends BaseController<BizScoringProjectBrandManager, BizScoringProjectBrand> {

   /* @Override
    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<BizScoringProjectBrand> query(@RequestBody QueryFilter<BizScoringProjectBrand> queryFilter) {
        SimpleDateFormat formatter= new SimpleDateFormat("yyyy-MM-dd");
        QueryWrapper<BizScoringProjectBrand> wrapper = new QueryWrapper<>();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        wrapper.orderByDesc("FILL_DATE_");
        wrapper.last("limit 1");
        BizScoringProjectBrand projects = baseService.getOne(wrapper);
        if (projects!=null){
            queryFilter.addFilter("FILL_DATE_",df.format(projects.getFillDate()), QueryOP.EQUAL);
        }else {
            Date date = new Date(System.currentTimeMillis());
            queryFilter.addFilter("FILL_DATE_",formatter.format(date), QueryOP.EQUAL);
        }
        return super.query(queryFilter);

    }*/


    @GetMapping("/testCountScore")
    public List<BizScoringProjectBrand> testCountScore(LocalDate countDate) {
        return baseService.countScore(countDate);
    }

}
