package com.artfess.reform.majorProjects.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * 改革方案明确的具体举措表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@TableName("BIZ_PILOT_SPECIFIC_MEASURES")
@ApiModel(value="BizPilotSpecificMeasures对象", description="改革方案明确的具体举措表")
public class PilotSpecificMeasures extends AutoFillFullModel<PilotSpecificMeasures> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "重大项目ID（关联市级重大改革项目管理表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "具体举措")
    @TableField("REFORM_SPECIFIC_MEASURES_")
    private String reformSpecificMeasures;

    @ApiModelProperty(value = "分发类型（0：改革委下发,1：责任单位迭代）")
    @TableField("DISTRIBUTION_TYPE_")
    private Integer distributionType;

    @ApiModelProperty(value = "责任单位跌代类型（0：责任单位新增，1：责任单位迭代【修改】）")
    @TableField("ITERATION_")
    private Integer iteration;

    @ApiModelProperty(value = "责任单位迭代依据")
    @TableField("ITERATION_ACCORDING_")
    private String iterationAccording;


    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele = "0";

    @ApiModelProperty(value = "数据ID")
    @TableField(exist = false)
    private String dataId;

    @ApiModelProperty(value = "月度计划集合")
    @TableField(exist = false)
    private List<PilotSpecificSchedule> pilotSpecificScheduleList;
}
