package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.fill.model.BizMeetingDocumentsConsidered;
import com.artfess.reform.majorProjects.manager.PilotSpecificSchedulePushManager;
import com.artfess.reform.majorProjects.model.*;
import com.artfess.reform.majorProjects.dao.PilotSpecificScheduleDao;
import com.artfess.reform.majorProjects.manager.PilotSpecificScheduleManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.docx4j.wml.P;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 进度计划表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Service
public class PilotSpecificScheduleManagerImpl extends BaseManagerImpl<PilotSpecificScheduleDao, PilotSpecificSchedule> implements PilotSpecificScheduleManager {

    @Resource
    private PilotSpecificSchedulePushManager pilotSpecificSchedulePushManager;

    @Resource
    private SysDictionaryDetailManager sysDictionaryDetailManager;

    @Override
    public boolean saveBatch(List<PilotSpecificSchedule> entityList) {
        if(null == entityList && entityList.size() < 0){
            return false;
        }
        // 保存主表
        boolean b = super.saveOrUpdateBatch(entityList);
        // 保存推进情况
        for (PilotSpecificSchedule pilotSpecificSchedule : entityList){
            List<PilotSpecificSchedulePush> pilotQuantitativeObjectivesPushList = pilotSpecificSchedule.getPilotSpecificSchedulePushList();
            if(null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0){
                pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
                    // 设置项目明确目标ID
                    p.setObjectivesMeasuresId(pilotSpecificSchedule.getId());
                    // 设置项目ID
                    p.setProjectId(pilotSpecificSchedule.getProjectId());
                });
                pilotSpecificSchedulePushManager.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
            }
        }
        return b;
    }

    @Override
    public List<PilotSpecificSchedule> queryListByProjectId(String projectId) {
        List<PilotSpecificSchedule> list = super.list(new QueryWrapper<PilotSpecificSchedule>()
                .eq("PROJECT_ID_", projectId)
                .eq("PLAN_STATUS_", 1)
                .eq("IS_DELE_", "0")
                .orderByAsc("PLAN_YEAR_", "PLAN_QUARTER_", "PLAN_MONTH_")
                .orderByDesc("LAST_TIME_"));
        //todo 是否多余可以删除
        if (null != list && list.size() > 0){
            // 查询进度计划表
            for(PilotSpecificSchedule pilotSpecificSchedule : list){
                List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = pilotSpecificSchedulePushManager.queryListByObjectivesMeasuresId(pilotSpecificSchedule.getId());
                pilotSpecificSchedule.setPilotSpecificSchedulePushList(pilotSpecificSchedulePushList);
            }
        }
        return list;
    }

    @Override
    public List<PilotSpecificSchedule> queryPilotSpecificScheduleListByProjectId(String projectId) {
        List<PilotSpecificSchedule> list = super.list(new QueryWrapper<PilotSpecificSchedule>()
                .eq("PROJECT_ID_", projectId).eq("IS_DELE_", "0").orderByAsc("PLAN_YEAR_","PLAN_MONTH_").orderByDesc("LAST_TIME_"));
        return list;
    }

    @Override
    public void exportExcel(HttpServletResponse response, QueryFilter<PilotSpecificSchedule> queryFilter,boolean isAffirm) throws Exception {
        List<Map<String, Object>> list = new ArrayList<>();
        queryFilter.addFilter("m.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("s.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("m.CLOSING_",1,QueryOP.EQUAL);
        queryFilter.addFilter("PROJECT_TYPE_",1,QueryOP.EQUAL);
        if (!ContextUtil.getCurrentUser().isAdmin()&&ContextUtil.getCurrentUser()!=null&&!isAffirm){
            queryFilter.addFilter("m.UNIT_ID_",ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        }
        IPage<PilotSpecificSchedule> iPage = baseMapper.querySchedulePageInfo(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        PageList<PilotSpecificSchedule> pageList = new PageList<>(iPage);
        if (BeanUtils.isNotEmpty(pageList.getRows())) {
            pageList.getRows().stream().forEach(p -> {
                try {
                    String jsonStr = JsonUtil.toJson(p);
                    Map<String, Object> map = JsonUtil.toMap(jsonStr);
                    //所属领域
                    if (map.get("projectField") != null) {
                        String projectField = map.get("projectField").toString();
                        String projectFieldText = sysDictionaryDetailManager.getTextByValue("ggbb_ssly", projectField);
                        map.put("projectFieldText", projectFieldText);
                    } else {
                        map.put("projectFieldText", "");
                    }
                    //所属跑道
                    if (map.get("projectRunWay") != null) {
                        String projectRunWay = map.get("projectRunWay").toString();
                        String projectRunWayText = sysDictionaryDetailManager.getTextByValue("ggbb_sspd", projectRunWay);
                        map.put("projectRunWayText",projectRunWayText);
                    }else {
                        map.put("projectRunWayText", "");
                    }

                    //月度计划类型
                    if (map.get("planType") != null) {
                        String planType = map.get("planType").toString();
                        String planTypeText = sysDictionaryDetailManager.getTextByValue("yd_jhlx", planType);
                        map.put("planTypeText",planTypeText);
                    }else {
                        map.put("planTypeText", "");
                    }
                    //计划月度
                    if (map.get("planMonth") != null&&map.get("planYear") != null) {
                        String planMonth = map.get("planMonth").toString();
                        String planYear = map.get("planYear").toString();
                        map.put("planDate",planYear+"年"+planMonth+"月");
                    }else {
                        map.put("planDate", "");
                    }
                    //推进状态
                    if (map.get("progressStatus") != null) {
                        String progressStatus = map.get("progressStatus").toString();
                        String progressStatusText = sysDictionaryDetailManager.getTextByValue("tjzt", progressStatus);
                        map.put("progressStatusText",progressStatusText);
                    }else {
                        map.put("progressStatusText", "");
                    }
                    //审核状态
                    if (map.get("status") != null) {
                        String status = map.get("status").toString();
                        String statusText = sysDictionaryDetailManager.getTextByValue("shzt", status);
                        map.put("statusText",statusText);
                    }else {
                        map.put("statusText", "");
                    }
                    list.add(map);
                } catch (Exception e) {
                    throw new RuntimeException("导出失败：" + e.getMessage());
                }
            });
            String tempName = "月度计划推进更新";
            Map<String, String> exportMaps = new LinkedHashMap<>();
            exportMaps.put("projectName", "项目名称");
            exportMaps.put("leader", "牵头市领导");
            exportMaps.put("unitName", "责任单位");
            exportMaps.put("projectFieldText", "所属领域");
            exportMaps.put("projectRunWayText", "所属跑道");
            exportMaps.put("statusText", "审核状态");
            exportMaps.put("planDate", "计划月度");
            exportMaps.put("planTypeText","计划类型");
            exportMaps.put("planContent", "计划内容");
            exportMaps.put("progressStatusText", "推进状态");
            exportMaps.put("completedWork", "已开展工作");
            exportMaps.put("problems", "有关详情及解决问题");
            exportMaps.put("workPlan", "下一步工作计划");
            HSSFWorkbook book = ExcelUtil.exportExcel(tempName, 24, exportMaps, list);
            ExcelUtil.downloadExcel(book, tempName, response);
        }
    }



}
