package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.majorProjects.dao.PilotSpecificMeasuresDao;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresHistoryManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificMeasuresManager;
import com.artfess.reform.majorProjects.manager.PilotSpecificScheduleManager;
import com.artfess.reform.majorProjects.model.*;
import com.artfess.reform.majorProjects.vo.IterationExamine;
import com.artfess.reform.majorProjects.vo.IterationExamineAndProjectVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import net.hasor.utils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 改革方案明确的具体举措表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Service
public class PilotSpecificMeasuresManagerImpl extends BaseManagerImpl<PilotSpecificMeasuresDao, PilotSpecificMeasures> implements PilotSpecificMeasuresManager {


    @Resource
    private PilotSpecificMeasuresHistoryManager pilotSpecificMeasuresHistoryManager;
    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;
    @Resource
    private PilotSpecificScheduleManager pilotSpecificScheduleManager;
    @Resource
    private SysDictionaryManager sysDictionaryManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @Override
    public List<PilotSpecificMeasures> queryListByProjectId(String projectId) {
        List<PilotSpecificMeasures> list = super.list(new QueryWrapper<PilotSpecificMeasures>()
                .eq("PROJECT_ID_", projectId).eq("IS_DELE_", "0"));
        return list;
    }

    /**
     * 直接提交审核
     * @param pilotSpecificMeasuresList
     */
    @Override
    @Transactional
    public void iterationSaveAndCommit(List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresList) {
        Assert.notNull(pilotSpecificMeasuresList, "迭代数据不能为空！");
        //   如果记录不存在说明是新增记录，直接新增，并记录进入历史记录表
        if(null != pilotSpecificMeasuresList && pilotSpecificMeasuresList.size() > 0){
            for (PilotSpecificMeasuresHistory pilotSpecificMeasuresHistory : pilotSpecificMeasuresList){
                String projectId = pilotSpecificMeasuresHistory.getProjectId();
                Assert.notNull(projectId, "迭代举措中项目ID未设置，请先设置项目ID！");
                //设置同步状态
                UpdateWrapper<PilotSpecificMeasuresHistory> updateWrapper=new UpdateWrapper<>();
                updateWrapper.eq("PROJECT_ID_",projectId);
                updateWrapper.eq("STATUS_",5);
                updateWrapper.eq("SYN_STATUS_",0);
                updateWrapper.set("SYN_STATUS_",1);
                pilotSpecificMeasuresHistoryManager.update(updateWrapper);
                //判断当前历史记录是否满足新增条件,满足则新增,不满足为修改
                if (pilotSpecificMeasuresHistory.getSpecificMeasuresId()!=null){
                    PilotSpecificMeasuresHistory entity = pilotSpecificMeasuresHistoryManager.getById(pilotSpecificMeasuresHistory.getId());
                    if (entity==null||(entity.getStatus()!=null&&(entity.getStatus()==5||entity.getStatus()==2||entity.getStatus()==4))){
                        pilotSpecificMeasuresHistory.setId(null);
                    }
                    pilotSpecificMeasuresHistory.setIteration(1);
                }else {
                    pilotSpecificMeasuresHistory.setIteration(0);
                }
                // 提交，将所有状态置为1（已提交待审核）
                pilotSpecificMeasuresHistory.setStatus(1);
                //增加历史版本号
                String measuresId = pilotSpecificMeasuresHistory.getSpecificMeasuresId();
                HashMap<String, Object> map = new HashMap<>();
                if (measuresId ==null){
                    pilotSpecificMeasuresHistory.setSn(0);
                }else {
                    map.put("SPECIFIC_MEASURES_ID_", measuresId);
                    pilotSpecificMeasuresHistory.setSn(pilotSpecificMeasuresHistoryManager.getNextSequence(map));
                }
                //后端获取年,月,季度
                LocalDate date = LocalDate.now();
                pilotSpecificMeasuresHistory.setIterationDate(date);
                pilotSpecificMeasuresHistory.setIterationYear(date.getYear());
                pilotSpecificMeasuresHistory.setIterationMonth(date.getMonth().getValue());
                pilotSpecificMeasuresHistory.setIterationQuarter((date.getMonthValue()+2)/3);
                pilotSpecificMeasuresHistory.setSynStatus(-1);
                pilotSpecificMeasuresHistoryManager.saveOrUpdate(pilotSpecificMeasuresHistory);
                //满足条件,新增操作日志
                List<String> ids = pilotSpecificMeasuresList.stream().filter(p -> p.getStatus() == 1).map(p -> p.getId()).collect(Collectors.toList());
                if (ids!=null &&ids.size()>0){
                    IterationExamine iterationExamine=new IterationExamine();
                    iterationExamine.setIds(ids);
                    iterationExamine.setStatus(1);
                    iterationExamine.setApprovalComments(null);
                    iterationExamine.setApprovalResults(null);
                    this.createLog(iterationExamine);
                }
            }
            //新增或者修改月度推进计划
            addSchedule(pilotSpecificMeasuresList);
        }
    }

    /**
     * 迭代举措添加只保存不提交审核
     * @param pilotSpecificMeasuresList
     */
    @Override
    @Transactional
    public void iterationSave(List<PilotSpecificMeasures> pilotSpecificMeasuresList) {
        Assert.notNull(pilotSpecificMeasuresList, "迭代数据不能为空！");
        // 1.根据ID判断措施是否存在，如果存在就记录Id，将数据存入新增为迭代数据，并加入迭代历史记录
        //   如果记录不存在说明是新增记录，直接新增，并记录进入历史记录表
        if(null != pilotSpecificMeasuresList && pilotSpecificMeasuresList.size() > 0){
            for (PilotSpecificMeasures pilotSpecificMeasures : pilotSpecificMeasuresList){
                String projectId = pilotSpecificMeasures.getProjectId();
                Assert.notNull(projectId, "迭代举措中项目ID未设置，请先设置项目ID！");
                String id = pilotSpecificMeasures.getId();
                UpdateWrapper<PilotSpecificMeasuresHistory> updateWrapper=new UpdateWrapper<>();
                updateWrapper.eq("PROJECT_ID_",id);
                updateWrapper.eq("STATUS_",5);
                updateWrapper.set("SYN_STATUS_",1);
                pilotSpecificMeasuresHistoryManager.update(updateWrapper);
                // 保存未提交，状态为0
               // pilotSpecificMeasures.setStatus(0);
                pilotSpecificMeasures.setDistributionType(1);
                if(StringUtils.isNotBlank(id)){
                    pilotSpecificMeasures.setId(null);
                    pilotSpecificMeasures.setIteration(1);
                }else {
                    pilotSpecificMeasures.setIteration(0);
                }
            }
            this.saveOrUpdateBatch(pilotSpecificMeasuresList);
        }
    }

    /**
     * 根据举措信息进行添加 保存为草稿或修改已有草稿
     * @param
     */
    @Override
    @Transactional
    public void iterationAddSave(List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresList) {
        Assert.notNull(pilotSpecificMeasuresList, "迭代数据不能为空！");

        //   如果记录不存在说明是新增记录，直接新增，并记录进入历史记录表
        if(null != pilotSpecificMeasuresList && pilotSpecificMeasuresList.size() > 0){
            for (PilotSpecificMeasuresHistory pilotSpecificMeasures : pilotSpecificMeasuresList){
                //判断当前历史记录是否满足新增条件,满足则新增,不满足为修改
                if (pilotSpecificMeasures.getSpecificMeasuresId()!=null){
                    PilotSpecificMeasuresHistory entity = pilotSpecificMeasuresHistoryManager.getById(pilotSpecificMeasures.getId());
                 if (entity.getStatus()==5||entity.getStatus()==2||entity.getStatus()==4||entity==null){
                     pilotSpecificMeasures.setId(null);
                 }
                    pilotSpecificMeasures.setIteration(1);
                }else {
                    pilotSpecificMeasures.setIteration(0);
                }
                String projectId = pilotSpecificMeasures.getProjectId();
                Assert.notNull(projectId, "迭代举措中项目ID未设置，请先设置项目ID！");
                pilotSpecificMeasures.setProjectId(pilotSpecificMeasures.getProjectId());
                pilotSpecificMeasures.setStatus(0);
                pilotSpecificMeasures.setIterationDate(LocalDate.now());
                LocalDate date = pilotSpecificMeasures.getIterationDate();
                pilotSpecificMeasures.setIterationYear(date.getYear());
                pilotSpecificMeasures.setIterationMonth(date.getMonth().getValue());
                pilotSpecificMeasures.setIterationQuarter((date.getMonthValue()+2)/3);
                pilotSpecificMeasures.setSynStatus(0);
                //增加历史版本号
                String measuresId = pilotSpecificMeasures.getSpecificMeasuresId();
                HashMap<String, Object> map = new HashMap<>();
                if (measuresId ==null){
                    pilotSpecificMeasures.setSn(0);
                }else {
                    map.put("SPECIFIC_MEASURES_ID_", measuresId);
                    pilotSpecificMeasures.setSn(pilotSpecificMeasuresHistoryManager.getNextSequence(map));
                }

            }

            //查询id有值,且已有状态为0的数据id
            List<String> status=new ArrayList<>();
            for (PilotSpecificMeasuresHistory pilotSpecificMeasuresHistory : pilotSpecificMeasuresList) {
                PilotSpecificMeasuresHistory entity = pilotSpecificMeasuresHistoryManager.getById(pilotSpecificMeasuresHistory.getId());
                if (entity !=null && entity.getStatus()==0){
                    status.add(pilotSpecificMeasuresHistory.getId());
                }
            }
            pilotSpecificMeasuresHistoryManager.saveOrUpdateBatch(pilotSpecificMeasuresList);
            //判断是否满足添加条件,满足则添加历史操作记录
            IterationExamine iteration=new IterationExamine();
            iteration.setIds(pilotSpecificMeasuresList.stream().filter(p->!status.contains(p.getId())).map(p -> p.getId()).collect(Collectors.toList()));
            iteration.setStatus(0);
            iteration.setApprovalComments(null);
            iteration.setApprovalResults(null);
            this.createLog(iteration);
            //添加月度计划
            addSchedule(pilotSpecificMeasuresList);
        }
    }


    @Override
    public PageList<IterationExamineAndProjectVo> iterationListByPage(QueryFilter<PilotSpecificMeasuresHistory> queryFilter) {
        List<IterationExamineAndProjectVo> listVo = new ArrayList<>();
        PageList<PilotSpecificMeasuresHistory> pageList = pilotSpecificMeasuresHistoryManager.query(queryFilter);
        List<PilotSpecificMeasuresHistory> list = pageList.getRows();
        Map<String, MunicipalMajorProjectManagement> map = new HashMap<>();
        if(null != list && list.size() > 0){
            for (PilotSpecificMeasuresHistory pilotSpecificMeasuresHistory : list) {
                IterationExamineAndProjectVo vo = new IterationExamineAndProjectVo();
                vo.setPilotSpecificMeasuresHistory(pilotSpecificMeasuresHistory);
                String projectId =  pilotSpecificMeasuresHistory.getProjectId();
                MunicipalMajorProjectManagement municipalMajorProjectManagement = map.get(projectId);
                if(null == municipalMajorProjectManagement){
                    municipalMajorProjectManagement = municipalMajorProjectManagementManager.get(projectId);
                    map.put(projectId, municipalMajorProjectManagement);
                }
                vo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);

                if (pilotSpecificMeasuresHistory.getSpecificMeasuresId()!=null){
                    PilotSpecificMeasures entity = super.getOne(new QueryWrapper<PilotSpecificMeasures>()
                            .eq("ID_",pilotSpecificMeasuresHistory.getSpecificMeasuresId())
                            .eq("IS_DELE_","0"));
                    vo.setPilotSpecificMeasures(entity);
                }
                listVo.add(vo);
            }
        }
        PageList<IterationExamineAndProjectVo> result = new PageList<>();
        result.setRows(listVo);
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        return result;
    }


    @Override
    @Transactional
    public void iterationCommit(IterationExamine iterationExamine) {
        Assert.notNull(iterationExamine, "审核数据不能为空！");
        Assert.isTrue(iterationExamine.getIds()!=null&&iterationExamine.getIds().size()>0, "审核数据ID不能为空！");
        Assert.notNull(iterationExamine.getStatus(), "审核数据不能为空！");
        UpdateWrapper<PilotSpecificMeasuresHistory> pilotSpecificMeasuresUpdateWrapper =  new UpdateWrapper<PilotSpecificMeasuresHistory>()
                .not(p->p.eq("SYN_STATUS_",1)).set("STATUS_", iterationExamine.getStatus()).in("ID_", iterationExamine.getIds());
        if (iterationExamine.getStatus()==5){
            pilotSpecificMeasuresUpdateWrapper.set("SYN_STATUS_",0);
        }else if (iterationExamine.getApprovalResults()!=null&&iterationExamine.getApprovalResults()==2&&iterationExamine.getStatus()==3){
            pilotSpecificMeasuresUpdateWrapper.set("SYN_STATUS_",-1);
        }
        //判断是否满足添加条件
        boolean check = check(iterationExamine);
        // 根据ID修改状态
        pilotSpecificMeasuresHistoryManager.update(pilotSpecificMeasuresUpdateWrapper);
        //增加历史操作日志
        if (check)this.createLog(iterationExamine);
        //当审核通过,更新相关表数据
        if (iterationExamine.getStatus()==5){
            updateData(iterationExamine);
        }else if (iterationExamine.getApprovalResults()!=null&&iterationExamine.getApprovalResults()==2&&iterationExamine.getStatus()==3){
            updateDataHis(iterationExamine);
        }


    }

    @Override
    public int countPilotSpecificMeasuresByParentId(String id) {
        Assert.notNull(id, "举措ID不能为空");
        QueryWrapper<PilotSpecificMeasures> queryWrapper = new QueryWrapper();
        queryWrapper.eq("PROJECT_ID_", id).eq("DISTRIBUTION_TYPE_",1).eq("IS_DELE_", 0);
        return this.count(queryWrapper);
    }

    //满足条件更新迭代主表数据
    private void updateData(IterationExamine iterationExamine){
         //查询符合条件的历史数据
        QueryWrapper<PilotSpecificMeasuresHistory> pilotSpecificMeasuresQueryWrapper = new QueryWrapper<>();
        pilotSpecificMeasuresQueryWrapper.in("ID_", iterationExamine.getIds());
        List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresList = pilotSpecificMeasuresHistoryManager.list(pilotSpecificMeasuresQueryWrapper);


            for (PilotSpecificMeasuresHistory entity : pilotSpecificMeasuresList) {
                // 如果审核全部通过，就将原来的数据移除，并将原始数据ID赋值给审核通过的数据
                PilotSpecificMeasures measures=new PilotSpecificMeasures();
                BeanUtils.copyProperties(measures,entity);
                if(entity.getSpecificMeasuresId()==null){
                    measures.setId(null);
                    super.save(measures);
                }else {
                    //撤回操作：将已审核通过并存入举措表中的数据，取消删除
                    measures.setId(entity.getSpecificMeasuresId());
                    measures.setProjectId(entity.getProjectId());
                    super.update(measures);
                }
                //更新历史表原始举措id
                UpdateWrapper<PilotSpecificMeasuresHistory> updateWrapperHis=new UpdateWrapper<>();
                updateWrapperHis.eq("ID_",entity.getId())
                        .isNull("SPECIFIC_MEASURES_ID_")
                        .eq("IS_DELE_","0")
                        .set("SPECIFIC_MEASURES_ID_",measures.getId());
                pilotSpecificMeasuresHistoryManager.update(updateWrapperHis);

                //更新月度计划表
                UpdateWrapper<PilotSpecificSchedule> updateWrapperSch=new UpdateWrapper<>();
                updateWrapperSch.eq("MEASURES_ID_",entity.getId());
                updateWrapperSch.eq("IS_DELE_","0");
                if (iterationExamine.getApprovalResults()!=null&&iterationExamine.getApprovalResults()==2){
                    updateWrapperSch.set("PROJECT_ID_",null);
                    updateWrapperSch.set("IS_DELE_","1");
                }else {
                    updateWrapperSch.set("PROJECT_ID_",entity.getProjectId());
                }

                updateWrapperSch.set("PLAN_STATUS_",1);
                pilotSpecificScheduleManager.update(updateWrapperSch);
            }


    }

    //满足条件更新迭代主表数据
    private void updateDataHis(IterationExamine iterationExamine){

        // 查询符合条件的历史数据
        QueryWrapper<PilotSpecificMeasuresHistory> pilotSpecificMeasuresQueryWrapper = new QueryWrapper<>();
        pilotSpecificMeasuresQueryWrapper.in("ID_", iterationExamine.getIds());
        List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresList = pilotSpecificMeasuresHistoryManager.list(pilotSpecificMeasuresQueryWrapper);
        // 如果审核全部通过，就将原来的数据移除，并将原始数据ID赋值给审核通过的数据
        PilotSpecificMeasures measures=new PilotSpecificMeasures();
        for (PilotSpecificMeasuresHistory entity : pilotSpecificMeasuresList) {
            PilotSpecificMeasuresHistory hisEntity = pilotSpecificMeasuresHistoryManager.getOne(new QueryWrapper<PilotSpecificMeasuresHistory>().eq("SPECIFIC_MEASURES_ID_", entity.getSpecificMeasuresId()).eq("IS_DELE_", 0).orderByDesc("CREATE_TIME_").last("LIMIT 1,1"));
            if (hisEntity!=null){
                BeanUtils.copyProperties(measures,hisEntity);
                if (entity.getSpecificMeasuresId()==null){
                    measures.setId(null);
                }else {
                    measures.setId(hisEntity.getSpecificMeasuresId());
                }
                //更新迭代主表
                super.saveOrUpdate(measures);
            }
            //更新历史表原始举措id
            if (null!=entity.getIteration()&&entity.getIteration()==0){
                //并删除已存在的举措
                if (entity.getSpecificMeasuresId()!=null){
                    UpdateWrapper<PilotSpecificMeasures> updateWrapper = new UpdateWrapper<PilotSpecificMeasures>()
                            .eq("ID_", entity.getSpecificMeasuresId()).set("PROJECT_ID_", null);
                    super.update(updateWrapper);
                }
                UpdateWrapper<PilotSpecificMeasuresHistory> updateWrapperHis=new UpdateWrapper<>();
                updateWrapperHis.eq("ID_",entity.getId())
                        .isNull("SPECIFIC_MEASURES_ID_")
                        .eq("IS_DELE_","0")
                        .set("SPECIFIC_MEASURES_ID_",null);
                pilotSpecificMeasuresHistoryManager.update(updateWrapperHis);
            }


            //更新月度计划表
            UpdateWrapper<PilotSpecificSchedule> updateWrapperSch=new UpdateWrapper<>();
            updateWrapperSch.eq("MEASURES_ID_",entity.getId());
            updateWrapperSch.eq("IS_DELE_","0");
            updateWrapperSch.set("PROJECT_ID_",null);
            pilotSpecificScheduleManager.update(updateWrapperSch);
        }


    }

    //添加月度计划
    private void addSchedule(List<PilotSpecificMeasuresHistory> pilotSpecificMeasuresHistoryList){
        for (PilotSpecificMeasuresHistory pilotSpecificMeasuresHistory : pilotSpecificMeasuresHistoryList) {
            if (pilotSpecificMeasuresHistory.getPilotSpecificScheduleList()!=null&&pilotSpecificMeasuresHistory.getPilotSpecificScheduleList().size()>0){
                List<PilotSpecificSchedule> scheduleList = pilotSpecificMeasuresHistory.getPilotSpecificScheduleList();
                for (PilotSpecificSchedule entity : scheduleList) {
                    entity.setMeasuresId(pilotSpecificMeasuresHistory.getId());
                    entity.setPlanStatus(0);
                    entity.setPlanQuarter((entity.getPlanMonth()+2)/3);
                }
                pilotSpecificScheduleManager.saveOrUpdateBatch(scheduleList);
            }
        }
    }

    @Transactional
    @Override
    public boolean  deleteMeasuresById(String id){
        Assert.notNull(id, "举措ID不能为空");
        QueryWrapper<PilotSpecificMeasuresHistory> queryWrapper = new QueryWrapper();
        queryWrapper.eq("SPECIFIC_MEASURES_ID_", id);
        pilotSpecificMeasuresHistoryManager.getBaseMapper().delete(queryWrapper);
        return this.removeById(id);
    }

    //操作日志
    public void createLog(IterationExamine examine) {
        List<String> ids = examine.getIds();
        List<AchieveStatusLogAndAuditResultVo> resultVoList=new ArrayList<>();
        ids.stream().forEach(p->{
            List<Integer> statusList = Arrays.asList(0,1, 3, 5);
            // 审批日志
            List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("shzt");
            AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
            logVo.setBizId(p);
            logVo.setModeType(2);
            logVo.setBizType("6-5");
            logVo.setModuleTableName("BIZ_PILOT_SPECIFIC_MEASURES_HISTORY");
            // 字典数据 shzt
            logVo.setStatus(String.valueOf(examine.getStatus()));
            logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, examine.getStatus()));
            //查询项目名
            PilotSpecificMeasuresHistory entity = pilotSpecificMeasuresHistoryManager.getById(p);
            MunicipalMajorProjectManagement project = municipalMajorProjectManagementManager.getOne(new QueryWrapper<MunicipalMajorProjectManagement>().eq("ID_",entity.getProjectId()).eq("IS_DELE_","0").last("LIMIT 1"));
            //根据审核状态进行判断
            if (com.artfess.base.util.BeanUtils.isNotEmpty(examine.getApprovalResults())&&examine.getApprovalResults()==2){

                    if (project!=null){
                        if (examine.getStatus()==0){
                        logVo.setItemTitle("【"+project.getProjectName()+"】" +"撤回为草稿" );
                        logVo.setOperateInfo("撤回为草稿");
                    }else if (examine.getStatus()==1){
                        logVo.setItemTitle("【"+project.getProjectName()+"】" +"撤回为提交待审核" );
                        logVo.setOperateInfo("撤回为提交待审核");
                    }else if (examine.getStatus()==3){
                        logVo.setItemTitle("【"+project.getProjectName()+"】" +"撤回为审核通过" );
                        logVo.setOperateInfo("撤回为审核通过");
                    }
                    logVo.setApprovalResults(2);
                    }
            }else {
                if (null == examine.getApprovalResults()&& statusList.contains(examine.getStatus())) {
                    logVo.setApprovalResults(0);
                } else {
                    logVo.setApprovalResults(1);
                }
                logVo.setItemTitle("【"+project.getProjectName()+"】"+ BizUtils.getDicValueByCode(shzt, examine.getStatus()));
                logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, examine.getStatus()));
            }

            if(examine.getStatus() == 5){
                logVo.setFinish(true);
            }else {
                logVo.setFinish(false);
            }
            //添加操作日志基本信息
            logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
            logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
            logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
            logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
            logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
            logVo.setOperateUserId(ContextUtil.getCurrentUserId());
            logVo.setOperateUserName(ContextUtil.getCurrentUserName());
            logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
            logVo.setOperateDate(LocalDateTime.now());
            logVo.setApprovalComments(examine.getApprovalComments());
            logVo.setModeType(0);
            logVo.setPriority(0);
            resultVoList.add(logVo);
        });
        achieveStatusLogManager.createAchieveStatusLogAndAuditResultBatch(resultVoList);
    }

    //判断是否满足记录操作日志条件
    private boolean check(IterationExamine iterationExamine) {
        List<String> ids = iterationExamine.getIds();
        for (String id : ids) {
            PilotSpecificMeasuresHistory entity = pilotSpecificMeasuresHistoryManager.getById(id);
            if (entity != null && entity.getStatus() == iterationExamine.getStatus()) {
                return false;
            }
        }
        return true;
    }

//    @Override
//    @Transactional
//      public void iterationCommit(IterationExamine iterationExamine) {
//        Assert.notNull(iterationExamine, "审核数据不能为空！");
//        Assert.notNull(iterationExamine.getIds(), "审核数据ID不能为空！");
//        Assert.notNull(iterationExamine.getStatus(), "审核数据不能为空！");
//        // 根据ID修改状态
//        UpdateWrapper<PilotSpecificMeasures> pilotSpecificMeasuresUpdateWrapper =  new UpdateWrapper<PilotSpecificMeasures>()
//                .set("STATUS_", iterationExamine.getStatus()).in("ID_", iterationExamine.getIds());
//        this.update(pilotSpecificMeasuresUpdateWrapper);
//        // 增加历史记录
//        QueryWrapper<PilotSpecificMeasures> pilotSpecificMeasuresQueryWrapper = new QueryWrapper<>();
//        pilotSpecificMeasuresQueryWrapper.in("ID_", iterationExamine.getIds());
//        List<PilotSpecificMeasures> pilotSpecificMeasuresList = this.list(pilotSpecificMeasuresQueryWrapper);
//        if (iterationExamine.getStatus()==2||iterationExamine.getStatus()==4){
//            pilotSpecificMeasuresHistoryManager.list(
//                    new QueryWrapper<PilotSpecificMeasuresHistory>());
//        }
//        // 如果审核全部通过，就将原来的数据移除，并将原始数据ID赋值给审核通过的数据
//        if(5 == iterationExamine.getStatus()){
//            for (PilotSpecificMeasures pilotSpecificMeasures : pilotSpecificMeasuresList){
//                // 责任单位跌代类型（0：责任单位新增，1：责任单位迭代【修改】），新增的措施不用处理，使用原始数据迭代的要处理
//                if(1 == pilotSpecificMeasures.getIteration()){
//                    // 1.根据原始数据的ID删除原始数据，及当前数据的parentID
////                    if(StringUtils.isNotBlank(pilotSpecificMeasures.getParentId())){
////                        this.baseMapper.deleteById(pilotSpecificMeasures.getParentId());
////                        // 2.将迭代通过后的ID设置为原始数据的ID，及parentId，因为子表与主表已经进行数据关联，所以需要将ID改为旧数据的ID
////                        UpdateWrapper<PilotSpecificMeasures> updateIdByOldIdWrapper =  new UpdateWrapper<PilotSpecificMeasures>()
////                                .set("ID_", pilotSpecificMeasures.getParentId()).eq("ID_", pilotSpecificMeasures.getId());
////                        this.update(updateIdByOldIdWrapper);
////                    }
//                    // 2.更新历史记录
//                    pilotSpecificMeasuresHistoryManager.saveHistoryByPilotSpecificMeasures(pilotSpecificMeasures);
//                }
//            }
//        }
//    }




//    @Override
//    public void iteration(List<PilotSpecificMeasuresHistory> historyList) {
//        Assert.notNull(historyList, "迭代数据不能为空！");
//
//        if (null != historyList && historyList.size() > 0) {
//            for (PilotSpecificMeasuresHistory history : historyList) {
//                if (history.getId() == null) {
//                    history.setIteration(0);
//                    history.setIterationDate(LocalDate.now());
//                }
//                if (history.getId() != null) {
//                    //当有id时
//                    PilotSpecificMeasuresHistory entity = pilotSpecificMeasuresHistoryManager.getById(history.getId());
//                    //分发类型为改革委下发时,且status为5
//                    if (entity.getDistributionType()==0&&entity.getStatus()==5){
//                        entity.setId(null);
//                        entity.setDistributionType(1);
//                        entity.setIteration(1);
//                    }
//                }
//                pilotSpecificMeasuresHistoryManager.saveOrUpdate(history);
//                List<PilotSpecificSchedule> scheduleList = history.getPilotSpecificScheduleList();
//               if (scheduleList.size()>0&&null!=scheduleList){
//               for (PilotSpecificSchedule pilotSpecificSchedule : scheduleList) {
//                pilotSpecificSchedule.setMeasuresId(history.getId());
//                pilotSpecificSchedule.setProjectId(history.getId());
//                pilotSpecificSchedule.setPlanQuarter((pilotSpecificSchedule.getPlanMonth()+2)/3);
//               }
//               pilotSpecificScheduleManager.saveOrUpdateBatch(scheduleList);
//            }
//        }
//        }
//            }
}

