package com.artfess.reform.majorProjects.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.vo.FillPushExamineVo;
import com.artfess.reform.majorProjects.vo.PilotProjectFillQueryVo;
import com.artfess.reform.majorProjects.vo.QuantitativeObjectivesPushFillQueryVo;

import java.time.LocalDate;

/**
 * 市级重大改革项目填报审核记录 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
public interface PilotProjectFillManager extends BaseManager<PilotProjectFill> {

    /**
     * @Description: 根据流程类型分页查询项目最新的流程填报情况
     * @param queryFilter
     * @param flowType 流程类型（1：量化目标审核流程2：月度计划审核流程，3：经验推广流程，4：品牌显示度流程）
     * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizBlockageCardTransfer>
     * @Author: chens
     * @Date: 2023/3/22 16:38
     */
    PageList<PilotProjectFill> queryPageFillList(QueryFilter<PilotProjectFill> queryFilter,Integer flowType);

    /**
     * @Description: 专项小组查询重大项目
     * @param queryFilter
     * @param flowType 流程类型（1：量化目标审核流程2：月度计划审核流程，3：经验推广流程，4：品牌显示度流程）
     * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizBlockageCardTransfer>
     * @Author: chens
     * @Date: 2023/3/22 16:38
     */
    PageList<PilotProjectFill> queryPageFillGroup(QueryFilter<PilotProjectFill> queryFilter,Integer flowType,String code);

//    /**
//     * 审批数据创建接口
//     * @param pilotProjectFillCreateVo
//     */
//    void saveVo(PilotProjectFillCreateVo pilotProjectFillCreateVo);
//
//    /**
//     * 审批数据提交接口
//     * @param pilotProjectFillCreateVo
//     */
//    void commitVo(PilotProjectFillCreateVo pilotProjectFillCreateVo);

    /**
     * 审批数据领导审核接口
     * @param fillPushExamineVo
     */
    void examineVo(FillPushExamineVo fillPushExamineVo);

    /**
     * 根据填报审核数据创建日志
     * @param pilotProjectFill
     * @param title
     */
    void createLog(PilotProjectFill pilotProjectFill, String title);

    /**
     * 审批数据分页查询接口
     * @param queryFilter
     */
    PageList<PilotProjectFillQueryVo> queyrList(QueryFilter<PilotProjectFill> queryFilter);

    /**
     * 审批数据分页查询接口
     * @param queryFilter
     */
    PageList<QuantitativeObjectivesPushFillQueryVo> queyrQuantitativeObjectivesPushFillList(QueryFilter<PilotProjectFill> queryFilter);

//
//    /**
//     * 根据ID查询详情
//     * @param id
//     * @return
//     */
//    PilotProjectFillQueryVo getDetails(String id);
//
//    /**
//     * 根据projectId查询审核上一次审核的历史数据详情
//     * @param projectId
//     * @return
//     */
//    PilotProjectFillQueryVo getHistoryDetails(String projectId);
//
//    /**
//     * 根据项目ID判断，是否有审核中的数据，true：有，false：没有
//     * @param projectId
//     * @return 是否有审核中的数据，true：有，false：没有
//     */
//    boolean haveExamine(String projectId);
//
//    /**
//     * 查询上一次填报保存的草稿详,没有草稿数据则返回空对象
//     * @param projectId 项目ID
//     * @return 返回填报对象，没有则返回空对象
//     */
//    PilotProjectFillQueryVo getDraftDetails(String projectId);

//    boolean updateByStatus(PilotProjectFill pilotProjectFill);


    /**
     * 根据项目ID查询上一次的审批填报记录
     * @param projectId
     * @return PilotProjectFill 填报对象
     */
    PilotProjectFill getHistoryPilotProjectFill(String projectId);

    /**
     * 根据项目ID和流程类型查询上一次的审批填报记录
     * @param projectId
     * @param flowType
     * @return
     */
    PilotProjectFill getHistoryPilotProjectFill(String projectId, Integer flowType);


    /**
     * 根据项目ID和流程类型查询上一次的审批填报记录
     * @param projectId
     * @param flowType
     * @return
     */
    PilotProjectFill getHistoryPilotProjectFill(String projectId, Integer flowType, LocalDate fillDate);
}
