package com.artfess.reform.majorProjects.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizReformDemandAssignmentRecord;
import com.artfess.reform.majorProjects.model.PilotExperiencePush;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.vo.PilotExperiencePushVo;

import java.util.List;

/**
 * 项目经验推广总结情况 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
public interface PilotExperiencePushManager extends BaseManager<PilotExperiencePush> {
    /**
     * 根据填报ID查询推进信息
     * @param id 填报ID
     * @return
     */
    List<PilotExperiencePush> queryListByFillId(String id);

    /**
     * 批量保存或更新
     * @param data
     */
    boolean saveOrUpdateList(List<PilotExperiencePush> data);


    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<PilotExperiencePush> queryByPage(QueryFilter<PilotExperiencePush> queryFilter);

    /**
     * 查询最新数据
     * @param queryFilter
     * @return
     */
    List<PilotProjectFill> queryHistory(QueryFilter<PilotProjectFill> queryFilter);


    /**
     * 根据ID查询详情
     * @param id 主键
     * @return
     */
    PilotExperiencePush detailedById(String id);

    /**
     * 根据ID批量删除
     * @param ids 主键集合
     * @return
     */
    boolean removeByIds(String ids);

    /**
     * 更新审核状态
     * @param pilotProjectFill
     * @return
     */
    boolean updateAuditStatus(PilotProjectFill pilotProjectFill);

    /**
     * 经验推广-保存草稿或提交
     * @param pilotExperiencePushVo
     * @return
     */
    void saveDraftOrCommit(PilotExperiencePushVo pilotExperiencePushVo);
}
