package com.artfess.reform.majorProjects.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.majorProjects.vo.FillPushExamineVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.majorProjects.model.BizMunicipalNotStartProjectManagement;
import com.artfess.reform.majorProjects.manager.BizMunicipalNotStartProjectManagementManager;

/**
 * 市级重大改革项目(谋划储备一批和准备启动一批)管理表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-10-17
 */
@RestController
@RequestMapping("/bizMunicipalNotSatrtProjectManagement/v1/")
@Api(tags = "市级重大改革项目两个一批管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMunicipalNotStartProjectManagementController extends BaseController<BizMunicipalNotStartProjectManagementManager, BizMunicipalNotStartProjectManagement> {

    @PostMapping("/queryByPage")
    @ApiOperation("查询下发的数据")
    public PageList<BizMunicipalNotStartProjectManagement> queryByPage(@RequestBody QueryFilter<BizMunicipalNotStartProjectManagement> queryFilter, @RequestParam("isAffirm") Boolean isAffirm) {
        queryFilter.addFilter("m.STATUS_",1, QueryOP.EQUAL);
        PageList<BizMunicipalNotStartProjectManagement> list = baseService.queryByPage(queryFilter,isAffirm);
        return list;
    }

    @PostMapping("/updateById")
    @ApiOperation("修改分发状态")
    public CommonResult updateById(@RequestBody FillPushExamineVo fillVo) {
        boolean res = baseService.updateById(fillVo);
        return new CommonResult(res,res?"修改成功":"修改失败");
    }
}
